/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import ch.digitalfondue.jfiveparse.Comment;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.JFiveParse;
import ch.digitalfondue.jfiveparse.Node;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.TextComparator;

@Component(role=ContentsComparator.class, hint="html")
public class HtmlComparator
implements ContentsComparator {
    private static final String META_ELEMENT = "meta";
    private static final String LINK_ELEMENT = "link";
    private static final String SCRIPT_ELEMENT = "script";
    private static final String HEAD_ELEMENT = "head";
    static final String HINT = "html";

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        try {
            Document baselineDoc = JFiveParse.parse((String)baseline.asString(StandardCharsets.UTF_8));
            Document reactorDoc = JFiveParse.parse((String)reactor.asString(StandardCharsets.UTF_8));
            if (this.isJavadocHtml(baselineDoc)) {
                this.cleanJavaDoc(baselineDoc.getDocumentElement());
                this.cleanJavaDoc(reactorDoc.getDocumentElement());
                String serializeBaseline = this.serializeAndNormalize(baselineDoc);
                String serializeReactor = this.serializeAndNormalize(reactorDoc);
                if (serializeBaseline.equalsIgnoreCase(serializeReactor)) {
                    return ArtifactDelta.NO_DIFFERENCE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TextComparator.compareText(baseline, reactor, data);
    }

    private String serializeAndNormalize(Document baselineDoc) {
        return JFiveParse.serialize((Node)baselineDoc).replaceAll("\\s+", " ").replace("\r", "").replace("\n", "").replace("> <", "><");
    }

    private void cleanJavaDoc(Element root) {
        for (Element headElement : root.getElementsByTagName(HEAD_ELEMENT)) {
            for (Node node : (Node[])headElement.getChildNodes().toArray(Node[]::new)) {
                Element element;
                String nodeName;
                if (node instanceof Element && (SCRIPT_ELEMENT.equalsIgnoreCase(nodeName = (element = (Element)node).getNodeName()) || LINK_ELEMENT.equalsIgnoreCase(nodeName) || META_ELEMENT.equals(nodeName))) {
                    headElement.removeChild(node);
                }
                if (!(node instanceof Comment)) continue;
                Comment comment = (Comment)node;
                headElement.removeChild(node);
            }
        }
        root.removeAttribute("lang");
    }

    private boolean isJavadocHtml(Document doc) {
        List elementsByTagName = doc.getDocumentElement().getElementsByTagName(HEAD_ELEMENT);
        for (Element element : elementsByTagName) {
            for (Node node : element.getChildNodes()) {
                Comment comment;
                String data;
                if (!(node instanceof Comment) || (data = (comment = (Comment)node).getData()) == null || !data.trim().toLowerCase().startsWith("generated by javadoc")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(String nameOrExtension) {
        return HINT.equalsIgnoreCase(nameOrExtension) || "htm".equalsIgnoreCase(nameOrExtension);
    }
}

