/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ContentsComparator.class, hint="properties")
public class PropertiesComparator
implements ContentsComparator {
    public static final String TYPE = "properties";

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        TreeMap<String, ArtifactDelta> result = new TreeMap<String, ArtifactDelta>();
        Properties props = new Properties();
        props.load(baseline);
        Properties props2 = new Properties();
        props2.load(reactor);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        this.addAll(names, props);
        this.addAll(names, props2);
        for (String name : names) {
            String value = props.getProperty(name);
            if (value == null) {
                result.put(name, ArtifactDelta.MISSING_FROM_BASELINE);
                continue;
            }
            String value2 = props2.getProperty(name);
            if (value2 == null) {
                result.put(name, ArtifactDelta.BASELINE_ONLY);
                continue;
            }
            if (value.equals(value2)) continue;
            result.put(name, new SimpleArtifactDelta("baseline='" + value + "' != reactor='" + value2 + "'"));
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("properties files differ", result) : null;
    }

    private void addAll(Set<String> names, Properties props) {
        for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
            Object key = propEntry.getKey();
            Object value = propEntry.getValue();
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            if (!(value instanceof String)) continue;
            names.add(keyString);
        }
    }

    @Override
    public boolean matches(String extension) {
        return TYPE.equalsIgnoreCase(extension) || "bnd".equalsIgnoreCase(extension) || "mappings".equalsIgnoreCase(extension);
    }
}

