/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class EcJLogFileEnhancer
implements AutoCloseable {
    public static final String SEVERITY_ERROR = "ERROR";
    public static final String SEVERITY_WARNING = "WARNING";
    private static final String ATTRIBUTES_WARNINGS = "warnings";
    private static final String ELEMENT_PROBLEMS = "problems";
    private static final String ATTRIBUTES_PROBLEMS = "problems";
    private static final String ATTRIBUTES_INFOS = "infos";
    private static final String ATTRIBUTES_ERRORS = "errors";
    private Set<File> needsUpdate = new HashSet<File>();
    private Map<File, Document> documents;

    private EcJLogFileEnhancer(Map<File, Document> documents) {
        this.documents = documents;
    }

    public Stream<Source> sources() {
        return this.documents.entrySet().stream().flatMap(documentEntry -> {
            Document document = (Document)documentEntry.getValue();
            Element statsElement = EcJLogFileEnhancer.getStatsElement(document);
            File file = (File)documentEntry.getKey();
            return document.getRootElement().getChildren("sources").stream().flatMap(sources -> sources.getChildren("source").stream()).map(source -> new Source((Element)source, statsElement, () -> this.needsUpdate.add(file)));
        });
    }

    @Override
    public void close() throws IOException {
        EcJLogFileEnhancer.writeDocuments(this.needsUpdate, this.documents);
    }

    public static EcJLogFileEnhancer create(File logDirectory) throws IOException {
        Map<File, Document> documents = EcJLogFileEnhancer.readDocuments(logDirectory);
        return new EcJLogFileEnhancer(documents);
    }

    private static Element getStatsElement(Document document) {
        for (Element stats : document.getRootElement().getChildren("stats")) {
            Iterator iterator = stats.getChildren("problem_summary").iterator();
            if (!iterator.hasNext()) continue;
            Element problem_summary = (Element)iterator.next();
            return problem_summary;
        }
        return null;
    }

    private static void incrementAttribute(Element element, String attribute, int increment) {
        if (increment > 0) {
            int current = Integer.parseInt(element.getAttributeValue(attribute));
            element.setAttribute(attribute, Integer.toString(current + increment));
        }
    }

    private static void writeDocuments(Set<File> needsUpdate, Map<File, Document> documents) throws IOException, FileNotFoundException {
        for (File file : needsUpdate) {
            Document document = documents.get(file);
            BufferedWriter w = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            try (XMLWriter xw = new XMLWriter((Writer)w);){
                document.toXML(xw);
            }
            finally {
                if (w == null) continue;
                ((Writer)w).close();
            }
        }
    }

    private static Map<File, Document> readDocuments(File logDirectory) throws IOException {
        XMLParser parser = new XMLParser();
        HashMap<File, Document> documents = new HashMap<File, Document>();
        for (File child : logDirectory.listFiles()) {
            if (!child.getName().toLowerCase().endsWith(".xml")) continue;
            documents.put(child, parser.parse((XMLSource)new XMLIOSource(child)));
        }
        return documents;
    }

    private static Element getProblemsElement(Element source) {
        Element element = source.getChild("problems");
        if (element == null) {
            element = new Element("problems");
            element.setAttribute(ATTRIBUTES_ERRORS, "0");
            element.setAttribute(ATTRIBUTES_INFOS, "0");
            element.setAttribute("problems", "0");
            element.setAttribute(ATTRIBUTES_WARNINGS, "0");
            source.addNode(0, (Node)element);
        }
        return element;
    }

    public static class Source {
        private Element source;
        private Element statsElement;
        private Runnable needsUpdate;

        Source(Element source, Element statsElement, Runnable needsUpdate) {
            this.source = source;
            this.statsElement = statsElement;
            this.needsUpdate = needsUpdate;
        }

        public String getPath() {
            return this.source.getAttributeValue("path");
        }

        public String getOutputDirectory() {
            return this.source.getAttributeValue("output");
        }

        public String getPackage() {
            return this.source.getAttributeValue("package");
        }

        public void addProblem(String severity, int lineNumber, int charStart, int charEnd, int categoryId, int problemId, String message) {
            Element problemsElement = EcJLogFileEnhancer.getProblemsElement(this.source);
            Element element = new Element("problem");
            element.setAttribute("line", Integer.toString(lineNumber));
            element.setAttribute("severity", severity);
            element.setAttribute("id", Integer.toString(problemId));
            element.setAttribute("charStart", Integer.toString(charStart));
            element.setAttribute("charEnd", Integer.toString(charEnd));
            element.setAttribute("categoryID", Integer.toString(categoryId));
            element.setAttribute("problemID", Integer.toString(problemId));
            Element messageElement = new Element("message");
            messageElement.setAttribute("value", message);
            element.addNode((Node)messageElement);
            EcJLogFileEnhancer.incrementAttribute(problemsElement, "problems", 1);
            if (EcJLogFileEnhancer.SEVERITY_ERROR.equals(severity)) {
                EcJLogFileEnhancer.incrementAttribute(problemsElement, EcJLogFileEnhancer.ATTRIBUTES_ERRORS, 1);
            }
            if (EcJLogFileEnhancer.SEVERITY_WARNING.equals(severity)) {
                EcJLogFileEnhancer.incrementAttribute(problemsElement, EcJLogFileEnhancer.ATTRIBUTES_WARNINGS, 1);
            }
            if (this.statsElement != null) {
                EcJLogFileEnhancer.incrementAttribute(this.statsElement, "problems", 1);
                if (EcJLogFileEnhancer.SEVERITY_ERROR.equals(severity)) {
                    EcJLogFileEnhancer.incrementAttribute(this.statsElement, EcJLogFileEnhancer.ATTRIBUTES_ERRORS, 1);
                }
                if (EcJLogFileEnhancer.SEVERITY_WARNING.equals(severity)) {
                    EcJLogFileEnhancer.incrementAttribute(this.statsElement, EcJLogFileEnhancer.ATTRIBUTES_WARNINGS, 1);
                }
            }
            problemsElement.addNode((Node)element);
            this.needsUpdate.run();
        }

        public boolean hasClass(String classFile) {
            return this.source.getChildren("classfile").stream().map(elem -> elem.getAttributeValue("path")).filter(Objects::nonNull).anyMatch(path -> path.endsWith(classFile));
        }
    }
}

