/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;

public class MarkdownBuilder {
    private final List<String> lines = new ArrayList<String>();
    private Path output;

    public MarkdownBuilder(File output) {
        this(output == null ? (Path)null : output.toPath());
    }

    public MarkdownBuilder(Path output) {
        this.output = output;
    }

    public MarkdownBuilder add(String string) {
        this.lines.add(MarkdownBuilder.escape(string));
        return this;
    }

    public MarkdownBuilder addListItem(String item) {
        this.lines.add("- " + MarkdownBuilder.escape(item));
        return this;
    }

    public MarkdownBuilder addListItem2(String item) {
        this.lines.add("  - " + MarkdownBuilder.escape(item));
        return this;
    }

    public static String escape(String item) {
        return item.replace("@", "<span>@</span>").replace("#", "<span>#</span>");
    }

    public void write() throws MojoFailureException {
        if (this.output == null) {
            return;
        }
        try {
            Files.createDirectories(this.output.getParent(), new FileAttribute[0]);
            Files.writeString(this.output, (CharSequence)this.lines.stream().collect(Collectors.joining(System.lineSeparator())), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException((Throwable)e);
        }
    }

    public void newLine() {
        this.lines.add("");
    }

    public void h1(String string) {
        this.lines.add("# " + MarkdownBuilder.escape(string));
        this.lines.add("");
    }

    public void h2(String string) {
        this.lines.add("## " + MarkdownBuilder.escape(string));
        this.lines.add("");
    }

    public void h3(String string) {
        this.lines.add("### " + MarkdownBuilder.escape(string));
        this.lines.add("");
    }

    public void h4(String string) {
        this.lines.add("#### " + MarkdownBuilder.escape(string));
        this.lines.add("");
    }
}

