/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.core.VerifierService;
import org.eclipse.tycho.p2.tools.FacadeException;

@Component(role=VerifierService.class)
public class VerifierServiceImpl
implements VerifierService {
    private final NullProgressMonitor monitor = new NullProgressMonitor();
    @Requirement
    IProvisioningAgent agent;
    @Requirement
    Logger logger;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean verify(URI metadataRepositoryUri, URI artifactRepositoryUri, BuildDirectory tempDirectory) throws FacadeException {
        this.logger.debug("Checking metadata from '" + String.valueOf(metadataRepositoryUri) + "' and artifacts from '" + String.valueOf(artifactRepositoryUri) + "'");
        try {
            IMetadataRepository metadata = this.loadMetadataRepository(metadataRepositoryUri, this.agent);
            IArtifactRepository artifactRepository = this.loadArtifactRepository(artifactRepositoryUri, this.agent);
            boolean valid = true;
            valid &= this.verifyReferencedArtifactsExist(metadata, artifactRepository, this.logger);
            if (valid &= this.verifyAllArtifactContent(artifactRepository, this.logger)) {
                this.logger.info("The integrity of the metadata repository '" + String.valueOf(metadataRepositoryUri) + "' and artifact repository '" + String.valueOf(artifactRepositoryUri) + "' has been verified successfully");
            }
            return valid;
        }
        catch (ProvisionException e) {
            throw new FacadeException(e);
        }
    }

    private boolean verifyReferencedArtifactsExist(IMetadataRepository metadata, IArtifactRepository artifactRepository, Logger logger) {
        IQueryResult collector = metadata.query(QueryUtil.ALL_UNITS, (IProgressMonitor)this.monitor);
        boolean valid = true;
        Set set = collector.toSet();
        logger.debug("Verifying content of " + set.size() + " units");
        for (IInstallableUnit iu : set) {
            Collection artifacts = iu.getArtifacts();
            for (IArtifactKey key : artifacts) {
                boolean verifyArtifactExists = this.verifyArtifactExists(key, artifactRepository, logger);
                logger.debug("Verify " + String.valueOf(key) + " exits: " + verifyArtifactExists);
                valid &= verifyArtifactExists;
            }
        }
        return valid;
    }

    private boolean verifyArtifactExists(IArtifactKey key, IArtifactRepository repository, Logger logger) {
        IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors(key);
        if (descriptors.length == 0) {
            logger.error("Missing artifact: " + String.valueOf(key));
            return false;
        }
        return true;
    }

    private boolean verifyAllArtifactContent(IArtifactRepository repository, Logger logger) {
        boolean valid = true;
        IQueryResult allKeys = repository.query((IQuery)new ExpressionMatchQuery(IArtifactKey.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]), null);
        Set set = allKeys.toSet();
        logger.debug("Verifying content of " + set.size() + " artifacts");
        for (IArtifactKey key : set) {
            IArtifactDescriptor[] descriptors;
            for (IArtifactDescriptor descriptor : descriptors = repository.getArtifactDescriptors(key)) {
                boolean verifyArtifactContent = this.verifyArtifactContent(repository, logger, descriptor);
                logger.debug("Verifying artifact content " + String.valueOf(descriptor) + ": " + verifyArtifactContent);
                valid &= verifyArtifactContent;
            }
        }
        return valid;
    }

    private boolean verifyArtifactContent(IArtifactRepository repository, Logger logger, IArtifactDescriptor descriptor) {
        IStatus status = repository.getArtifact(descriptor, OutputStream.nullOutputStream(), (IProgressMonitor)this.monitor);
        if (!status.isOK()) {
            this.logStatus(status, "", (arg_0, arg_1) -> ((Logger)logger).error(arg_0, arg_1));
        } else {
            this.logStatus(status, "", (arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1));
        }
        return status.isOK();
    }

    private void logStatus(IStatus status, String indent, BiConsumer<String, Throwable> logger) {
        Throwable exception = status.getException();
        if (exception == null) {
            logger.accept(indent + status.getMessage(), null);
        } else {
            logger.accept(indent + status.getMessage() + ": " + exception.getLocalizedMessage(), exception);
        }
        for (IStatus kid : status.getChildren()) {
            this.logStatus(kid, indent + "  ", logger);
        }
    }

    private IMetadataRepository loadMetadataRepository(URI metadataRepository, IProvisioningAgent agent) throws ProvisionException {
        IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
        return repositoryManager.loadRepository(metadataRepository, (IProgressMonitor)this.monitor);
    }

    private IArtifactRepository loadArtifactRepository(URI artifactRepository, IProvisioningAgent agent) throws ProvisionException {
        IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
        return repositoryManager.loadRepository(artifactRepository, (IProgressMonitor)this.monitor);
    }
}

