/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.bnd;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

class SourceCodeAnalyzerPlugin
implements AnalyzerPlugin {
    private static final String PACKAGE_INFO = "package-info";
    private static final String ANNOTATION_VERSION = "org.osgi.annotation.versioning.Version";
    private static final String ANNOTATION_EXPORT = "org.osgi.annotation.bundle.Export";
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private List<Path> sourcePaths;
    private Map<Descriptors.PackageRef, Clazz> packageInfoMap = new HashMap<Descriptors.PackageRef, Clazz>();

    public SourceCodeAnalyzerPlugin(List<Path> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public boolean analyzeJar(final Analyzer analyzer) throws Exception {
        final ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        final HashSet seenPackages = new HashSet();
        final HashSet analyzedPath = new HashSet();
        for (Path sourcePath : this.sourcePaths) {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    boolean packageInfo;
                    String fileName = file.getFileName().toString().toLowerCase();
                    if (fileName.endsWith(".java") && ((packageInfo = fileName.equals(SourceCodeAnalyzerPlugin.PACKAGE_INFO_JAVA)) || analyzedPath.add(file.getParent()))) {
                        CompilationUnit cu;
                        PackageDeclaration packageDecl;
                        String source = Files.readString(file);
                        parser.setSource(source.toCharArray());
                        ASTNode ast = parser.createAST(null);
                        if (ast instanceof CompilationUnit && (packageDecl = (cu = (CompilationUnit)ast).getPackage()) != null) {
                            String packageFqdn = packageDecl.getName().getFullyQualifiedName();
                            Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageFqdn);
                            if (seenPackages.add(packageFqdn)) {
                                analyzer.getContained().put(packageRef);
                            }
                            if (packageInfo) {
                                JDTClazz clazz = new JDTClazz(analyzer, packageRef.getBinary() + "/package-info.class", (Resource)new FileResource(file), analyzer.getTypeRef(packageRef.getBinary() + "/package-info"));
                                boolean export = false;
                                String version = null;
                                for (Object raw : packageDecl.annotations()) {
                                    if (!(raw instanceof Annotation)) continue;
                                    Annotation annot = (Annotation)raw;
                                    String annotationFqdn = annot.getTypeName().getFullyQualifiedName();
                                    if (SourceCodeAnalyzerPlugin.ANNOTATION_EXPORT.equals(annotationFqdn)) {
                                        export = true;
                                        clazz.addAnnotation(analyzer.getTypeRef(SourceCodeAnalyzerPlugin.ANNOTATION_EXPORT.replace('.', '/')));
                                        continue;
                                    }
                                    if (!SourceCodeAnalyzerPlugin.ANNOTATION_VERSION.equals(annotationFqdn)) continue;
                                    if (annot instanceof NormalAnnotation) {
                                        NormalAnnotation normal = (NormalAnnotation)annot;
                                        for (Object vp : normal.values()) {
                                            MemberValuePair pair = (MemberValuePair)vp;
                                            if (!"value".equals(pair.getName().getFullyQualifiedName())) continue;
                                            StringLiteral value = (StringLiteral)pair.getValue();
                                            version = value.getLiteralValue();
                                        }
                                        continue;
                                    }
                                    if (!(annot instanceof SingleMemberAnnotation)) continue;
                                    SingleMemberAnnotation single = (SingleMemberAnnotation)annot;
                                    StringLiteral value = (StringLiteral)single.getValue();
                                    version = value.getLiteralValue();
                                }
                                if (export) {
                                    SourceCodeAnalyzerPlugin.this.packageInfoMap.put(packageRef, clazz);
                                    if (version == null) {
                                        analyzer.getContained().put(packageRef);
                                    } else {
                                        analyzer.getContained().put(packageRef, Attrs.create((String)"version", version));
                                    }
                                }
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return false;
    }

    Clazz getPackageInfo(Descriptors.PackageRef packageRef) {
        return this.packageInfoMap.get(packageRef);
    }

    private static final class JDTClazz
    extends Clazz {
        private Set<Descriptors.TypeRef> annotations = new HashSet<Descriptors.TypeRef>();
        private Descriptors.TypeRef className;

        public JDTClazz(Analyzer analyzer, String path, Resource resource, Descriptors.TypeRef className) {
            super(analyzer, path, resource);
            this.className = className;
        }

        public Descriptors.TypeRef getClassName() {
            return this.className;
        }

        public void addAnnotation(Descriptors.TypeRef typeRef) {
            this.annotations.add(typeRef);
        }

        public Set<Descriptors.TypeRef> annotations() {
            return this.annotations;
        }
    }
}

