/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.tycho.ExecutionEnvironment;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.core.ee.impl.StandardEEResolutionHints;

public class AllKnownEEsResolutionHints
implements ExecutionEnvironmentResolutionHints {
    private final Map<VersionedId, IInstallableUnit> temporaryUnits = new LinkedHashMap<VersionedId, IInstallableUnit>();

    public AllKnownEEsResolutionHints(Collection<ExecutionEnvironment> allKnownEEs) {
        for (ExecutionEnvironment ee : allKnownEEs) {
            StandardEEResolutionHints.addIUsFromEnvironment(ee, this.temporaryUnits);
        }
    }

    public Collection<IInstallableUnit> getMandatoryUnits() {
        return Collections.emptyList();
    }

    public boolean isNonApplicableEEUnit(IInstallableUnit iu) {
        return iu.getId().startsWith("a.jre") || iu.getId().startsWith("config.a.jre");
    }

    public boolean isEESpecificationUnit(IInstallableUnit unit) {
        throw new UnsupportedOperationException();
    }

    public Collection<IRequirement> getMandatoryRequires() {
        return Collections.emptyList();
    }

    public Collection<IInstallableUnit> getTemporaryAdditions() {
        return this.temporaryUnits.values();
    }

    public int hashCode() {
        return Objects.hash(this.temporaryUnits);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllKnownEEsResolutionHints other = (AllKnownEEsResolutionHints)obj;
        return Objects.equals(this.temporaryUnits, other.temporaryUnits);
    }
}

