/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.core.ee.impl.InvalidEENameException;

public final class CustomEEResolutionHints
implements ExecutionEnvironmentResolutionHints {
    private final String eeName;
    private transient String unitName;
    private transient Version unitVersion;

    public CustomEEResolutionHints(String eeName) throws InvalidEENameException {
        this.eeName = eeName;
        this.parse(eeName);
    }

    void parse(String eeName) throws InvalidEENameException {
        int idx = eeName.indexOf(45);
        if (idx == -1) {
            throw new InvalidEENameException(eeName);
        }
        String name = eeName.substring(0, idx);
        name = name.replace('/', '.');
        name = name.replace('_', '.');
        this.unitName = "a.jre." + name.toLowerCase(Locale.ENGLISH);
        String version = eeName.substring(idx + 1);
        try {
            this.unitVersion = Version.create((String)version);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidEENameException(eeName);
        }
    }

    public boolean isEESpecificationUnit(IInstallableUnit unit) {
        return this.unitName.equals(unit.getId()) && unit.getVersion().equals(this.unitVersion);
    }

    public boolean isNonApplicableEEUnit(IInstallableUnit iu) {
        return ExecutionEnvironmentResolutionHints.isJreUnit((IInstallableUnit)iu) && !this.isEESpecificationUnit(iu);
    }

    public Collection<IInstallableUnit> getMandatoryUnits() {
        return Collections.emptyList();
    }

    public Collection<IInstallableUnit> getTemporaryAdditions() {
        return Collections.emptyList();
    }

    public Collection<IRequirement> getMandatoryRequires() {
        VersionRange strictUnitRange = new VersionRange(this.unitVersion, true, this.unitVersion, true);
        return Collections.singleton(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)this.unitName, (VersionRange)strictUnitRange, null, (boolean)false, (boolean)false));
    }

    public int hashCode() {
        return Objects.hash(this.eeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CustomEEResolutionHints)) return false;
        CustomEEResolutionHints other = (CustomEEResolutionHints)obj;
        if (!Objects.equals(this.eeName, other.eeName)) return false;
        return true;
    }
}

