/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.MavenArtifactRepositoryReference;
import org.eclipse.tycho.MavenDependencyDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.targetplatform.TargetDefinition;

public final class MavenDependencyInjector {
    private final BundleReader bundleReader;
    private final Logger logger;
    private final MavenProject project;
    private final boolean fetch;
    private Function<ArtifactDescriptor, MavenDependencyDescriptor> descriptorMapping;
    private static File fileNotYetAvailable;

    public static void injectMavenProjectDependencies(MavenProject project, Iterable<MavenProject> dependencyProjects) {
        Model model = project.getModel();
        Set existingDependencies = model.getDependencies().stream().map(MavenDependencyInjector::getProjectKey).collect(Collectors.toCollection(HashSet::new));
        for (MavenProject dependencyProject : dependencyProjects) {
            if (dependencyProject == project) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(dependencyProject.getArtifactId());
            dependency.setGroupId(dependencyProject.getGroupId());
            dependency.setVersion(dependencyProject.getVersion());
            String packaging = dependencyProject.getPackaging();
            dependency.setType(packaging);
            dependency.setScope("compile");
            dependency.setOptional(false);
            if (!existingDependencies.add(MavenDependencyInjector.getProjectKey(dependency))) continue;
            model.addDependency(dependency);
        }
    }

    private static String getProjectKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + Objects.requireNonNullElse(dependency.getType(), "jar") + ":" + dependency.getVersion() + ":" + Objects.requireNonNullElse(dependency.getClassifier(), "");
    }

    public static void injectMavenDependencies(MavenProject project, DependencyArtifacts dependencies, DependencyArtifacts testDependencies, BundleReader bundleReader, Function<ArtifactDescriptor, MavenDependencyDescriptor> descriptorMapping, Logger logger, RepositorySystem repositorySystem, Settings settings, BuildPropertiesParser buildPropertiesParser, TargetPlatformConfiguration configuration) {
        MavenDependencyInjector generator = new MavenDependencyInjector(project, bundleReader, descriptorMapping, logger);
        for (ArtifactDescriptor artifact : dependencies.getArtifacts()) {
            generator.addDependency(artifact, "compile");
        }
        if (testDependencies != null) {
            testDependencies.getArtifacts().stream().filter(testDep -> dependencies.getArtifact(testDep.getKey()) == null).forEach(descriptor -> generator.addDependency((ArtifactDescriptor)descriptor, "test"));
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        BuildProperties buildProperties = buildPropertiesParser.parse(reactorProject);
        List<Dependency> extraJars = buildProperties.getJarsExtraClasspath().stream().map(extra -> {
            if (TychoConstants.PLATFORM_URL_PATTERN.matcher((CharSequence)extra).matches()) {
                return null;
            }
            Dependency dependency = new Dependency();
            dependency.setScope("system");
            dependency.setGroupId(project.getGroupId());
            dependency.setArtifactId(project.getArtifactId() + ".jars.extra.classpath");
            dependency.setClassifier(extra);
            File file = new File(reactorProject.getBasedir(), (String)extra);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    return null;
                }
            }
            dependency.setSystemPath(file.getAbsolutePath());
            dependency.setVersion(project.getVersion());
            return dependency;
        }).filter(Objects::nonNull).toList();
        generator.addDependencyList(extraJars);
        List repositoryReferences = configuration.getTargets().stream().flatMap(definition -> definition.getLocations().stream()).filter(TargetDefinition.MavenGAVLocation.class::isInstance).map(TargetDefinition.MavenGAVLocation.class::cast).flatMap(location -> location.getRepositoryReferences().stream()).toList();
        if (repositoryReferences != null && !repositoryReferences.isEmpty()) {
            Map repositoryMap = project.getRemoteArtifactRepositories().stream().collect(Collectors.toMap(MavenDependencyInjector::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new));
            for (MavenArtifactRepositoryReference reference : repositoryReferences) {
                String id = MavenDependencyInjector.getId(reference);
                ArtifactRepository artifactRepository = (ArtifactRepository)repositoryMap.get(id);
                if (artifactRepository == null) {
                    repositoryMap.put(id, repositorySystem.createArtifactRepository(id, reference.getUrl(), null, null, null));
                    continue;
                }
                if (artifactRepository.getUrl().equals(reference.getUrl())) continue;
                logger.warn("Target defines an artifact repository with the ID " + id + " but there is already a repository for that ID mapped to a different URL! (target URL = " + reference.getUrl() + ", existing URL = " + artifactRepository.getUrl());
            }
            ArrayList artifactRepositories = new ArrayList(repositoryMap.values());
            repositorySystem.injectMirror(artifactRepositories, settings.getMirrors());
            repositorySystem.injectProxy(artifactRepositories, settings.getProxies());
            repositorySystem.injectAuthentication(artifactRepositories, settings.getServers());
            project.setRemoteArtifactRepositories(artifactRepositories);
        }
    }

    private static String getId(MavenArtifactRepositoryReference reference) {
        String id = reference.getId();
        if (id == null || id.isBlank()) {
            return reference.getUrl();
        }
        return id;
    }

    private static String getId(ArtifactRepository repository) {
        String id = repository.getId();
        if (id == null || id.isBlank()) {
            return repository.getUrl();
        }
        return id;
    }

    MavenDependencyInjector(MavenProject project, BundleReader bundleReader, Function<ArtifactDescriptor, MavenDependencyDescriptor> descriptorMapping, Logger logger) {
        this.project = project;
        this.fetch = "eclipse-plugin".equals(project.getPackaging()) || "eclipse-test-plugin".equals(project.getPackaging());
        this.bundleReader = bundleReader;
        this.descriptorMapping = descriptorMapping;
        this.logger = logger;
    }

    void addDependency(ArtifactDescriptor artifact, String scope) {
        String key;
        List<Dependency> dependencyList = artifact.getMavenProject() != null ? this.collectProjectDependencies(artifact, scope) : this.collectExternalDependencies(artifact, scope, true);
        this.addDependencyList(dependencyList);
        Map projectReferences = this.project.getProjectReferences();
        ReactorProject mavenProject = artifact.getMavenProject();
        if (mavenProject != null && DefaultReactorProject.adapt(this.project) != mavenProject && !projectReferences.containsKey(key = mavenProject.getGroupId() + ':' + mavenProject.getArtifactId() + ':' + mavenProject.getVersion())) {
            this.logger.debug("Found a P2 dependency (" + String.valueOf(artifact) + ") that is not reflected in the maven model project references");
        }
    }

    private void addDependencyList(List<Dependency> dependencyList) {
        if (dependencyList.isEmpty()) {
            return;
        }
        Model model = this.project.getModel();
        Set existing = model.getDependencies().stream().map(MavenDependencyInjector::getKey).collect(Collectors.toCollection(HashSet::new));
        for (Dependency dependency : dependencyList) {
            if (!existing.add(MavenDependencyInjector.getKey(dependency))) continue;
            model.addDependency(dependency);
        }
    }

    private static String getKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType() + ":" + dependency.getVersion() + ":" + Objects.requireNonNullElse(dependency.getClassifier(), "");
    }

    private List<Dependency> collectExternalDependencies(ArtifactDescriptor artifact, String scope, boolean retryFailed) {
        File location = artifact.getLocation(this.fetch);
        try {
            if ("eclipse-plugin".equals(artifact.getKey().getType())) {
                if (location == null || !location.isFile() || !location.canRead()) {
                    if (location != null && location.isDirectory()) {
                        this.logger.warn("Exploded plugin at location " + String.valueOf(location) + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins.");
                        return Collections.emptyList();
                    }
                    Dependency p2Dependency = this.createP2Dependency(artifact, location, scope);
                    if (p2Dependency == null) {
                        this.logger.warn(String.valueOf(artifact) + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins.");
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(p2Dependency);
                }
                ArrayList<Dependency> result = new ArrayList<Dependency>();
                for (String classpathElement : this.getClasspathElements(location)) {
                    if (".".equals(classpathElement)) {
                        result.add(this.createP2Dependency(artifact, location, scope));
                        continue;
                    }
                    File nestedJarOrDir = this.bundleReader.getEntry(location, classpathElement);
                    if (nestedJarOrDir == null) continue;
                    if (nestedJarOrDir.isFile()) {
                        Dependency nestedJarDependency = this.createP2Dependency(artifact, nestedJarOrDir, "system");
                        nestedJarDependency.setClassifier(classpathElement);
                        result.add(nestedJarDependency);
                        continue;
                    }
                    if (!nestedJarOrDir.isDirectory()) continue;
                    this.logger.debug("Dependency from " + String.valueOf(this.project.getBasedir()) + " to nested directory classpath entry " + String.valueOf(nestedJarOrDir) + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins");
                }
                return result;
            }
            return Collections.singletonList(this.createP2Dependency(artifact, location, scope));
        }
        catch (OsgiManifestParserException e) {
            if (location != null && retryFailed && location.isFile() && e.getCause() instanceof ZipException) {
                this.logger.warn("Artifact " + String.valueOf(artifact) + " located at " + String.valueOf(location) + " seems corrupted! Will attempt to download it again");
                location.delete();
                return this.collectExternalDependencies(artifact, scope, false);
            }
            throw e;
        }
    }

    private String[] getClasspathElements(File bundleLocation) {
        return this.bundleReader.loadManifest(bundleLocation).getBundleClasspath();
    }

    private Dependency createP2Dependency(ArtifactDescriptor descriptor, File location, String scope) {
        ArtifactKey artifactKey = descriptor.getKey();
        return this.createScopedDependency(descriptor, "p2." + artifactKey.getType().replace('-', '.'), location, scope);
    }

    private Dependency createScopedDependency(ArtifactDescriptor descriptor, String groupId, File location, String scope) {
        MavenDependencyDescriptor dependencyDescriptor;
        ArtifactDescriptorDependency dependency = new ArtifactDescriptorDependency(descriptor);
        MavenDependencyDescriptor mavenDependencyDescriptor = dependencyDescriptor = this.descriptorMapping == null ? null : this.descriptorMapping.apply(descriptor);
        if (dependencyDescriptor != null && MavenDependencyInjector.isValidMavenDescriptor(dependencyDescriptor)) {
            dependency.setGroupId(dependencyDescriptor.getGroupId());
            dependency.setArtifactId(dependencyDescriptor.getArtifactId());
            dependency.setVersion(dependencyDescriptor.getVersion());
            dependency.setClassifier(dependency.getClassifier());
            String type = dependencyDescriptor.getType();
            if (type != null && !type.isBlank()) {
                dependency.setType(type);
            } else {
                dependency.setType(descriptor.getKey().getType());
            }
            dependency.setScope(scope);
        } else {
            ArtifactKey artifactKey = descriptor.getKey();
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactKey.getId());
            dependency.setVersion(artifactKey.getVersion());
            dependency.setScope("system");
            dependency.setType(artifactKey.getType());
        }
        if ("system".equals(dependency.getScope())) {
            dependency.setSystemPath(location != null && location.isFile() ? location.getAbsolutePath() : MavenDependencyInjector.fileNotAvailable());
        }
        return dependency;
    }

    public static boolean isValidMavenDescriptor(MavenDependencyDescriptor dependencyDescriptor) {
        if (dependencyDescriptor == null) {
            return false;
        }
        String repository = dependencyDescriptor.getRepository();
        return repository != null && !repository.isBlank();
    }

    private List<Dependency> collectProjectDependencies(ArtifactDescriptor artifact, String scope) {
        ReactorProject dependentMavenProjectProxy = artifact.getMavenProject();
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        if (!artifact.getMavenProject().sameProject((Object)this.project)) {
            result.add(this.createProjectDependency(artifact, dependentMavenProjectProxy, scope));
        }
        if ("eclipse-plugin".equals(dependentMavenProjectProxy.getPackaging()) || "eclipse-test-plugin".equals(dependentMavenProjectProxy.getPackaging())) {
            for (String classpathElement : this.getClasspathElements(dependentMavenProjectProxy.getBasedir())) {
                if (".".equals(classpathElement)) continue;
                File jar = new File(dependentMavenProjectProxy.getBasedir(), classpathElement);
                if (jar.isFile()) {
                    Dependency systemScopeDependency = this.createScopedDependency(artifact, artifact.getMavenProject().getGroupId(), jar, "system");
                    systemScopeDependency.setClassifier(classpathElement);
                    result.add(systemScopeDependency);
                    continue;
                }
                this.logger.debug("Dependency from " + String.valueOf(this.project.getBasedir()) + " to nested classpath entry " + jar.getAbsolutePath() + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins");
            }
        }
        return result;
    }

    private Dependency createProjectDependency(ArtifactDescriptor artifact, ReactorProject dependentReactorProject, String scope) {
        ArtifactDescriptorDependency dependency = new ArtifactDescriptorDependency(artifact);
        dependency.setArtifactId(dependentReactorProject.getArtifactId());
        dependency.setGroupId(dependentReactorProject.getGroupId());
        dependency.setVersion(dependentReactorProject.getVersion());
        String type = dependentReactorProject.getPackaging();
        dependency.setType(type);
        dependency.setScope(scope);
        return dependency;
    }

    private static String fileNotAvailable() {
        if (fileNotYetAvailable == null) {
            try {
                fileNotYetAvailable = File.createTempFile("file not yet available", null);
                fileNotYetAvailable.deleteOnExit();
                JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(fileNotYetAvailable), new Manifest());
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return fileNotYetAvailable.getAbsolutePath();
    }

    private static final class ArtifactDescriptorDependency
    extends Dependency
    implements ArtifactDescriptor {
        private static final long serialVersionUID = 1L;
        private ArtifactDescriptor descriptor;

        public ArtifactDescriptorDependency(ArtifactDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public String toString() {
            return "ArtifactDescriptorDependency {descriptor=" + String.valueOf(this.getDescriptor()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + "}";
        }

        public ArtifactDescriptor getDescriptor() {
            return this.descriptor;
        }

        public ArtifactKey getKey() {
            return this.getDescriptor().getKey();
        }

        public File getLocation(boolean fetch) {
            return this.getDescriptor().getLocation(fetch);
        }

        public ReactorProject getMavenProject() {
            return this.getDescriptor().getMavenProject();
        }

        public Collection<IInstallableUnit> getInstallableUnits() {
            return this.getDescriptor().getInstallableUnits();
        }

        public Dependency clone() {
            ArtifactDescriptorDependency copy = new ArtifactDescriptorDependency(this.descriptor);
            copy.setArtifactId(this.getArtifactId());
            copy.setClassifier(this.getClassifier());
            copy.setExclusions(new ArrayList(this.getExclusions()));
            copy.setGroupId(this.getGroupId());
            if (copy.getOptional() != null) {
                copy.setOptional(this.isOptional());
            }
            copy.setScope(this.getScope());
            copy.setSystemPath(this.getSystemPath());
            copy.setType(this.getType());
            copy.setVersion(this.getVersion());
            return copy;
        }

        public Optional<File> getLocation() {
            return this.getDescriptor().getLocation();
        }

        public CompletableFuture<File> fetchArtifact() {
            return this.getDescriptor().fetchArtifact();
        }
    }
}

