/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.AbstractArtifactBasedProject;
import org.eclipse.tycho.core.osgitools.AbstractArtifactDependencyWalker;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.ProductConfiguration;

@Component(role=TychoProject.class, hint="eclipse-repository")
public class EclipseRepositoryProject
extends AbstractArtifactBasedProject {
    @Override
    public ArtifactKey getArtifactKey(ReactorProject project) {
        String id = project.getArtifactId();
        String version = this.getOsgiVersion(project);
        return new DefaultArtifactKey("eclipse-repository", id, version);
    }

    @Override
    protected ArtifactDependencyWalker newDependencyWalker(ReactorProject project, TargetEnvironment environment) {
        final List<ProductConfiguration> products = EclipseRepositoryProject.loadProducts(project);
        final List<Category> categories = this.loadCategories(project);
        return new AbstractArtifactDependencyWalker(this.getDependencyArtifacts(project, environment), this.getEnvironments(project, environment)){

            @Override
            public void walk(ArtifactDependencyVisitor visitor) {
                AbstractArtifactDependencyWalker.WalkbackPath visited = new AbstractArtifactDependencyWalker.WalkbackPath();
                for (ProductConfiguration product : products) {
                    this.traverseProduct(product, visitor, visited);
                }
                for (Category category : categories) {
                    for (FeatureRef feature : category.getFeatures()) {
                        this.traverseFeature(feature, visitor, visited);
                    }
                }
            }
        };
    }

    @Override
    public void setupProject(MavenSession session, MavenProject project) {
        super.setupProject(session, project);
        Properties properties = project.getProperties();
        if (properties.getProperty("allowIncompleteProjects") == null) {
            properties.setProperty("allowIncompleteProjects", "true");
        }
    }

    public List<Category> loadCategories(ReactorProject project) {
        return this.loadCategories(project.getBasedir());
    }

    public List<Category> loadCategories(File categoriesDirectory) {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (File file : this.getCategoryFiles(categoriesDirectory)) {
            try {
                categories.add(Category.read((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read product configuration file " + file.getAbsolutePath(), e);
            }
        }
        return categories;
    }

    public static List<ProductConfiguration> loadProducts(ReactorProject project) {
        ArrayList<ProductConfiguration> products = new ArrayList<ProductConfiguration>();
        for (File file : EclipseRepositoryProject.getProductFiles(project)) {
            try {
                products.add(ProductConfiguration.read((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read product configuration file " + file.getAbsolutePath(), e);
            }
        }
        return products;
    }

    private List<File> getCategoryFiles(File basedir) {
        ArrayList<File> files = new ArrayList<File>();
        File categoryFile = new File(basedir, "category.xml");
        if (categoryFile.exists()) {
            files.add(categoryFile);
        }
        return files;
    }

    public static List<File> getProductFiles(ReactorProject project) {
        File projectLocation = project.getBasedir();
        return EclipseRepositoryProject.getProductFiles(projectLocation);
    }

    public static List<File> getProductFiles(File basedir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : basedir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".product") || file.getName().startsWith(".polyglot")) continue;
            files.add(file);
        }
        return files;
    }
}

