/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;

@Component(role=MavenBundleResolver.class)
public class MavenBundleResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private MavenDependenciesResolver dependenciesResolver;

    public Optional<ResolvedArtifactKey> resolveMavenBundle(MavenProject project, MavenSession mavenSession, MavenArtifactKey mavenArtifactKey) {
        String resolvedType;
        if (project == null) {
            return Optional.empty();
        }
        TargetPlatform tp = MavenBundleResolver.getTargetPlatformIfAvailable(DefaultReactorProject.adapt(project));
        String type = mavenArtifactKey.getType();
        String string = resolvedType = "java.package".equals(type) ? "eclipse-plugin" : type;
        if (tp != null) {
            try {
                ArtifactKey resolvedArtifact = tp.resolveArtifact(type, mavenArtifactKey.getId(), mavenArtifactKey.getVersion());
                File location = tp.getArtifactLocation((ArtifactKey)new DefaultArtifactKey(resolvedType, resolvedArtifact.getId(), resolvedArtifact.getVersion()));
                if (location != null) {
                    return Optional.of(ResolvedArtifactKey.of((String)resolvedType, (String)resolvedArtifact.getId(), (String)resolvedArtifact.getVersion(), (File)location));
                }
            }
            catch (DependencyResolutionException | IllegalArtifactReferenceException e) {
                this.logger.debug("Cannot find key " + String.valueOf(mavenArtifactKey) + " in target platform " + String.valueOf(e) + ", trying Maven now");
            }
        }
        if (mavenSession == null) {
            return Optional.empty();
        }
        String groupId = mavenArtifactKey.getGroupId();
        String artifactId = mavenArtifactKey.getArtifactId();
        try {
            Dependency dependency = new Dependency();
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
            dependency.setVersion(mavenArtifactKey.getVersion());
            Artifact artifact = this.dependenciesResolver.resolveHighestVersion(project, mavenSession, dependency);
            if (artifact == null) {
                return Optional.empty();
            }
            ArtifactKey artifactKey = this.projectManager.getArtifactKey(artifact);
            return Optional.of(ResolvedArtifactKey.of((String)resolvedType, (String)artifactKey.getId(), (String)artifactKey.getVersion(), (File)artifact.getFile()));
        }
        catch (ArtifactResolutionException | VersionRangeResolutionException e) {
            this.logger.debug("Cannot find Maven artifact " + groupId + ":" + artifactId + " for " + mavenArtifactKey.getType() + " with ID " + mavenArtifactKey.getId() + " and version " + mavenArtifactKey.getVersion() + ": " + String.valueOf(e));
            return Optional.empty();
        }
    }

    private static TargetPlatform getTargetPlatformIfAvailable(ReactorProject project) {
        return (TargetPlatform)project.getContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform");
    }

    public Optional<ResolvedArtifactKey> resolveMavenBundle(MavenProject project, MavenSession mavenSession, String groupId, String artifactId, String version) {
        try {
            Artifact artifact = this.dependenciesResolver.resolveArtifact(project, mavenSession, groupId, artifactId, version);
            ArtifactKey artifactKey = this.projectManager.getArtifactKey(artifact);
            return Optional.of(ResolvedArtifactKey.of((String)"eclipse-plugin", (String)artifactKey.getId(), (String)artifactKey.getVersion(), (File)artifact.getFile()));
        }
        catch (ArtifactResolutionException e) {
            return Optional.empty();
        }
    }
}

