/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.BundleClassPath;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.ClasspathReader;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultPluginDescription;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.DependenciesInfo;
import org.eclipse.tycho.core.osgitools.DependenciesResolver;
import org.eclipse.tycho.core.osgitools.DependencyComputer;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProjectImpl;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.model.UpdateSite;
import org.eclipse.tycho.model.classpath.JUnitBundle;
import org.eclipse.tycho.model.classpath.JUnitClasspathContainerEntry;
import org.eclipse.tycho.model.classpath.LibraryClasspathEntry;
import org.eclipse.tycho.model.classpath.ProjectClasspathEntry;
import org.osgi.framework.Filter;

@Component(role=TychoProject.class, hint="eclipse-plugin")
public class OsgiBundleProject
extends AbstractTychoProject
implements BundleProject {
    private static final String CTX_OSGI_BUNDLE_BASENAME = TychoConstants.CTX_BASENAME + "/osgiBundle";
    private static final String CTX_ARTIFACT_KEY = CTX_OSGI_BUNDLE_BASENAME + "/artifactKey";
    private static final String CTX_CLASSPATH = CTX_OSGI_BUNDLE_BASENAME + "/classPath";
    static final String CTX_ECLIPSE_PLUGIN_PROJECT = CTX_OSGI_BUNDLE_BASENAME + "/eclipsePluginProject";
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private ClasspathReader classpathParser;
    @Requirement(hint="equinox")
    private DependenciesResolver resolver;
    @Requirement
    private Logger logger;
    @Requirement
    private ToolchainManager toolchainManager;
    @Requirement
    P2ResolverFactory resolverFactory;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;
    @Requirement
    private MavenBundleResolver mavenBundleResolver;

    @Override
    public ArtifactDependencyWalker getDependencyWalker(ReactorProject project) {
        final DependencyArtifacts artifacts = this.getDependencyArtifacts(project);
        final List<ClasspathEntry> cp = this.getClasspath(project);
        return new ArtifactDependencyWalker(){

            @Override
            public void walk(ArtifactDependencyVisitor visitor) {
                for (ClasspathEntry entry : cp) {
                    ArtifactDescriptor artifact = artifacts.getArtifact(entry.getArtifactKey());
                    ArtifactKey key = artifact.getKey();
                    File location = artifact.getLocation(true);
                    ReactorProject project = artifact.getMavenProject();
                    String classifier = artifact.getClassifier();
                    Collection installableUnits = artifact.getInstallableUnits();
                    DefaultPluginDescription plugin = new DefaultPluginDescription(key, location, project, classifier, null, installableUnits);
                    visitor.visitPlugin(plugin);
                }
            }

            @Override
            public void traverseFeature(File location, Feature feature, ArtifactDependencyVisitor visitor) {
            }

            @Override
            public void traverseUpdateSite(UpdateSite site, ArtifactDependencyVisitor artifactDependencyVisitor) {
            }

            @Override
            public void traverseProduct(ProductConfiguration productConfiguration, ArtifactDependencyVisitor visitor) {
            }
        };
    }

    @Override
    public ArtifactKey getArtifactKey(ReactorProject project) {
        return (ArtifactKey)project.computeContextValue(CTX_ARTIFACT_KEY, () -> this.readArtifactKey(project.getBasedir()));
    }

    public ArtifactKey readArtifactKey(File location) {
        OsgiManifest mf = this.bundleReader.loadManifest(location);
        return mf.toArtifactKey();
    }

    public ArtifactKey readOrCreateArtifactKey(File location, Supplier<ArtifactKey> supplier) {
        try {
            return this.readArtifactKey(location);
        }
        catch (OsgiManifestParserException e) {
            return supplier.get();
        }
    }

    @Override
    public String getManifestValue(String key, MavenProject project) {
        return this.getManifest(DefaultReactorProject.adapt(project)).getValue(key);
    }

    private OsgiManifest getManifest(ReactorProject project) {
        MavenProject mavenProject = (MavenProject)project.adapt(MavenProject.class);
        if (mavenProject == null) {
            return this.bundleReader.loadManifest(project.getBasedir());
        }
        return this.bundleReader.loadManifest(mavenProject);
    }

    private BundleClassPath resolveClassPath(MavenSession session, MavenProject project) {
        List<ClasspathEntry.AccessRule> bootClasspathExtraAccessRules;
        this.logger.info("Resolving class path of " + project.getName());
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        ArrayList<ClasspathEntry.AccessRule> strictBootClasspathAccessRules = new ArrayList<ClasspathEntry.AccessRule>();
        strictBootClasspathAccessRules.add(new DefaultClasspathEntry.DefaultAccessRule("java/**", false));
        DependencyArtifacts artifacts = this.getDependencyArtifacts(reactorProject);
        ArrayList<ClasspathEntry> classpath = new ArrayList<ClasspathEntry>();
        File bndFile = new File(project.getBasedir(), "pde.bnd");
        if (bndFile.exists()) {
            bootClasspathExtraAccessRules = List.of();
            ArtifactKey artifactKey = this.projectManager.getArtifactKey(project).get();
            classpath.add(new DefaultClasspathEntry(reactorProject, artifactKey, List.of(new File(project.getBuild().getOutputDirectory())), null));
            List bundles = artifacts.getArtifacts("eclipse-plugin");
            for (ArtifactDescriptor bundle : bundles) {
                Collection<ClasspathEntry.AccessRule> rules = null;
                classpath.add(new DefaultClasspathEntry(bundle.getMavenProject(), bundle.getKey(), List.of((File)bundle.fetchArtifact().join()), rules));
            }
        } else {
            DependenciesInfo dependenciesInfo = this.resolver.computeDependencies(project, artifacts, session);
            for (DependencyComputer.DependencyEntry entry : dependenciesInfo.getDependencyEntries()) {
                File location;
                if (entry.isSystemBundle() && entry.rules != null) {
                    strictBootClasspathAccessRules.addAll(entry.rules);
                }
                if ((location = entry.getLocation()) == null || !location.exists()) continue;
                ArtifactDescriptor otherArtifact = this.getArtifact(artifacts, location, entry.getSymbolicName());
                if (otherArtifact != null) {
                    ReactorProject otherProject = otherArtifact.getMavenProject();
                    List<File> locations = otherProject != null ? this.getOtherProjectClasspath(otherArtifact, otherProject, null) : this.getBundleClasspath(otherArtifact);
                    if (locations.isEmpty() && !entry.rules.isEmpty()) {
                        this.getLogger().warn("Empty classpath of required bundle " + String.valueOf(otherArtifact));
                    }
                    classpath.add(new DefaultClasspathEntry(otherProject, otherArtifact.getKey(), locations, entry.rules));
                    continue;
                }
                this.logger.debug("Cannot fetch artifact info for " + entry.getSymbolicName() + " and location " + String.valueOf(location) + ", using raw jar item for classpath");
                classpath.add(new DefaultClasspathEntry(null, (ArtifactKey)new DefaultArtifactKey("eclipse-plugin", entry.getSymbolicName(), entry.getVersion().toString()), Collections.singletonList(location), entry.rules));
            }
            this.addExtraClasspathEntries(classpath, reactorProject, artifacts);
            ArtifactDescriptor artifact = this.getArtifact(artifacts, project.getBasedir(), dependenciesInfo.getRevision().getSymbolicName());
            List<File> projectClasspath = this.getThisProjectClasspath(artifact, reactorProject);
            classpath.add(new DefaultClasspathEntry(reactorProject, artifact.getKey(), projectClasspath, null));
            bootClasspathExtraAccessRules = dependenciesInfo.getBootClasspathExtraAccessRules();
        }
        this.addPDESourceRoots(project);
        return new BundleClassPath(classpath, strictBootClasspathAccessRules, bootClasspathExtraAccessRules);
    }

    private Collection<ClasspathEntry> computeExtraTestClasspath(ReactorProject reactorProject) {
        ArrayList<ClasspathEntry> list = new ArrayList<ClasspathEntry>();
        Collection<ProjectClasspathEntry> entries = this.getEclipsePluginProject(reactorProject).getClasspathEntries();
        for (ProjectClasspathEntry cpe : entries) {
            if (!(cpe instanceof JUnitClasspathContainerEntry)) continue;
            JUnitClasspathContainerEntry junit = (JUnitClasspathContainerEntry)cpe;
            this.logger.info("Resolving JUnit " + junit.getJUnitSegment() + " classpath container");
            for (JUnitBundle junitBundle : junit.getArtifacts()) {
                Optional<ResolvedArtifactKey> mavenBundle = this.mavenBundleResolver.resolveMavenBundle((MavenProject)reactorProject.adapt(MavenProject.class), (MavenSession)reactorProject.adapt(MavenSession.class), ClasspathReader.toMaven(junitBundle));
                mavenBundle.ifPresent(key -> list.add(new DefaultClasspathEntry((ResolvedArtifactKey)key, (Collection<ClasspathEntry.AccessRule>)Collections.singletonList(new DefaultClasspathEntry.DefaultAccessRule("**/*", false)))));
            }
        }
        return list;
    }

    protected ArtifactDescriptor getArtifact(DependencyArtifacts artifacts, File location, String id) {
        Map classified = artifacts.getArtifact(location);
        if (classified != null) {
            for (ArtifactDescriptor artifact : classified.values()) {
                if (!id.equals(artifact.getKey().getId())) continue;
                return artifact;
            }
        }
        return null;
    }

    private void addPDESourceRoots(MavenProject project) {
        EclipsePluginProject eclipsePluginProject = this.getEclipsePluginProject(DefaultReactorProject.adapt(project));
        for (BuildOutputJar outputJar : eclipsePluginProject.getOutputJars()) {
            for (File sourceFolder : outputJar.getSourceFolders()) {
                this.removeDuplicateTestCompileRoot(sourceFolder, project.getTestCompileSourceRoots());
                project.addCompileSourceRoot(sourceFolder.getAbsolutePath());
            }
        }
    }

    private void removeDuplicateTestCompileRoot(File sourceFolder, List<String> testCompileSourceRoots) {
        Iterator<String> iterator = testCompileSourceRoots.iterator();
        while (iterator.hasNext()) {
            String testCompileRoot = iterator.next();
            if (!sourceFolder.equals(new File(testCompileRoot))) continue;
            iterator.remove();
            this.getLogger().debug("Removed duplicate test compile root " + testCompileRoot + " from maven project model");
            return;
        }
    }

    @Override
    public EclipsePluginProject getEclipsePluginProject(ReactorProject otherProject) {
        if (otherProject == null) {
            return null;
        }
        EclipsePluginProjectImpl pdeProject = (EclipsePluginProjectImpl)otherProject.getContextValue(CTX_ECLIPSE_PLUGIN_PROJECT);
        if (pdeProject == null) {
            try {
                pdeProject = new EclipsePluginProjectImpl(otherProject, this.buildPropertiesParser.parse(otherProject), this.classpathParser.parse(otherProject.getBasedir()));
                if (otherProject instanceof DefaultReactorProject) {
                    DefaultReactorProject defaultReactorProject = (DefaultReactorProject)otherProject;
                    this.populateProperties(defaultReactorProject.project.getProperties(), pdeProject);
                }
                otherProject.setContextValue(CTX_ECLIPSE_PLUGIN_PROJECT, (Object)pdeProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return pdeProject;
    }

    private void populateProperties(Properties mavenProjectProperties, EclipsePluginProjectImpl pdeProject) {
        mavenProjectProperties.put("tychoProject.build.outputDirectories", pdeProject.getOutputJars().stream().map(BuildOutputJar::getOutputDirectory).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
    }

    @Override
    public List<ClasspathEntry> getClasspath(ReactorProject project) {
        return this.getBundleClassPath(project).getClasspathEntries();
    }

    @Override
    public List<ClasspathEntry.AccessRule> getBootClasspathExtraAccessRules(ReactorProject project) {
        return this.getBundleClassPath(project).getExtraBootClasspathAccessRules();
    }

    public BundleClassPath getBundleClassPath(ReactorProject project) {
        return (BundleClassPath)project.computeContextValue(CTX_CLASSPATH, () -> this.resolveClassPath(this.getMavenSession(project), OsgiBundleProject.getMavenProject(project)));
    }

    private List<File> getThisProjectClasspath(ArtifactDescriptor bundle, ReactorProject project) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        EclipsePluginProject pdeProject = this.getEclipsePluginProject(project);
        Map<String, BuildOutputJar> outputJars = pdeProject.getOutputJarMap();
        for (BuildOutputJar jar : outputJars.values()) {
            classpath.add(jar.getOutputDirectory());
        }
        for (String cp : this.parseBundleClasspath(bundle)) {
            if (outputJars.containsKey(cp)) continue;
            classpath.add(new File(project.getBasedir(), cp));
        }
        return new ArrayList<File>(classpath);
    }

    private List<File> getOtherProjectClasspath(ArtifactDescriptor bundle, ReactorProject otherProject, String nestedPath) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        EclipsePluginProject pdeProject = this.getEclipsePluginProject(otherProject);
        Map<String, BuildOutputJar> outputJars = pdeProject.getOutputJarMap();
        String[] bundleClassPath = nestedPath == null ? this.parseBundleClasspath(bundle) : new String[]{nestedPath};
        for (String cp : bundleClassPath) {
            if (outputJars.containsKey(cp)) {
                classpath.add(outputJars.get(cp).getOutputDirectory());
                continue;
            }
            classpath.add(new File(otherProject.getBasedir(), cp));
        }
        return new ArrayList<File>(classpath);
    }

    private void addExtraClasspathEntries(List<ClasspathEntry> classpath, ReactorProject project, DependencyArtifacts artifacts) {
        EclipsePluginProject pdeProject = this.getEclipsePluginProject(project);
        Collection<BuildOutputJar> outputJars = pdeProject.getOutputJarMap().values();
        for (BuildOutputJar buildOutputJar : outputJars) {
            List<String> entries = buildOutputJar.getExtraClasspathEntries();
            for (String entry : entries) {
                Pattern platformURL = Pattern.compile("platform:/(plugin|fragment)/([^/]*)/*(.*)");
                Matcher m = platformURL.matcher(entry.trim());
                String bundleId = null;
                String path = null;
                if (m.matches()) {
                    ArtifactDescriptor matchingBundle;
                    bundleId = m.group(2).trim();
                    path = m.group(3).trim();
                    if (path != null && path.isEmpty()) {
                        path = null;
                    }
                    if ((matchingBundle = artifacts.getArtifact("eclipse-plugin", bundleId, null)) != null) {
                        classpath.add(this.addBundleToClasspath(matchingBundle, path));
                        continue;
                    }
                    this.getLogger().warn("Missing extra classpath entry " + entry.trim());
                    continue;
                }
                entry = entry.trim();
                File file = new File(project.getBasedir(), entry).getAbsoluteFile();
                if (file.exists()) {
                    List<File> locations = Collections.singletonList(file);
                    ArtifactKey projectKey = this.getArtifactKey(project);
                    classpath.add(new DefaultClasspathEntry(project, projectKey, locations, null));
                    continue;
                }
                this.getLogger().warn("Missing extra classpath entry " + entry);
            }
        }
        for (ProjectClasspathEntry entry : pdeProject.getClasspathEntries()) {
            LibraryClasspathEntry libraryClasspathEntry;
            File path;
            if (!(entry instanceof LibraryClasspathEntry) || !(path = (libraryClasspathEntry = (LibraryClasspathEntry)entry).getLibraryPath()).exists()) continue;
            classpath.add(new DefaultClasspathEntry(null, this.readOrCreateArtifactKey(path, () -> new DefaultArtifactKey("jar", path.getAbsolutePath())), Collections.singletonList(path), null));
        }
        Collection<TargetEnvironment> environments = this.projectManager.getTargetEnvironments((MavenProject)project.adapt(MavenProject.class));
        for (ArtifactDescriptor fragment : artifacts.getFragments()) {
            OsgiManifest manifest;
            Filter filter;
            File location = fragment.getLocation(true);
            if (location == null || (filter = (manifest = this.bundleReader.loadManifest(location)).getTargetEnvironmentFilter()) != null && !environments.stream().anyMatch(env -> env.match(filter))) continue;
            classpath.add(new DefaultClasspathEntry(null, this.readArtifactKey(location), Collections.singletonList(location), null));
        }
    }

    protected DefaultClasspathEntry addBundleToClasspath(ArtifactDescriptor matchingBundle, String path) {
        List<File> locations = matchingBundle.getMavenProject() != null ? this.getOtherProjectClasspath(matchingBundle, matchingBundle.getMavenProject(), path) : (path != null ? this.getBundleEntry(matchingBundle, path) : this.getBundleClasspath(matchingBundle));
        return new DefaultClasspathEntry(matchingBundle.getMavenProject(), matchingBundle.getKey(), locations, null);
    }

    private List<File> getBundleClasspath(ArtifactDescriptor bundle) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        for (String cp : this.parseBundleClasspath(bundle)) {
            File entry = ".".equals(cp) ? bundle.getLocation(true) : this.getNestedJarOrDir(bundle, cp);
            if (entry == null) continue;
            classpath.add(entry);
        }
        return new ArrayList<File>(classpath);
    }

    private List<File> getBundleEntry(ArtifactDescriptor bundle, String nestedPath) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        File entry = ".".equals(nestedPath) ? bundle.getLocation(true) : this.getNestedJarOrDir(bundle, nestedPath);
        if (entry != null) {
            classpath.add(entry);
        }
        return new ArrayList<File>(classpath);
    }

    private String[] parseBundleClasspath(ArtifactDescriptor bundle) {
        File location = bundle.getLocation(true);
        OsgiManifest mf = this.bundleReader.loadManifest(location);
        return mf.getBundleClasspath();
    }

    private File getNestedJarOrDir(ArtifactDescriptor bundle, String cp) {
        return this.bundleReader.getEntry(bundle.getLocation(true), cp);
    }

    @Override
    public TargetEnvironment getImplicitTargetEnvironment(MavenProject project) {
        return this.getManifest(DefaultReactorProject.adapt(project)).getImplicitTargetEnvironment();
    }

    @Override
    public Filter getTargetEnvironmentFilter(MavenProject project) {
        return this.getManifest(DefaultReactorProject.adapt(project)).getTargetEnvironmentFilter();
    }

    @Override
    public void readExecutionEnvironmentConfiguration(ReactorProject project, MavenSession mavenSession, ExecutionEnvironmentConfiguration sink) {
        super.readExecutionEnvironmentConfiguration(project, mavenSession, sink);
        String pdeProfileName = this.getEclipsePluginProject(project).getBuildProperties().getJreCompilationProfile();
        if (pdeProfileName != null) {
            sink.setProfileConfiguration(pdeProfileName.trim(), "build.properties");
        } else {
            String[] manifestBREEs = this.getManifest(project).getExecutionEnvironments();
            if (manifestBREEs.length == 1) {
                this.applyBestOfCurrentOrConfiguredProfile(manifestBREEs[0], "Bundle-RequiredExecutionEnvironment (unique entry)", mavenSession, sink);
            } else if (manifestBREEs.length > 1) {
                TargetPlatformConfiguration tpConfiguration = this.projectManager.getTargetPlatformConfiguration(project);
                switch (tpConfiguration.getBREEHeaderSelectionPolicy()) {
                    case first: {
                        this.applyBestOfCurrentOrConfiguredProfile(manifestBREEs[0], "Bundle-RequiredExecutionEnvironment (first entry)", mavenSession, sink);
                        break;
                    }
                    case minimal: {
                        Arrays.stream(manifestBREEs).map(ee -> ExecutionEnvironmentUtils.getExecutionEnvironment(ee, this.toolchainManager, mavenSession, this.logger)).sorted().findFirst().ifPresent(ee -> this.applyBestOfCurrentOrConfiguredProfile(ee.getProfileName(), "Bundle-RequiredExecutionEnvironment (minimal entry)", mavenSession, sink));
                    }
                }
            }
        }
    }

    private void applyBestOfCurrentOrConfiguredProfile(String configuredProfileName, String reason, MavenSession mavenSession, ExecutionEnvironmentConfiguration sink) {
        StandardExecutionEnvironment configuredProfile = ExecutionEnvironmentUtils.getExecutionEnvironment(configuredProfileName, this.toolchainManager, mavenSession, this.logger);
        if (configuredProfile == null) {
            return;
        }
        if (sink.isResolveWithEEConstraints()) {
            sink.setProfileConfiguration(configuredProfileName, reason);
        } else {
            StandardExecutionEnvironment currentProfile = ExecutionEnvironmentUtils.getExecutionEnvironment("JavaSE-" + Runtime.version().feature(), this.toolchainManager, mavenSession, this.logger);
            if (currentProfile != null && currentProfile.compareTo(configuredProfile) > 0) {
                sink.setProfileConfiguration(currentProfile.getProfileName(), "Currently running profile, newer than configured profile (" + configuredProfileName + ") from [" + reason + "]");
            } else {
                sink.setProfileConfiguration(configuredProfileName, reason);
            }
        }
    }

    @Override
    public List<ClasspathEntry> getTestClasspath(ReactorProject reactorProject) {
        return this.getTestClasspath(reactorProject, true);
    }

    @Override
    public List<ClasspathEntry> getTestClasspath(ReactorProject reactorProject, boolean complete) {
        List classpath = (List)reactorProject.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_TEST_CLASSPATH);
        if (classpath == null) {
            ArrayList<ClasspathEntry> testClasspath = new ArrayList<ClasspathEntry>(this.getClasspath(reactorProject));
            Collection<ClasspathEntry> extraTestClasspath = this.computeExtraTestClasspath(reactorProject);
            reactorProject.setContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_TEST_EXTRA_CLASSPATH, extraTestClasspath);
            testClasspath.addAll(extraTestClasspath);
            reactorProject.setContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_TEST_CLASSPATH, testClasspath);
            return testClasspath;
        }
        if (complete) {
            return classpath;
        }
        return (List)reactorProject.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_TEST_EXTRA_CLASSPATH);
    }

    @Override
    public DependencyArtifacts getTestDependencyArtifacts(ReactorProject reactorProject) {
        return (DependencyArtifacts)reactorProject.computeContextValue(TychoConstants.CTX_TEST_DEPENDENCY_ARTIFACTS, () -> {
            final List<ArtifactKey> testDependencies = this.getExtraTestRequirements(reactorProject);
            if (testDependencies.isEmpty()) {
                return new DefaultDependencyArtifacts();
            }
            this.logger.info("Resolving test dependencies of " + String.valueOf(reactorProject));
            MavenSession mavenSession = this.getMavenSession(reactorProject);
            MavenProject mavenProject = OsgiBundleProject.getMavenProject(reactorProject);
            TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(mavenProject);
            final DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
            DependencyResolverConfiguration testResolverConfiguration = new DependencyResolverConfiguration(){

                @Override
                public OptionalResolutionAction getOptionalResolutionAction() {
                    return resolverConfiguration.getOptionalResolutionAction();
                }

                @Override
                public List<ArtifactKey> getAdditionalArtifacts() {
                    ArrayList<ArtifactKey> res = new ArrayList<ArtifactKey>(resolverConfiguration.getAdditionalArtifacts());
                    res.addAll(testDependencies);
                    return res;
                }

                @Override
                public Collection<IRequirement> getAdditionalRequirements() {
                    return resolverConfiguration.getAdditionalRequirements();
                }
            };
            TargetPlatform preliminaryTargetPlatform = this.dependencyResolver.getPreliminaryTargetPlatform(mavenSession, mavenProject);
            return this.dependencyResolver.resolveDependencies(mavenSession, mavenProject, preliminaryTargetPlatform, testResolverConfiguration, configuration.getEnvironments());
        });
    }

    @Override
    public List<ArtifactKey> getExtraTestRequirements(ReactorProject project) {
        ArrayList<ArtifactKey> list = new ArrayList<ArtifactKey>();
        Collection<ProjectClasspathEntry> entries = this.getEclipsePluginProject(project).getClasspathEntries();
        for (ProjectClasspathEntry cpe : entries) {
            if (!(cpe instanceof JUnitClasspathContainerEntry)) continue;
            JUnitClasspathContainerEntry junitEntry = (JUnitClasspathContainerEntry)cpe;
            list.addAll(ClasspathReader.asMaven(junitEntry.getArtifacts()));
        }
        return list;
    }
}

