/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.InvalidOSGiManifestException;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class OsgiManifest {
    private static final String[] EMPTY_EXEC_ENV = new String[0];
    private final String location;
    private final CaseInsensitiveDictionaryMap<String, String> headers;
    private final String bundleSymbolicName;
    private final String bundleVersion;
    private final String[] bundleClassPath;
    private final String[] executionEnvironments;
    private final boolean isDirectoryShape;

    private OsgiManifest(InputStream stream, String location) throws OsgiManifestParserException {
        this.location = location;
        try {
            this.headers = new CaseInsensitiveDictionaryMap();
            if (location.endsWith(".bnd")) {
                Properties properties = new Properties();
                properties.load(stream);
                for (String key : properties.stringPropertyNames()) {
                    try {
                        new Attributes.Name(key);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    this.headers.put((Object)key, (Object)properties.getProperty(key));
                }
            } else {
                ManifestElement.parseBundleManifest((InputStream)stream, this.headers);
            }
            this.bundleSymbolicName = OSGiManifestBuilderFactory.createBuilder(this.headers).getSymbolicName();
        }
        catch (IOException | BundleException e) {
            throw new OsgiManifestParserException(location, e);
        }
        if (this.bundleSymbolicName == null) {
            throw new InvalidOSGiManifestException(location, "Bundle-SymbolicName is missing");
        }
        this.bundleVersion = this.parseBundleVersion();
        this.bundleClassPath = this.parseBundleClasspath();
        this.isDirectoryShape = this.parseDirectoryShape();
        this.executionEnvironments = this.parseExecutionEnvironments();
    }

    private String[] parseExecutionEnvironments() {
        ManifestElement[] brees = this.getManifestElements("Bundle-RequiredExecutionEnvironment");
        if (brees == null || brees.length == 0) {
            ManifestElement[] runee = this.getManifestElements("-runee");
            if (runee != null && runee.length > 0) {
                return this.elementToString(runee);
            }
            return EMPTY_EXEC_ENV;
        }
        return this.elementToString(brees);
    }

    private String[] elementToString(ManifestElement[] brees) {
        String[] envs = new String[brees.length];
        for (int i = 0; i < brees.length; ++i) {
            envs[i] = brees[i].getValue();
        }
        return envs;
    }

    private String parseBundleVersion() {
        ManifestElement[] manifestElementArray;
        int n;
        int n2;
        ManifestElement[] elements = this.parseHeader("Bundle-Version");
        if (elements != null && (n2 = 0) < (n = (manifestElementArray = elements).length)) {
            ManifestElement element = manifestElementArray[n2];
            String versionString = element.getValue();
            try {
                return Version.parseVersion((String)versionString).toString();
            }
            catch (NumberFormatException e) {
                throw new InvalidOSGiManifestException(this.location, "Bundle-Version '" + versionString + "' is invalid");
            }
            catch (IllegalArgumentException e) {
                throw new InvalidOSGiManifestException(this.location, e);
            }
        }
        return Version.emptyVersion.toString();
    }

    private boolean parseDirectoryShape() {
        ManifestElement[] bundleShapeElements = this.parseHeader("Eclipse-BundleShape");
        return bundleShapeElements != null && bundleShapeElements.length > 0 && "dir".equals(bundleShapeElements[0].getValue());
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getValue(String key) {
        return (String)this.headers.get((Object)key);
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public ArtifactKey toArtifactKey() {
        return new DefaultArtifactKey("eclipse-plugin", this.getBundleSymbolicName(), this.getBundleVersion());
    }

    public String[] getBundleClasspath() {
        return this.bundleClassPath;
    }

    public String[] getExecutionEnvironments() {
        return this.executionEnvironments;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isDirectoryShape() {
        return this.isDirectoryShape;
    }

    static OsgiManifest parse(InputStream stream, String location) throws OsgiManifestParserException {
        return new OsgiManifest(stream, location);
    }

    private ManifestElement[] parseHeader(String key) {
        String value = (String)this.headers.get((Object)key);
        if (value == null) {
            return null;
        }
        try {
            return ManifestElement.parseHeader((String)key, (String)value);
        }
        catch (BundleException e) {
            throw new OsgiManifestParserException(this.location, e);
        }
    }

    public ManifestElement[] getManifestElements(String key) throws OsgiManifestParserException {
        try {
            return ManifestElement.parseHeader((String)key, (String)((String)this.headers.get((Object)key)));
        }
        catch (BundleException e) {
            throw new OsgiManifestParserException(this.location, e);
        }
    }

    private String[] parseBundleClasspath() {
        ManifestElement[] classpathEntries;
        String[] result = new String[]{"."};
        String classPathValue = this.getValue("Bundle-ClassPath");
        if (classPathValue != null && (classpathEntries = this.getManifestElements("Bundle-ClassPath")) != null) {
            result = new String[classpathEntries.length];
            for (int i = 0; i < classpathEntries.length; ++i) {
                result[i] = classpathEntries[i].getValue();
            }
        }
        return result;
    }

    public Filter getTargetEnvironmentFilter() {
        String filterStr = this.getValue("Eclipse-PlatformFilter");
        if (filterStr != null) {
            try {
                return FrameworkUtil.createFilter((String)filterStr);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public TargetEnvironment getImplicitTargetEnvironment() {
        String filterStr = this.getValue("Eclipse-PlatformFilter");
        if (filterStr != null) {
            try {
                FilterImpl filter = FilterImpl.newInstance((String)filterStr);
                String ws = OsgiManifest.sn(filter.getPrimaryKeyValue("osgi.ws"));
                String os = OsgiManifest.sn(filter.getPrimaryKeyValue("osgi.os"));
                String arch = OsgiManifest.sn(filter.getPrimaryKeyValue("osgi.arch"));
                if (ws != null && os != null && arch != null) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("osgi.ws", ws);
                    properties.put("osgi.os", os);
                    properties.put("osgi.arch", arch);
                    if (filter.matches(properties)) {
                        return new TargetEnvironment(os, ws, arch);
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String sn(String str) {
        if (str != null && !str.isBlank()) {
            return str;
        }
        return null;
    }
}

