/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.targetplatform.TargetDefinition;

@Component(role=ClasspathContributor.class, hint="target-platform")
public class TargetPlatformClasspathContributor
implements ClasspathContributor {
    @Requirement
    private Logger logger;
    @Requirement
    private TychoProjectManager projectManager;

    public List<ClasspathEntry> getAdditionalClasspathEntries(MavenProject project, String scope) {
        TargetPlatform platform = this.projectManager.getTargetPlatform(project).orElse(null);
        if (platform == null) {
            return List.of();
        }
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
        List dependencies = configuration.getTargets().stream().flatMap(tdf -> tdf.implicitDependencies()).distinct().toList();
        return dependencies.stream().map(dependency -> this.getClasspathEntry(platform, (TargetDefinition.ImplicitDependency)dependency)).filter(Objects::nonNull).toList();
    }

    private ClasspathEntry getClasspathEntry(TargetPlatform targetPlatform, TargetDefinition.ImplicitDependency dependency) {
        try {
            ArtifactKey key = targetPlatform.resolveArtifact("eclipse-plugin", dependency.getId(), null);
            return new TargetPlatformClasspathEntry(targetPlatform, key);
        }
        catch (Exception e) {
            this.logger.warn("Can't resolve ImplicitDependency with id " + dependency.getId(), (Throwable)e);
            return null;
        }
    }

    private static final class TargetPlatformClasspathEntry
    implements ClasspathEntry {
        private final TargetPlatform targetPlatform;
        private final ArtifactKey key;
        private List<File> files;

        private TargetPlatformClasspathEntry(TargetPlatform targetPlatform, ArtifactKey key) {
            this.targetPlatform = targetPlatform;
            this.key = key;
        }

        public ReactorProject getMavenProject() {
            return null;
        }

        public synchronized List<File> getLocations() {
            if (this.files == null) {
                File file = this.targetPlatform.getArtifactLocation(this.getArtifactKey());
                this.files = file == null ? List.of() : List.of(file);
            }
            return this.files;
        }

        public ArtifactKey getArtifactKey() {
            return this.key;
        }

        public Collection<ClasspathEntry.AccessRule> getAccessRules() {
            return null;
        }

        public String toString() {
            return "TargetPlatformClasspathEntry[" + String.valueOf(this.key) + "]";
        }
    }
}

