/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.publisher;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.publisher.P2Artifact;
import org.eclipse.tycho.p2.publisher.TransientArtifactRepository;
import org.eclipse.tycho.p2.publisher.rootfiles.FeatureRootAdvice;
import org.eclipse.tycho.p2maven.advices.MavenPropertiesAdvice;

public class FeatureRootfileArtifactRepository
extends TransientArtifactRepository {
    private static final String PROP_EXTENSION = "maven-extension";
    private final File outputDirectory;
    private final PublisherInfo publisherInfo;
    private Map<File, IArtifactKey> artifactsToPublish = new HashMap<File, IArtifactKey>();
    private Map<String, IP2Artifact> collect;
    private List<IArtifactDescriptor> temp = new ArrayList<IArtifactDescriptor>();

    public FeatureRootfileArtifactRepository(PublisherInfo publisherInfo, File outputDirectory) {
        this.publisherInfo = publisherInfo;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        IArtifactKey artifactKey = descriptor.getArtifactKey();
        if (artifactKey != null && "binary".equals(artifactKey.getClassifier())) {
            if (!this.publisherInfo.getAdvice(null, false, artifactKey.getId(), artifactKey.getVersion(), IPropertyAdvice.class).stream().anyMatch(advice -> advice instanceof MavenPropertiesAdvice)) {
                throw new ProvisionException("MavenPropertiesAdvice does not exist for artifact: " + String.valueOf(artifactKey));
            }
            File outputFile = new File(this.outputDirectory, artifactKey.getId() + "-" + String.valueOf(artifactKey.getVersion()) + "-root.zip");
            try {
                this.temp.add(descriptor);
                this.descriptors.add(descriptor);
                this.artifactsToPublish.put(outputFile, artifactKey);
                return new BufferedOutputStream(new FileOutputStream(outputFile));
            }
            catch (IOException e) {
                throw new ProvisionException(e.getMessage(), (Throwable)e);
            }
        }
        return super.getOutputStream(descriptor);
    }

    String getRootFileArtifactClassifier(String artifactId) {
        List adviceList = this.publisherInfo.getAdvice();
        for (IPublisherAdvice publisherAdvice : adviceList) {
            String[] configurations;
            if (!(publisherAdvice instanceof FeatureRootAdvice)) continue;
            FeatureRootAdvice featureRootAdvice = (FeatureRootAdvice)publisherAdvice;
            for (String config : configurations = featureRootAdvice.getConfigurations()) {
                if ("".equals(config) || !artifactId.endsWith(config)) continue;
                return "root." + config;
            }
        }
        return "root";
    }

    public Map<String, IP2Artifact> getPublishedArtifacts() {
        if (this.collect == null) {
            this.descriptors.removeAll(this.temp);
            this.collect = this.artifactsToPublish.entrySet().stream().map(entry -> {
                File outputFile = (File)entry.getKey();
                IArtifactKey artifactKey = (IArtifactKey)entry.getValue();
                IArtifactDescriptor artifactDescriptor = PublisherHelper.createArtifactDescriptor((IPublisherInfo)this.publisherInfo, (IArtifactKey)artifactKey, (File)outputFile);
                Collection advices = this.publisherInfo.getAdvice(null, false, artifactDescriptor.getArtifactKey().getId(), artifactDescriptor.getArtifactKey().getVersion(), IPropertyAdvice.class);
                for (IPropertyAdvice advice : advices) {
                    if (!(advice instanceof MavenPropertiesAdvice)) continue;
                    advice.getArtifactProperties(null, artifactDescriptor);
                }
                String mavenArtifactClassifier = this.getRootFileArtifactClassifier(artifactDescriptor.getArtifactKey().getId());
                if (artifactDescriptor instanceof ArtifactDescriptor) {
                    ArtifactDescriptor impl = (ArtifactDescriptor)artifactDescriptor;
                    impl.setProperty("maven-classifier", mavenArtifactClassifier);
                    impl.setProperty(PROP_EXTENSION, "zip");
                    impl.setProperty("maven-type", "zip");
                }
                this.addDescriptor(artifactDescriptor);
                return Map.entry(mavenArtifactClassifier, new P2Artifact(outputFile, Collections.emptySet(), artifactDescriptor));
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return this.collect;
    }
}

