/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.osgi.Processor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.resolver.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="bundle-requirement")
public class AdditionalBundleRequirementsInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    private Logger logger;
    @Requirement
    TychoProjectManager projectManager;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        Optional<Processor> bndTychoProject = this.projectManager.getBndTychoProject(project);
        if (!bndTychoProject.isPresent()) {
            if (!this.projectManager.getTychoProject(project).isPresent()) return Collections.emptyList();
            ReactorProject reactorProject = DefaultReactorProject.adapt(project);
            BuildProperties buildProperties = this.buildPropertiesParser.parse(reactorProject);
            List<IRequirement> additionalBundleRequirements = buildProperties.getAdditionalBundles().stream().map(bundleName -> MetadataFactory.createRequirement((String)"osgi.bundle", (String)bundleName, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true)).toList();
            return InstallableUnitProvider.createIU(additionalBundleRequirements, (String)"additional-bundle-requirements");
        }
        try (Processor processor = bndTychoProject.get();){
            List<IRequirement> requirements = AdditionalBundleRequirementsInstallableUnitProvider.getBndClasspathRequirements(processor);
            if (requirements.isEmpty()) return Collections.emptyList();
            Collection collection = InstallableUnitProvider.createIU(requirements, (String)"bnd-classpath-requirements");
            return collection;
        }
        catch (IOException e) {
            this.logger.warn("Can't determine classpath requirements from " + project.getId(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static List<IRequirement> getBndClasspathRequirements(Processor processor) {
        String buildPath = processor.mergeProperties("-buildpath");
        if (buildPath != null && !buildPath.isBlank()) {
            return OSGiHeader.parseHeader((String)buildPath).entrySet().stream().map(entry -> {
                String bundleName = (String)entry.getKey();
                Attrs attrs = (Attrs)entry.getValue();
                String version = attrs.get("version", "latest");
                VersionRange range = "latest".equals(version) ? VersionRange.emptyRange : VersionRange.create((String)version);
                return MetadataFactory.createRequirement((String)"osgi.bundle", (String)bundleName.trim(), (VersionRange)range, null, (boolean)true, (boolean)true);
            }).toList();
        }
        return Collections.emptyList();
    }
}

