/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.util.Optional;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.PlatformPropertiesUtils;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.EquinoxResolver;
import org.eclipse.tycho.resolver.TychoResolver;

@Component(role=TychoResolver.class)
public class DefaultTychoResolver
implements TychoResolver {
    private static final String SETUP_MARKER = "DefaultTychoResolver/Setup";
    private static final String RESOLVE_MARKER = "DefaultTychoResolver/Resolve";
    private static final String TYCHO_ENV_OSGI_WS = "tycho.env.osgi.ws";
    private static final String TYCHO_ENV_OSGI_OS = "tycho.env.osgi.os";
    private static final String TYCHO_ENV_OSGI_ARCH = "tycho.env.osgi.arch";
    @Requirement
    private Logger logger;
    @Requirement(hint="p2")
    private DependencyResolver dependencyResolver;
    @Requirement
    TychoProjectManager projectManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupProject(MavenSession session, MavenProject project) {
        ReactorProject reactorProject;
        ReactorProject reactorProject2 = reactorProject = DefaultReactorProject.adapt(project, session);
        synchronized (reactorProject2) {
            TychoProject tychoProject = this.projectManager.getTychoProject(project).orElse(null);
            if (tychoProject instanceof AbstractTychoProject) {
                AbstractTychoProject dr = (AbstractTychoProject)tychoProject;
                if (reactorProject.getContextValue(SETUP_MARKER) != null) {
                    return;
                }
                reactorProject.setContextValue(SETUP_MARKER, (Object)true);
                Properties properties = EquinoxResolver.computeMergedProperties(project, session);
                String arch = PlatformPropertiesUtils.getArch((Properties)properties);
                String os = PlatformPropertiesUtils.getOS((Properties)properties);
                String ws = PlatformPropertiesUtils.getWS((Properties)properties);
                Properties projectProperties = project.getProperties();
                projectProperties.put(TYCHO_ENV_OSGI_WS, ws);
                projectProperties.put(TYCHO_ENV_OSGI_OS, os);
                projectProperties.put(TYCHO_ENV_OSGI_ARCH, arch);
                dr.setupProject(session, project);
                this.dependencyResolver.setupProjects(session, project, reactorProject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveProject(MavenSession mavenSession, MavenProject mavenProject) {
        ReactorProject reactorProject;
        Optional<TychoProject> tychoProject = this.projectManager.getTychoProject(mavenProject);
        if (tychoProject.isEmpty()) {
            return;
        }
        ReactorProject reactorProject2 = reactorProject = DefaultReactorProject.adapt(mavenProject);
        synchronized (reactorProject2) {
            if (reactorProject.getContextValue(RESOLVE_MARKER) != null) {
                return;
            }
            reactorProject.setContextValue(RESOLVE_MARKER, (Object)true);
            TychoProject project = tychoProject.get();
            DependencyArtifacts dependencyArtifacts = project.getDependencyArtifacts(reactorProject);
            DependencyArtifacts testDependencyArtifacts = project.getTestDependencyArtifacts(reactorProject);
            this.dependencyResolver.injectDependenciesIntoMavenModel(mavenProject, project, dependencyArtifacts, testDependencyArtifacts, this.logger);
            if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(mavenSession, mavenProject)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Injected dependencies for ").append(mavenProject.toString()).append("\n");
                for (Dependency dependency : mavenProject.getDependencies()) {
                    sb.append("  ").append(dependency.toString());
                }
                this.logger.debug(sb.toString());
            }
        }
    }
}

