/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.shared;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tycho.core.shared.MavenLogger;

public class LoggingProgressMonitor
implements IProgressMonitor {
    private final MavenLogger logger;

    public LoggingProgressMonitor(MavenLogger logger) {
        this.logger = logger;
    }

    private void writeToLog(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        if (this.suppressOutputOf(text)) {
            return;
        }
        this.logger.info(text);
    }

    protected boolean suppressOutputOf(String text) {
        return false;
    }

    public final void beginTask(String name, int totalWork) {
        this.writeToLog(name);
    }

    public final void done() {
    }

    public final void internalWorked(double work) {
    }

    public final boolean isCanceled() {
        return false;
    }

    public final void setCanceled(boolean value) {
    }

    public final void setTaskName(String name) {
        this.writeToLog(name);
    }

    public final void subTask(String name) {
        this.writeToLog(name);
    }

    public final void worked(int work) {
    }
}

