/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.osgi.configuration.MavenContextConfigurator;
import org.eclipse.tycho.p2maven.repository.P2ArtifactRepositoryLayout;

@Component(role=MavenContext.class)
public class DefaultMavenContext
implements MavenContext {
    @Requirement
    ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    LegacySupport legacySupport;
    @Requirement(hint="filtering")
    MavenLogger mavenLogger;
    private Properties globalProps;
    private List<MavenRepositoryLocation> repositoryLocations;
    private MavenContext.ChecksumPolicy checksumPolicy;
    private Boolean updateSnapshots;
    private File repoDir;
    private Collection<ReactorProject> projects;
    private Boolean isOffline;

    @Override
    public String getExtension(String artifactType) {
        if (artifactType == null) {
            return "jar";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        return handler.getExtension();
    }

    @Override
    public boolean isUpdateSnapshots() {
        if (this.updateSnapshots == null) {
            this.updateSnapshots = this.getSession().map(s -> s.getRequest().isUpdateSnapshots()).orElse(false);
        }
        return this.updateSnapshots;
    }

    @Override
    public Stream<MavenRepositoryLocation> getMavenRepositoryLocations() {
        if (this.repositoryLocations == null) {
            this.repositoryLocations = this.getSession().map(s -> s.getProjects().stream().map(MavenProject::getRemoteArtifactRepositories).flatMap(Collection::stream).filter(r -> r.getLayout() instanceof P2ArtifactRepositoryLayout).map(r -> {
                try {
                    return new MavenRepositoryLocation(r.getId(), new URL(r.getUrl()).toURI());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList())).orElse(Collections.emptyList());
        }
        return this.repositoryLocations.stream();
    }

    @Override
    public MavenContext.ChecksumPolicy getChecksumsMode() {
        if (this.checksumPolicy == null) {
            this.checksumPolicy = "fail".equals(this.getSession().map(s -> s.getRequest().getGlobalChecksumPolicy()).orElse(null)) ? MavenContext.ChecksumPolicy.STRICT : MavenContext.ChecksumPolicy.LAX;
        }
        return this.checksumPolicy;
    }

    @Override
    public File getLocalRepositoryRoot() {
        if (this.repoDir == null) {
            this.repoDir = this.getSession().map(s -> s.getLocalRepository().getBasedir()).map(File::new).orElse(RepositorySystem.defaultUserLocalRepository);
        }
        return this.repoDir;
    }

    @Override
    public synchronized MavenLogger getLogger() {
        return this.mavenLogger;
    }

    @Override
    public boolean isOffline() {
        if (this.isOffline == null) {
            this.isOffline = this.getSession().map(s -> s.isOffline()).orElse(false);
        }
        return this.isOffline;
    }

    @Override
    public Properties getSessionProperties() {
        if (this.globalProps == null) {
            this.globalProps = this.getSession().map(session -> MavenContextConfigurator.getGlobalProperties(session)).orElse(new Properties());
        }
        return this.globalProps;
    }

    @Override
    public Collection<ReactorProject> getProjects() {
        if (this.projects == null) {
            this.projects = this.getSession().map(s -> s.getProjects().stream().map(DefaultReactorProject::adapt).collect(Collectors.toUnmodifiableList())).orElse(Collections.emptyList());
        }
        return this.projects;
    }

    private Optional<MavenSession> getSession() {
        if (this.legacySupport == null) {
            this.mavenLogger.warn("Legacy support not available");
            return Optional.empty();
        }
        MavenSession session = this.legacySupport.getSession();
        if (session == null) {
            if (this.mavenLogger.isDebugEnabled()) {
                Thread.dumpStack();
            }
            this.mavenLogger.warn("Not called from a maven thread");
            return Optional.empty();
        }
        return Optional.of(session);
    }
}

