/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.tycho.MavenArtifactRepositoryReference;
import org.eclipse.tycho.core.DependencyResolutionException;
import org.eclipse.tycho.core.MavenDependenciesResolver;
import org.eclipse.tycho.core.MavenModelFacade;
import org.eclipse.tycho.core.maven.MavenArtifactFacade;

@Component(role=MavenDependenciesResolver.class)
public class MavenDependenciesResolverConfigurer
implements MavenDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport context;
    @Requirement
    private RepositorySystem repositorySystem;

    @Override
    public Collection<?> resolve(String groupId, String artifactId, String version, String packaging, String classifier, final Collection<String> scopes, final int depth, Collection<MavenArtifactRepositoryReference> additionalRepositories, Object session) throws DependencyResolutionException {
        Artifact artifact = classifier != null && !classifier.isEmpty() ? this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier) : this.repositorySystem.createArtifact(groupId, artifactId, version, null, packaging);
        this.logger.debug("Resolving " + String.valueOf(artifact));
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        MavenSession mavenSession = this.getMavenSession(session);
        request.setResolveRoot(true);
        request.setOffline(mavenSession.isOffline());
        request.setCollectionFilter(a -> this.isValidScope(a, scopes));
        request.setResolutionFilter(new ArtifactFilter(){

            public boolean include(Artifact a) {
                List trail = a.getDependencyTrail();
                if (MavenDependenciesResolverConfigurer.this.logger.isDebugEnabled()) {
                    MavenDependenciesResolverConfigurer.this.logger.debug("[depth=" + trail.size() + ", scope matches =" + MavenDependenciesResolverConfigurer.this.isValidScope(a, scopes) + "][" + String.valueOf(a) + "][" + trail.stream().collect(Collectors.joining(" >> ")) + "]");
                }
                return trail.size() <= depth && MavenDependenciesResolverConfigurer.this.isValidScope(a, scopes);
            }
        });
        request.setLocalRepository(mavenSession.getLocalRepository());
        request.setResolveTransitively(depth > 0);
        request.setRemoteRepositories(MavenDependenciesResolverConfigurer.getEffectiveRepositories(mavenSession.getCurrentProject(), additionalRepositories, this.repositorySystem));
        this.repositorySystem.injectMirror(request.getRemoteRepositories(), mavenSession.getSettings().getMirrors());
        this.repositorySystem.injectProxy(request.getRemoteRepositories(), mavenSession.getSettings().getProxies());
        this.repositorySystem.injectAuthentication(request.getRemoteRepositories(), mavenSession.getSettings().getServers());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        if (result.hasExceptions()) {
            throw new DependencyResolutionException("resolving " + String.valueOf(artifact) + " failed!", result.getExceptions());
        }
        return result.getArtifacts().stream().filter(a -> a.getFile() != null).map(MavenArtifactFacade::new).toList();
    }

    public static List<ArtifactRepository> getEffectiveRepositories(MavenProject project, Collection<MavenArtifactRepositoryReference> additionalRepositories, RepositorySystem repositorySystem) {
        List<Object> projectRepositories;
        if (project == null) {
            try {
                projectRepositories = List.of(repositorySystem.createDefaultRemoteRepository());
            }
            catch (InvalidRepositoryException e) {
                projectRepositories = List.of();
            }
        } else {
            projectRepositories = project.getRemoteArtifactRepositories();
        }
        if (additionalRepositories != null && !additionalRepositories.isEmpty()) {
            ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(projectRepositories);
            for (MavenArtifactRepositoryReference reference : additionalRepositories) {
                repositories.add(repositorySystem.createArtifactRepository(reference.getId(), reference.getUrl(), null, null, null));
            }
            return repositorySystem.getEffectiveRepositories(repositories);
        }
        return projectRepositories;
    }

    protected boolean isValidScope(Artifact artifact, Collection<String> scopes) {
        String artifactScope = artifact.getScope();
        if (artifactScope == null || artifactScope.isBlank()) {
            return true;
        }
        if (scopes == null || scopes.isEmpty()) {
            return "compile".equalsIgnoreCase(artifactScope);
        }
        for (String scope : scopes) {
            if (!artifactScope.equals(scope)) continue;
            return true;
        }
        return false;
    }

    protected MavenSession getMavenSession(Object session) {
        MavenSession mavenSession;
        return session instanceof MavenSession ? (mavenSession = (MavenSession)session) : Objects.requireNonNull(this.context.getSession(), "Can't acquire maven session from context, called outside maven thread context?");
    }

    @Override
    public File getRepositoryRoot() {
        return new File(this.getMavenSession(null).getLocalRepository().getBasedir());
    }

    @Override
    public MavenModelFacade loadModel(File modelFile) throws IOException {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader fileReader = new FileReader(modelFile, StandardCharsets.UTF_8);){
            model = reader.read((Reader)fileReader);
        }
        catch (XmlPullParserException e) {
            throw new IOException("can't read model", e);
        }
        return new MavenModelFacade(){

            @Override
            public String getUrl() {
                return model.getUrl();
            }

            @Override
            public String getDescription() {
                return model.getDescription();
            }

            @Override
            public String getName() {
                return model.getName();
            }

            @Override
            public String getGroupId() {
                Parent parent;
                String groupId = model.getGroupId();
                if ((groupId == null || groupId.isBlank()) && (parent = model.getParent()) != null) {
                    return parent.getGroupId();
                }
                return groupId;
            }

            @Override
            public String getArtifactId() {
                return model.getArtifactId();
            }

            @Override
            public String getVersion() {
                Parent parent;
                String version = model.getVersion();
                if ((version == null || version.isBlank()) && (parent = model.getParent()) != null) {
                    return parent.getVersion();
                }
                return version;
            }

            @Override
            public String getPackaging() {
                return model.getPackaging();
            }

            @Override
            public Stream<MavenModelFacade.MavenLicense> getLicenses() {
                return model.getLicenses().stream().map(l -> new MavenModelFacade.MavenLicense(){
                    final /* synthetic */ License val$l;
                    {
                        this.val$l = license;
                    }

                    @Override
                    public String getName() {
                        return this.val$l.getName();
                    }

                    @Override
                    public String getUrl() {
                        return this.val$l.getUrl();
                    }

                    @Override
                    public String getComments() {
                        return this.val$l.getComments();
                    }
                });
            }
        };
    }
}

