/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.publisher.rootfiles;

import java.util.Objects;

public final class ConfigSpec {
    public static final ConfigSpec GLOBAL = new ConfigSpec(null, null, null);
    private final String ws;
    private final String os;
    private final String arch;

    public static ConfigSpec createFromWsOsArch(String wsOsArchDotSeparated) {
        if (wsOsArchDotSeparated.isEmpty()) {
            return GLOBAL;
        }
        return new ConfigSpec(wsOsArchDotSeparated.split("\\."));
    }

    public static ConfigSpec createFromOsWsArchArray(String[] segments, int beginIndex) {
        return new ConfigSpec(segments[beginIndex + 1], segments[beginIndex], segments[beginIndex + 2]);
    }

    private ConfigSpec(String[] wsOsArch) {
        this.ws = wsOsArch[0];
        this.os = wsOsArch[1];
        this.arch = wsOsArch[2];
    }

    private ConfigSpec(String ws, String os, String arch) {
        this.ws = ws;
        this.os = os;
        this.arch = arch;
    }

    public int hashCode() {
        return Objects.hash(this.ws, this.os, this.arch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ConfigSpec)) return false;
        ConfigSpec other = (ConfigSpec)obj;
        if (!Objects.equals(this.ws, other.ws)) return false;
        if (!Objects.equals(this.os, other.os)) return false;
        if (!Objects.equals(this.arch, other.arch)) return false;
        return true;
    }

    public String toOsString() {
        return this.os + "." + this.ws + "." + this.arch;
    }

    public String toStringForAdvice() {
        if (this.equals(GLOBAL)) {
            return "";
        }
        return this.ws + "." + this.os + "." + this.arch;
    }
}

