/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;

public class ListCompositeMetadataRepository
extends AbstractMetadataRepository
implements ICompositeRepository<IInstallableUnit> {
    private List<? extends IMetadataRepository> metadataRepositories;

    public ListCompositeMetadataRepository(List<? extends IMetadataRepository> metadataRepositories, IProvisioningAgent agent) {
        super(agent);
        try {
            this.setLocation(new URI("list:" + String.valueOf(UUID.randomUUID())));
        }
        catch (URISyntaxException e) {
            throw new AssertionError("should never happen", e);
        }
        this.setType("org.eclipse.equinox.p2.artifact.repository.compositeRepository");
        this.metadataRepositories = metadataRepositories;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        int size = this.metadataRepositories.size();
        if (size == 1) {
            return this.metadataRepositories.get(0).query(query, monitor);
        }
        return QueryUtil.compoundQueryable(this.metadataRepositories).query(query, IProgressMonitor.nullSafe((IProgressMonitor)monitor));
    }

    public Collection<IRepositoryReference> getReferences() {
        ArrayList<IRepositoryReference> list = new ArrayList<IRepositoryReference>();
        for (IMetadataRepository iMetadataRepository : this.metadataRepositories) {
            list.addAll(iMetadataRepository.getReferences());
        }
        return list;
    }

    public void addChild(URI child) {
        throw new UnsupportedOperationException();
    }

    public List<URI> getChildren() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (IMetadataRepository iMetadataRepository : this.metadataRepositories) {
            list.add(iMetadataRepository.getLocation());
        }
        return list;
    }

    public void removeAllChildren() {
        throw new UnsupportedOperationException();
    }

    public void removeChild(URI child) {
        throw new UnsupportedOperationException();
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
    }
}

