/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.repository.AbstractMavenMetadataRepository;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.MetadataIO;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class LocalMetadataRepository
extends AbstractMavenMetadataRepository {
    private Set<GAV> changedGAVs = new LinkedHashSet<GAV>();

    public LocalMetadataRepository(IProvisioningAgent agent, URI location, TychoRepositoryIndex projectIndex, RepositoryReader contentLocator) {
        super(agent, location, projectIndex, contentLocator);
    }

    public void addInstallableUnits(Collection<IInstallableUnit> newUnits) {
        for (IInstallableUnit unit : newUnits) {
            GAV gav = RepositoryLayoutHelper.getGAV(unit.getProperties());
            this.addInstallableUnit(unit, gav);
        }
        this.save();
    }

    public void addInstallableUnit(IInstallableUnit unit, GAV gav) {
        this.units.add(unit);
        LinkedHashSet<IInstallableUnit> gavUnits = (LinkedHashSet<IInstallableUnit>)this.unitsMap.get(gav);
        if (gavUnits == null) {
            gavUnits = new LinkedHashSet<IInstallableUnit>();
            this.unitsMap.put(gav, gavUnits);
        }
        gavUnits.add(unit);
        this.changedGAVs.add(gav);
    }

    public void save() {
        File basedir = new File(this.getLocation());
        MetadataIO io = new MetadataIO();
        for (GAV gav : this.changedGAVs) {
            Set gavUnits = (Set)this.unitsMap.get(gav);
            if (gavUnits == null || gavUnits.isEmpty()) continue;
            MavenContext mavenContext = this.contentLocator != null ? this.contentLocator.getMavenContext() : this.metadataIndex.getMavenContext();
            String relpath = RepositoryLayoutHelper.getRelativePath(gav, "p2metadata", "p2-metadata", mavenContext);
            File file = new File(basedir, relpath);
            file.getParentFile().mkdirs();
            try {
                io.writeXML((Collection<? extends IInstallableUnit>)gavUnits, file);
                this.metadataIndex.addGav(gav);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.metadataIndex.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.changedGAVs.clear();
    }

    public boolean isModifiable() {
        return true;
    }
}

