/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.director.shared;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.p2.CommandLineArguments;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.p2tools.copiedfromp2.PhaseSetFactory;

public abstract class AbstractDirectorApplicationCommand
implements DirectorRuntime.Command {
    private StringJoiner metadataSources = new StringJoiner(",");
    private StringJoiner artifactSources = new StringJoiner(",");
    private StringJoiner unitsToInstall = new StringJoiner(",");
    private String profileName;
    private TargetEnvironment environment;
    private boolean installFeatures;
    private Map<String, String> profileProperties = Map.of();
    private boolean verifyOnly;
    private File destination;
    private File bundlePool;
    private IPhaseSet phaseSet;
    private boolean installSources;

    @Override
    public final void addMetadataSources(Iterable<URI> metadataRepositories) {
        for (URI repositoryUrl : metadataRepositories) {
            this.metadataSources.add(repositoryUrl.toString());
        }
    }

    @Override
    public final void addArtifactSources(Iterable<URI> artifactRepositories) {
        for (URI repositoryUrl : artifactRepositories) {
            this.artifactSources.add(repositoryUrl.toString());
        }
    }

    @Override
    public final void addUnitToInstall(String id) {
        this.unitsToInstall.add(id);
    }

    @Override
    public final void addUnitToInstall(DependencySeed dependency) {
        Object uid = "eclipse-feature".equals(dependency.getType()) ? dependency.getId() + ".feature.group" : dependency.getId();
        this.unitsToInstall.add((CharSequence)uid);
    }

    @Override
    public final void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Override
    public final void setEnvironment(TargetEnvironment env) {
        this.environment = env;
    }

    @Override
    public final void setInstallFeatures(boolean installFeatures) {
        this.installFeatures = installFeatures;
    }

    @Override
    public void setInstallSources(boolean installSources) {
        this.installSources = installSources;
    }

    @Override
    public final void setVerifyOnly(boolean verifyOnly) {
        this.verifyOnly = verifyOnly;
    }

    @Override
    public final void setDestination(File path) {
        this.destination = path;
    }

    @Override
    public void setBundlePool(File path) {
        this.bundlePool = path;
    }

    @Override
    public void setProfileProperties(Map<String, String> profileProperties) {
        this.profileProperties = profileProperties == null ? Map.of() : profileProperties;
    }

    @Override
    public void setPhaseSet(IPhaseSet phaseSet) {
        this.phaseSet = phaseSet;
    }

    public IPhaseSet getPhaseSet() {
        if (this.phaseSet == null) {
            return PhaseSetFactory.createDefaultPhaseSet();
        }
        return this.phaseSet;
    }

    protected List<String> getDirectorApplicationArguments() {
        CommandLineArguments args = new CommandLineArguments();
        args.addUnlessEmpty("-metadataRepository", this.metadataSources);
        args.addUnlessEmpty("-artifactRepository", this.artifactSources);
        args.addUnlessEmpty("-installIU", this.unitsToInstall);
        args.add("-destination", this.destination.getAbsolutePath());
        args.add("-profile", this.profileName);
        Map<String, String> props = this.getProfileProperties();
        args.add("-profileProperties", props.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")));
        args.add("-roaming");
        if (this.verifyOnly) {
            args.add("-verifyOnly");
        }
        if (this.bundlePool != null) {
            args.add("-bundlePool", this.bundlePool.getAbsolutePath());
        }
        if (this.environment != null) {
            args.add("-p2.os", this.environment.getOs());
            args.add("-p2.ws", this.environment.getWs());
            args.add("-p2.arch", this.environment.getArch());
        }
        return args.asList();
    }

    @Override
    public Map<String, String> getProfileProperties() {
        TreeMap<String, String> props = new TreeMap<String, String>(this.profileProperties);
        props.put("org.eclipse.update.install.features", Boolean.toString(this.installFeatures));
        if (this.installSources && props.get("org.eclipse.update.install.sources") == null) {
            props.put("org.eclipse.update.install.sources", "true");
        }
        return props;
    }
}

