/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2resolver.TargetDefinitionVariableResolver;

@Component(role=TargetDefinitionVariableResolver.class)
public class DefaultTargetDefinitionVariableResolver
implements TargetDefinitionVariableResolver {
    private static final Pattern SYSTEM_PROPERTY_PATTERN = DefaultTargetDefinitionVariableResolver.createVariablePatternArgument("system_property");
    private static final Pattern PROJECT_LOC_PATTERN = DefaultTargetDefinitionVariableResolver.createVariablePatternArgument("project_loc");
    private static final Pattern ENV_VAR_PATTERN = DefaultTargetDefinitionVariableResolver.createVariablePatternArgument("env_var");
    @Requirement
    private MavenContext mavenContext;
    @Requirement
    private Logger logger;

    public DefaultTargetDefinitionVariableResolver() {
    }

    public DefaultTargetDefinitionVariableResolver(MavenContext mavenContext, Logger logger) {
        this.mavenContext = mavenContext;
        this.logger = logger;
    }

    @Override
    public String resolve(String raw) {
        raw = DefaultTargetDefinitionVariableResolver.resolvePattern(raw, SYSTEM_PROPERTY_PATTERN, key -> this.property((String)key, ""));
        raw = DefaultTargetDefinitionVariableResolver.resolvePattern(raw, ENV_VAR_PATTERN, key -> {
            String env = System.getenv(key);
            return env == null ? "" : env;
        });
        raw = DefaultTargetDefinitionVariableResolver.resolvePattern(raw, PROJECT_LOC_PATTERN, this::findProjectLocation);
        return raw;
    }

    private String findProjectLocation(String projectName) {
        String name;
        if (projectName.startsWith("/")) {
            projectName = projectName.substring(1);
        }
        this.logger.debug("Find project location for project " + projectName);
        for (ReactorProject project : this.projects()) {
            name = project.getName();
            this.logger.debug("check reactor project name: " + name);
            if (!name.equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        for (ReactorProject project : this.projects()) {
            String artifactId = project.getArtifactId();
            this.logger.debug("check reactor project artifact id: " + artifactId);
            if (!artifactId.equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        for (ReactorProject project : this.projects()) {
            name = project.getBasedir().getName();
            this.logger.debug("check reactor project base directory: " + name);
            if (!name.equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        String defaultValue = "${project_loc:" + projectName + "}";
        this.logger.warn("Cannot resolve " + defaultValue + " target resolution might be incomplete");
        return defaultValue;
    }

    private String property(String key, String defaultValue) {
        return this.mavenContext.getSessionProperties().getProperty(key, defaultValue);
    }

    private Iterable<ReactorProject> projects() {
        return this.mavenContext.getProjects();
    }

    private static String resolvePattern(String input, Pattern pattern, Function<String, String> parameterResolver) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group(1);
            String resolved = parameterResolver.apply(group);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(resolved));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Pattern createVariablePatternArgument(String variableName) {
        return Pattern.compile("\\$\\{" + variableName + ":([^}]+)\\}", 2);
    }
}

