/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenDependencyDescriptor;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.core.maven.MavenDependencyInjector;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.osgitools.targetplatform.MultiEnvironmentDependencyArtifacts;
import org.eclipse.tycho.core.resolver.AdditionalBundleRequirementsInstallableUnitProvider;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.helper.PluginRealmHelper;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.p2maven.repository.P2ArtifactRepositoryLayout;
import org.eclipse.tycho.p2resolver.AttachedArtifact;
import org.eclipse.tycho.p2resolver.PomUnits;
import org.eclipse.tycho.p2resolver.TargetDefinitionResolver;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManager;
import org.eclipse.tycho.resolver.P2MetadataProvider;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetPlatformArtifactResolver;
import org.eclipse.tycho.targetplatform.TargetResolveException;

@Component(role=DependencyResolver.class, hint="p2", instantiationStrategy="per-lookup")
public class P2DependencyResolver
implements DependencyResolver,
Initializable {
    public static final String ROLE_HINT = "p2";
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private PluginRealmHelper pluginRealmHelper;
    @Requirement
    private LegacySupport context;
    @Requirement
    private P2ResolverFactory resolverFactory;
    @Requirement(hint="dependency-only")
    private DependencyMetadataGenerator generator;
    @Requirement
    private ReactorRepositoryManager reactorRepositoryManager;
    @Requirement
    private LocalRepositoryP2Indices p2index;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;
    @Requirement
    private PomUnits pomUnits;
    @Requirement
    private MavenDependenciesResolver dependenciesResolver;
    @Requirement
    private TargetPlatformFactory tpFactory;
    @Requirement
    private Logger logger;

    @Override
    public void setupProjects(MavenSession session, MavenProject project, ReactorProject reactorProject) {
        HashSet initial = new HashSet();
        if (!"eclipse-target-definition".equals(project.getPackaging())) {
            TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
            List<TargetEnvironment> environments = configuration.getEnvironments();
            Collection<IDependencyMetadata> metadataMap = this.getDependencyMetadata(session, project, environments, OptionalResolutionAction.OPTIONAL);
            TreeMap<IDependencyMetadata.DependencyMetadataType, Set> typeMap = new TreeMap<IDependencyMetadata.DependencyMetadataType, Set>();
            for (IDependencyMetadata.DependencyMetadataType type : IDependencyMetadata.DependencyMetadataType.values()) {
                typeMap.put(type, new LinkedHashSet());
            }
            for (IDependencyMetadata metadata : metadataMap) {
                typeMap.forEach((key, value) -> value.addAll(metadata.getDependencyMetadata(key)));
            }
            typeMap.forEach((key, value) -> {
                reactorProject.setDependencyMetadata(key, (Collection)value);
                initial.addAll(value);
            });
        }
        reactorProject.setDependencyMetadata(IDependencyMetadata.DependencyMetadataType.INITIAL, initial);
    }

    protected Collection<IDependencyMetadata> getDependencyMetadata(MavenSession session, MavenProject project, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        File artifactLocation = (File)reactorProject.getContextValue(TychoConstants.CTX_METADATA_ARTIFACT_LOCATION);
        File location = artifactLocation != null ? artifactLocation : project.getBasedir();
        LinkedHashMap metadata = new LinkedHashMap();
        metadata.put(null, this.generator.generateMetadata(new AttachedArtifact(project, location, null), environments, optionalAction, new PublisherOptions()));
        try {
            this.pluginRealmHelper.visitPluginExtensions(project, session, P2MetadataProvider.class, provider -> {
                Map providedMetadata = provider.getDependencyMetadata(session, project, null, optionalAction);
                if (providedMetadata != null) {
                    metadata.putAll(providedMetadata);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metadata.values();
    }

    @Override
    public TargetPlatform getPreliminaryTargetPlatform(MavenSession mavenSession, MavenProject mavenProject) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(mavenProject);
        return (TargetPlatform)reactorProject.computeContextValue("org.eclipse.tycho.core.TychoConstants/dependencyOnlyTargetPlatform", () -> {
            this.logger.debug("Computing preliminary target platform for " + String.valueOf(mavenProject));
            List<ReactorProject> reactorProjects = DefaultReactorProject.adapt(mavenSession);
            TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(mavenProject);
            TargetPlatformConfigurationStub tpConfiguration = new TargetPlatformConfigurationStub();
            ExecutionEnvironmentConfiguration ee = this.projectManager.getExecutionEnvironmentConfiguration(mavenProject);
            for (ArtifactRepository repository : mavenProject.getRemoteArtifactRepositories()) {
                this.addEntireP2RepositoryToTargetPlatform(repository, tpConfiguration);
            }
            tpConfiguration.setEnvironments(configuration.getEnvironments());
            tpConfiguration.addFilters(configuration.getFilters());
            tpConfiguration.setReferencedRepositoryMode(configuration.getReferencedRepositoryMode());
            if ("eclipse-target-definition".equals(mavenProject.getPackaging())) {
                try {
                    File targetFile = TargetPlatformArtifactResolver.getMainTargetFile((MavenProject)mavenProject);
                    TargetDefinitionFile targetDefinitionFile = TargetDefinitionFile.read((File)targetFile);
                    tpConfiguration.addTargetDefinition((TargetDefinition)targetDefinitionFile);
                }
                catch (TargetResolveException e) {
                    this.logger.warn("Can't read main target definition file from project " + mavenProject.getId(), (Throwable)e);
                }
                tpConfiguration.setIncludeSourceMode(IncludeSourceMode.ignore);
                tpConfiguration.setIgnoreLocalArtifacts(true);
            } else {
                for (TargetDefinitionFile target : configuration.getTargets()) {
                    tpConfiguration.addTargetDefinition((TargetDefinition)target);
                }
                tpConfiguration.setIncludeSourceMode(configuration.getTargetDefinitionIncludeSourceMode());
                tpConfiguration.setIgnoreLocalArtifacts(configuration.getIgnoreLocalArtifacts() == TargetPlatformConfiguration.LocalArtifactHandling.ignore);
            }
            TargetPlatform result = this.tpFactory.createTargetPlatform(tpConfiguration, ee, reactorProjects, reactorProject);
            return result;
        });
    }

    private ReactorProject getThisReactorProject(MavenSession session, final MavenProject project, TargetPlatformConfiguration configuration) {
        List<TargetEnvironment> environments = configuration.getEnvironments();
        OptionalResolutionAction optionalAction = configuration.getDependencyResolverConfiguration().getOptionalResolutionAction();
        Collection<IDependencyMetadata> dependencyMetadata = this.getDependencyMetadata(session, project, environments, optionalAction);
        final TreeMap<IDependencyMetadata.DependencyMetadataType, Set> typeMap = new TreeMap<IDependencyMetadata.DependencyMetadataType, Set>();
        for (IDependencyMetadata value : dependencyMetadata) {
            for (IDependencyMetadata.DependencyMetadataType type : IDependencyMetadata.DependencyMetadataType.values()) {
                typeMap.computeIfAbsent(type, t -> new LinkedHashSet()).addAll(value.getDependencyMetadata(type));
            }
        }
        return new DefaultReactorProject(project){

            @Override
            public Set<IInstallableUnit> getDependencyMetadata(IDependencyMetadata.DependencyMetadataType type) {
                return (Set)typeMap.get(type);
            }

            @Override
            public Object getContextValue(String key) {
                Object value = super.getContextValue(key);
                if (value == null) {
                    return DefaultReactorProject.adapt(project).getContextValue(key);
                }
                return value;
            }

            @Override
            public <T> T computeContextValue(String key, Supplier<T> initalValueSupplier) {
                return (T)DefaultReactorProject.adapt(project).computeContextValue(key, initalValueSupplier);
            }

            @Override
            public void setContextValue(String key, Object value) {
                super.setContextValue(key, value);
                DefaultReactorProject.adapt(project).setContextValue(key, value);
            }
        };
    }

    @Override
    public PomDependencyCollector resolvePomDependencies(MavenSession session, MavenProject project) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
        PomDependencies pomDependencies = configuration.getPomDependencies();
        PomDependencyCollector collector = this.resolverFactory.newPomDependencyCollector(reactorProject);
        if (pomDependencies == PomDependencies.ignore) {
            return collector;
        }
        this.pomUnits.addCollectedUnits(collector, reactorProject);
        return collector;
    }

    private void addEntireP2RepositoryToTargetPlatform(ArtifactRepository repository, TargetPlatformConfigurationStub resolutionContext) {
        try {
            if (repository.getLayout() instanceof P2ArtifactRepositoryLayout) {
                URI url = new URI(TargetDefinitionResolver.convertRawToUri(repository.getUrl()));
                resolutionContext.addP2Repository(new MavenRepositoryLocation(repository.getId(), url));
                this.logger.debug("Added p2 repository " + repository.getId() + " (" + repository.getUrl() + ")");
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid repository URI: " + repository.getUrl(), e);
        }
    }

    @Override
    public DependencyArtifacts resolveDependencies(MavenSession session, MavenProject project, TargetPlatform targetPlatform, DependencyResolverConfiguration resolverConfiguration, List<TargetEnvironment> environments) {
        Objects.requireNonNull(targetPlatform);
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
        P2Resolver osgiResolverImpl = this.resolverFactory.createResolver(environments);
        List<ReactorProject> reactorProjects = DefaultReactorProject.adapt(session);
        return this.doResolveDependencies(session, project, reactorProjects, resolverConfiguration, targetPlatform, osgiResolverImpl, configuration);
    }

    private DependencyArtifacts doResolveDependencies(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects, DependencyResolverConfiguration resolverConfiguration, TargetPlatform targetPlatform, P2Resolver resolver, TargetPlatformConfiguration configuration) {
        HashMap<File, ReactorProject> projects = new HashMap<File, ReactorProject>();
        resolver.setAdditionalFilterProperties(configuration.getProfileProperties());
        resolver.setPomDependencies(configuration.getPomDependencies());
        for (ReactorProject reactorProject : reactorProjects) {
            projects.put(reactorProject.getBasedir(), reactorProject);
        }
        if (resolverConfiguration != null) {
            for (ArtifactKey artifactKey : resolverConfiguration.getAdditionalArtifacts()) {
                try {
                    resolver.addDependency(artifactKey.getType(), artifactKey.getId(), artifactKey.getVersion());
                }
                catch (IllegalArtifactReferenceException e) {
                    throw new BuildFailureException("Invalid extraRequirement " + artifactKey.getType() + ":" + artifactKey.getId() + ":" + artifactKey.getVersion() + ": " + e.getMessage(), (Throwable)e);
                }
            }
            for (IRequirement iRequirement : resolverConfiguration.getAdditionalRequirements()) {
                resolver.addRequirement(iRequirement);
            }
            Set additionalDependencyMetadata = DefaultReactorProject.adapt(project).getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.ADDITIONAL);
            for (IInstallableUnit unit : additionalDependencyMetadata) {
                for (IRequirement requirement : unit.getRequirements()) {
                    resolver.addRequirement(requirement);
                }
            }
        }
        BuildProperties buildProperties = this.buildPropertiesParser.parse(DefaultReactorProject.adapt(project));
        Collection collection = buildProperties.getAdditionalBundles();
        for (String additionalBundle : collection) {
            resolver.addAdditionalBundleDependency(additionalBundle);
        }
        this.projectManager.getBndTychoProject(project).ifPresent(processor -> AdditionalBundleRequirementsInstallableUnitProvider.getBndClasspathRequirements(processor).forEach(req -> resolver.addRequirement((IRequirement)req)));
        ReactorProject optionalDependencyPreparedProject = this.getThisReactorProject(session, project, configuration);
        Map<TargetEnvironment, P2ResolutionResult> results = resolver.resolveTargetDependencies(targetPlatform, optionalDependencyPreparedProject);
        MultiEnvironmentDependencyArtifacts multiPlatform = new MultiEnvironmentDependencyArtifacts(DefaultReactorProject.adapt(project));
        for (Map.Entry<TargetEnvironment, P2ResolutionResult> entry : results.entrySet()) {
            TargetEnvironment environment = entry.getKey();
            P2ResolutionResult result = entry.getValue();
            DefaultDependencyArtifacts platform = this.newDefaultTargetPlatform(DefaultReactorProject.adapt(project), projects, result);
            multiPlatform.addPlatform(environment, platform);
        }
        return multiPlatform;
    }

    protected DefaultDependencyArtifacts newDefaultTargetPlatform(ReactorProject project, Map<File, ReactorProject> projects, P2ResolutionResult result) {
        DefaultArtifactKey key;
        DefaultDependencyArtifacts platform = new DefaultDependencyArtifacts(project);
        platform.addNonReactorUnits(result.getNonReactorUnits());
        for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
            key = new DefaultArtifactKey(entry.getType(), entry.getId(), entry.getVersion());
            ReactorProject otherProject = null;
            File location = entry.getLocation(false);
            if (location != null) {
                otherProject = projects.get(location);
            }
            if (otherProject != null) {
                platform.addReactorArtifact((ArtifactKey)key, otherProject, entry.getClassifier(), entry.getInstallableUnits());
                continue;
            }
            platform.addArtifactFile((ArtifactKey)key, () -> entry.getLocation(true), entry.getInstallableUnits());
        }
        for (P2ResolutionResult.Entry entry : result.getDependencyFragments()) {
            key = new DefaultArtifactKey(entry.getType(), entry.getId(), entry.getVersion());
            platform.addFragment((ArtifactKey)key, () -> entry.getLocation(true), entry.getInstallableUnits());
        }
        return platform;
    }

    public void initialize() throws InitializationException {
    }

    @Override
    public void injectDependenciesIntoMavenModel(MavenProject project, TychoProject projectType, DependencyArtifacts dependencyArtifacts, DependencyArtifacts testDependencyArtifacts, Logger logger) {
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
        Function<ArtifactDescriptor, MavenDependencyDescriptor> descriptorMapping = configuration.getP2MetadataHandling() == TargetPlatformConfiguration.InjectP2MavenMetadataHandling.inject ? this.resolverFactory::resolveDependencyDescriptor : (configuration.getP2MetadataHandling() == TargetPlatformConfiguration.InjectP2MavenMetadataHandling.validate ? descriptor -> this.resolveDescriptorWithValidation(project, logger, (ArtifactDescriptor)descriptor) : null);
        MavenDependencyInjector.injectMavenDependencies(project, dependencyArtifacts, testDependencyArtifacts, this.bundleReader, descriptorMapping, logger, this.repositorySystem, this.context.getSession().getSettings(), this.buildPropertiesParser, configuration);
    }

    private MavenDependencyDescriptor resolveDescriptorWithValidation(MavenProject project, Logger logger, ArtifactDescriptor descriptor) {
        MavenDependencyDescriptor result = this.resolverFactory.resolveDependencyDescriptor(descriptor);
        if (MavenDependencyInjector.isValidMavenDescriptor(result)) {
            try {
                this.dependenciesResolver.resolveArtifact(project, this.context.getSession(), result.getGroupId(), result.getArtifactId(), result.getVersion());
            }
            catch (ArtifactResolutionException e) {
                logger.warn("Mapping P2 > Maven Coordinates failed: " + e.getMessage());
                return null;
            }
        }
        return result;
    }
}

