/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.publisher.FeatureRootfileArtifactRepository;
import org.eclipse.tycho.core.publisher.TychoMavenPropertiesAdvice;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.metadata.P2Generator;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.eclipse.tycho.p2.metadata.ReactorProjectFacade;
import org.eclipse.tycho.p2.publisher.AbstractMetadataGenerator;
import org.eclipse.tycho.p2.publisher.AuthoredIUAction;
import org.eclipse.tycho.p2.publisher.BundleDependenciesAction;
import org.eclipse.tycho.p2.publisher.DependencyMetadata;
import org.eclipse.tycho.p2.publisher.DownloadStatsAdvice;
import org.eclipse.tycho.p2.publisher.FeatureDependenciesAction;
import org.eclipse.tycho.p2.publisher.P2Artifact;
import org.eclipse.tycho.p2.publisher.TransientArtifactRepository;
import org.eclipse.tycho.p2.publisher.rootfiles.FeatureRootAdvice;
import org.eclipse.tycho.p2.repository.ArtifactsIO;
import org.eclipse.tycho.p2.repository.MetadataIO;
import org.eclipse.tycho.p2maven.actions.CategoryDependenciesAction;
import org.eclipse.tycho.p2maven.actions.ProductDependenciesAction;
import org.eclipse.tycho.p2maven.actions.ProductFile2;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.p2resolver.ArtifactFacade;
import org.osgi.framework.BundleException;

@Component(role=P2Generator.class)
public class P2GeneratorImpl
extends AbstractMetadataGenerator
implements P2Generator {
    private static final String[] SUPPORTED_TYPES = new String[]{"eclipse-plugin", "eclipse-test-plugin", "eclipse-feature", "eclipse-repository"};
    private boolean dependenciesOnly;
    @Requirement
    private MavenContext mavenContext;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;
    @Requirement
    BundleReader bundleReader;
    @Requirement
    private Logger logger;

    public P2GeneratorImpl(boolean dependenciesOnly) {
        this.dependenciesOnly = dependenciesOnly;
    }

    public P2GeneratorImpl() {
        this(false);
    }

    @Override
    public Map<String, IP2Artifact> generateMetadata(List<IArtifactFacade> artifacts, PublisherOptions options, final File targetDir) throws IOException {
        LinkedHashMap<String, IP2Artifact> result = new LinkedHashMap<String, IP2Artifact>();
        for (IArtifactFacade artifact : artifacts) {
            DependencyMetadata metadata;
            PublisherInfo publisherInfo = new PublisherInfo();
            if ("eclipse-feature".equals(artifact.getPackagingType())) {
                int base = 3;
                if (!options.isGenerateChecksums()) {
                    base |= 8;
                }
                publisherInfo.setArtifactOptions(base);
                artifactsRepository = new FeatureRootfileArtifactRepository(publisherInfo, targetDir);
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                metadata = super.generateMetadata(artifact, null, (IPublisherInfo)publisherInfo, null, options);
                result.putAll(((FeatureRootfileArtifactRepository)artifactsRepository).getPublishedArtifacts());
            } else if ("p2-installable-unit".equals(artifact.getPackagingType())) {
                TransientArtifactRepository artifactsRepository = new TransientArtifactRepository();
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                final IArtifactFacade currentArtifact = artifact;
                IArtifactFacade targetDirAsArtifact = new IArtifactFacade(){

                    public String getVersion() {
                        return currentArtifact.getVersion();
                    }

                    public String getPackagingType() {
                        return currentArtifact.getPackagingType();
                    }

                    public File getLocation() {
                        return targetDir;
                    }

                    public String getGroupId() {
                        return currentArtifact.getGroupId();
                    }

                    public String getClassifier() {
                        return currentArtifact.getClassifier();
                    }

                    public String getArtifactId() {
                        return currentArtifact.getArtifactId();
                    }
                };
                metadata = super.generateMetadata(targetDirAsArtifact, null, (IPublisherInfo)publisherInfo, null, options);
            } else {
                int base = 2;
                if (!options.isGenerateChecksums()) {
                    base |= 8;
                }
                publisherInfo.setArtifactOptions(base);
                artifactsRepository = new TransientArtifactRepository();
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                metadata = super.generateMetadata(artifact, null, (IPublisherInfo)publisherInfo, null, options);
            }
            String classifier = artifact.getClassifier();
            this.getCanonicalArtifact(classifier, metadata.getArtifactDescriptors()).ifPresentOrElse(canonical -> {
                P2Artifact p2artifact = new P2Artifact(artifact.getLocation(), (Collection<IInstallableUnit>)metadata.getInstallableUnits(), (IArtifactDescriptor)canonical);
                result.put(classifier, p2artifact);
            }, () -> this.logger.debug("Skip generation of secondary metadata for artifact = " + String.valueOf(artifact) + ", as it does not have a canonical ArtifactDescriptor"));
        }
        return result;
    }

    private Optional<IArtifactDescriptor> getCanonicalArtifact(String classifier, Set<IArtifactDescriptor> artifactDescriptors) {
        for (IArtifactDescriptor descriptor : artifactDescriptors) {
            String _classifier = descriptor.getProperty("maven-classifier");
            if (!P2GeneratorImpl.eq(classifier, _classifier) || descriptor.getProperty("format") != null) continue;
            return Optional.of(descriptor);
        }
        return Optional.empty();
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    @Override
    public void persistMetadata(Map<String, IP2Artifact> metadata, File unitsXml, File artifactsXml) throws IOException {
        LinkedHashSet<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
        LinkedHashSet<IArtifactDescriptor> artifactDescriptors = new LinkedHashSet<IArtifactDescriptor>();
        for (IP2Artifact artifact : metadata.values()) {
            units.addAll(artifact.getInstallableUnits());
            artifactDescriptors.add(artifact.getArtifactDescriptor());
        }
        new MetadataIO().writeXML(units, unitsXml);
        new ArtifactsIO().writeXML(artifactDescriptors, artifactsXml);
    }

    public DependencyMetadata generateMetadata(IArtifactFacade artifact, List<TargetEnvironment> environments, PublisherOptions options) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(3);
        publisherInfo.setArtifactRepository((IArtifactRepository)new TransientArtifactRepository());
        return super.generateMetadata(artifact, environments, (IPublisherInfo)publisherInfo, null, options);
    }

    @Override
    protected List<IPublisherAction> getPublisherActions(IArtifactFacade artifact, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        if (!this.dependenciesOnly && optionalAction != null) {
            throw new IllegalArgumentException();
        }
        String packaging = artifact.getPackagingType();
        File location = artifact.getLocation();
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            BundleDescription desc = this.getBundleDescription(artifact);
            if (desc != null) {
                if (this.dependenciesOnly && optionalAction != null) {
                    actions.add((IPublisherAction)new BundleDependenciesAction(desc, optionalAction));
                } else {
                    actions.add((IPublisherAction)new BundlesAction(new BundleDescription[]{desc}));
                }
            }
        } else if ("eclipse-feature".equals(packaging)) {
            Feature feature = new FeatureParser().parse(location);
            feature.setLocation(location.getAbsolutePath());
            if (this.dependenciesOnly) {
                actions.add((IPublisherAction)new FeatureDependenciesAction(feature));
            } else {
                actions.add((IPublisherAction)new FeaturesAction(new Feature[]{feature}));
            }
        } else if ("eclipse-repository".equals(packaging)) {
            AdviceFileAdvice advice;
            for (File productFile : this.getProductFiles(location)) {
                ProductFile2 productDescriptor;
                String product = productFile.getAbsolutePath();
                try {
                    productDescriptor = new ProductFile2(product);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse the product file " + product, e);
                }
                if (!this.dependenciesOnly) continue;
                actions.add((IPublisherAction)new ProductDependenciesAction((IProductDescriptor)productDescriptor));
            }
            for (File categoryFile : this.getCategoryFiles(location)) {
                CategoryParser cp = new CategoryParser(null);
                try (FileInputStream ins = new FileInputStream(categoryFile);){
                    SiteModel siteModel = cp.parse((InputStream)ins);
                    actions.add((IPublisherAction)new CategoryDependenciesAction(siteModel, artifact.getArtifactId(), artifact.getVersion()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to read category File", e);
                }
            }
            File p2inf = new File(location, "p2.inf");
            if (p2inf.isFile() && (advice = new AdviceFileAdvice(artifact.getArtifactId(), Version.parseVersion((String)"1.0"), (IPath)new Path(location.getAbsolutePath()), (IPath)new Path("p2.inf"))).containsAdvice()) {
                actions.add((IPublisherAction)new AbstractPublisherAction(){

                    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
                        MetadataFactory.InstallableUnitDescription[] descriptions = advice.getAdditionalInstallableUnitDescriptions(null);
                        if (descriptions != null && descriptions.length > 0) {
                            for (MetadataFactory.InstallableUnitDescription desc : descriptions) {
                                results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc), "non_root");
                            }
                        }
                        return Status.OK_STATUS;
                    }
                });
            }
        } else if (!"p2-maven-repository".equals(packaging)) {
            if ("p2-installable-unit".equals(packaging)) {
                actions.add((IPublisherAction)new AuthoredIUAction(location));
            } else if (location.isFile() && location.getName().endsWith(".jar")) {
                actions.add((IPublisherAction)new BundlesAction(new File[]{location}));
            } else {
                throw new IllegalArgumentException("Unknown type of packaging " + packaging);
            }
        }
        return actions;
    }

    private BundleDescription getBundleDescription(IArtifactFacade artifact) {
        File location = artifact.getLocation();
        try {
            ReactorProjectFacade projectFacade;
            ReactorProject reactorProject;
            File manifestLocation;
            if ((artifact.getClassifier() == null || artifact.getClassifier().isEmpty()) && artifact instanceof ReactorProjectFacade && (manifestLocation = this.bundleReader.getManifestLocation((MavenProject)(reactorProject = (projectFacade = (ReactorProjectFacade)artifact).getReactorProject()).adapt(MavenProject.class))) != null) {
                CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(10);
                ManifestElement.parseBundleManifest((InputStream)new FileInputStream(manifestLocation), (Map)headers);
                return BundlesAction.createBundleDescription((Dictionary)headers, (File)location);
            }
            return BundlesAction.createBundleDescription((File)location);
        }
        catch (IOException | BundleException throwable) {
            return null;
        }
    }

    public boolean isSupported(String type) {
        return Arrays.asList(SUPPORTED_TYPES).contains(type);
    }

    private List<File> getProductFiles(File projectLocation) {
        ArrayList<File> res = new ArrayList<File>();
        for (File f : projectLocation.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".product") || f.getName().startsWith(".polyglot")) continue;
            res.add(f);
        }
        return res;
    }

    private List<File> getCategoryFiles(File projectLocation) {
        ArrayList<File> res = new ArrayList<File>();
        File categoryFile = new File(projectLocation, "category.xml");
        if (categoryFile.exists()) {
            res.add(categoryFile);
        }
        return res;
    }

    @Override
    protected List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade artifact, PublisherOptions options) {
        IFeatureRootAdvice featureRootAdvice;
        BuildProperties buildProperties;
        if (artifact instanceof ReactorProjectFacade) {
            ReactorProjectFacade reactorFacade = (ReactorProjectFacade)artifact;
            buildProperties = this.buildPropertiesParser.parse(reactorFacade.getReactorProject());
        } else {
            buildProperties = this.buildPropertiesParser.parse(artifact.getLocation(), null);
        }
        ArrayList<IPublisherAdvice> advice = new ArrayList<IPublisherAdvice>();
        advice.add((IPublisherAdvice)new TychoMavenPropertiesAdvice(artifact, this.mavenContext));
        advice.add((IPublisherAdvice)this.getExtraEntriesAdvice(artifact, buildProperties));
        if (options.isGenerateDownloadStats()) {
            advice.add((IPublisherAdvice)new DownloadStatsAdvice());
        }
        if ((featureRootAdvice = FeatureRootAdvice.createRootFileAdvice(artifact, this.getBuildPropertiesParser())) != null) {
            advice.add((IPublisherAdvice)featureRootAdvice);
        }
        return advice;
    }

    @Override
    protected BuildPropertiesParser getBuildPropertiesParser() {
        return this.buildPropertiesParser;
    }

    public void setMavenContext(MavenContext mockMavenContext) {
        this.mavenContext = mockMavenContext;
    }

    public void setBuildPropertiesParser(BuildPropertiesParser propertiesParserForTesting) {
        this.buildPropertiesParser = propertiesParserForTesting;
    }

    @Override
    public Map<String, IP2Artifact> generateMetadata(MavenProject project, boolean generateDownloadStatsProperty, boolean generateChecksums) throws IOException {
        File targetDir = new File(project.getBuild().getDirectory());
        ArtifactFacade projectDefaultArtifact = new ArtifactFacade(project.getArtifact());
        ArrayList<IArtifactFacade> artifacts = new ArrayList<IArtifactFacade>();
        artifacts.add(projectDefaultArtifact);
        for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
            if (attachedArtifact.getFile() == null || !attachedArtifact.getFile().getName().endsWith(".jar") && (!attachedArtifact.getFile().getName().endsWith(".zip") || !project.getPackaging().equals("p2-installable-unit"))) continue;
            artifacts.add(new ArtifactFacade(attachedArtifact));
        }
        PublisherOptions options = new PublisherOptions();
        options.setGenerateDownloadStats(generateDownloadStatsProperty);
        options.setGenerateChecksums(generateChecksums);
        return this.generateMetadata(artifacts, options, targetDir);
    }

    @Override
    public P2Generator.FileInfo persistMetadata(Map<String, IP2Artifact> metadata, MavenProject project) throws IOException {
        File targetDir = new File(project.getBuild().getDirectory());
        File contentsXml = new File(targetDir, "p2content.xml");
        File artifactsXml = new File(targetDir, "p2artifacts.xml");
        this.persistMetadata(metadata, contentsXml, artifactsXml);
        return new P2Generator.FileInfo(contentsXml, artifactsXml);
    }

    @Override
    public void writeArtifactLocations(MavenProject project) throws IOException {
        File localArtifactsFile = new File(project.getBuild().getDirectory(), "local-artifacts.properties");
        P2GeneratorImpl.writeArtifactLocations(localArtifactsFile, P2GeneratorImpl.getAllProjectArtifacts(project));
    }

    static void writeArtifactLocations(File outputFile, Map<String, File> artifactLocations) throws IOException {
        Properties outputProperties = new Properties();
        for (Map.Entry<String, File> entry : artifactLocations.entrySet()) {
            if (entry.getKey() == null) {
                outputProperties.put("artifact.main", entry.getValue().getAbsolutePath());
                continue;
            }
            outputProperties.put("artifact.attached." + entry.getKey(), entry.getValue().getAbsolutePath());
        }
        ReproducibleUtils.storeProperties((Properties)outputProperties, (java.nio.file.Path)outputFile.toPath());
    }

    private static Map<String, File> getAllProjectArtifacts(MavenProject project) {
        HashMap<String, File> artifacts = new HashMap<String, File>();
        Artifact mainArtifact = project.getArtifact();
        if (mainArtifact != null) {
            artifacts.put(null, mainArtifact.getFile());
        }
        for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
            artifacts.put(attachedArtifact.getClassifier(), attachedArtifact.getFile());
        }
        return artifacts;
    }

    @Override
    public void generateMetaData(MavenProject mavenProject) throws IOException {
        Map<String, IP2Artifact> generatedMetadata = this.generateMetadata(mavenProject, false, false);
        this.persistMetadata(generatedMetadata, mavenProject);
        this.writeArtifactLocations(mavenProject);
    }
}

