/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.p2maven.InstallableUnitPublisher;
import org.eclipse.tycho.p2maven.advices.MavenChecksumAdvice;
import org.eclipse.tycho.p2maven.advices.MavenPropertiesAdvice;
import org.eclipse.tycho.p2resolver.PomInstallableUnitStore;

@Component(role=PomUnits.class)
public class PomUnits {
    private static final String KEY = PomUnits.class.getName() + "/dependencies";
    @Requirement
    TychoProjectManager tychoProjectManager;
    @Requirement
    InstallableUnitGenerator generator;
    @Requirement
    InstallableUnitPublisher publisher;
    @Requirement
    ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    Logger logger;

    public IQueryable<IInstallableUnit> createPomQueryable(ReactorProject reactorProject) {
        Optional<TychoProject> tychoProject = this.tychoProjectManager.getTychoProject(reactorProject);
        if (tychoProject.isEmpty()) {
            return new CollectionResult(Collections.emptyList());
        }
        TargetPlatformConfiguration configuration = this.tychoProjectManager.getTargetPlatformConfiguration((MavenProject)reactorProject.adapt(MavenProject.class));
        return (IQueryable)reactorProject.computeContextValue(KEY, () -> new PomInstallableUnitStore((TychoProject)tychoProject.get(), reactorProject, this.generator, this.artifactHandlerManager, this.logger, configuration));
    }

    public void addCollectedUnits(PomDependencyCollector collector, ReactorProject reactorProject) {
        Optional<TychoProject> tychoProject = this.tychoProjectManager.getTychoProject(reactorProject);
        if (tychoProject.isEmpty()) {
            return;
        }
        Object contextValue = reactorProject.getContextValue(KEY);
        if (contextValue instanceof PomInstallableUnitStore) {
            PomInstallableUnitStore store = (PomInstallableUnitStore)contextValue;
            DependencyArtifacts dependencyArtifacts = tychoProject.get().getDependencyArtifacts(reactorProject);
            store.addPomDependencyConsumer(dependency -> {
                IArtifactFacade facade = dependency.artifactFacade();
                Map.Entry<ArtifactKey, IArtifactDescriptor> result = collector.addMavenArtifact(facade, dependency.installableUnit());
                if (result != null) {
                    List<MavenChecksumAdvice> advices = List.of(new MavenPropertiesAdvice(facade.getGroupId(), facade.getArtifactId(), facade.getVersion(), facade.getClassifier(), this.artifactHandlerManager.getArtifactHandler(facade.getPackagingType()).getExtension(), facade.getPackagingType(), facade.getRepository()), new MavenChecksumAdvice(facade.getLocation()));
                    this.publisher.applyAdvices(dependency.installableUnit(), result.getValue(), advices);
                    if (dependencyArtifacts instanceof ArtifactCollection) {
                        ArtifactCollection collection = (ArtifactCollection)dependencyArtifacts;
                        collection.addArtifactFile(result.getKey(), dependency.location(), dependency.installableUnit());
                    }
                }
            });
        }
    }
}

