/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.resolver.MavenTargetLocationFactory;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.ReferencedRepositoryMode;
import org.eclipse.tycho.core.shared.LoggingProgressMonitor;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.p2.repository.ListCompositeMetadataRepository;
import org.eclipse.tycho.p2.resolver.FileTargetDefinitionContent;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2.resolver.URITargetDefinitionContent;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2resolver.InstallableUnitResolver;
import org.eclipse.tycho.p2resolver.RepositoryLocationContent;
import org.eclipse.tycho.p2resolver.TargetDefinitionVariableResolver;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;
import org.eclipse.tycho.targetplatform.TargetDefinitionSyntaxException;

public final class TargetDefinitionResolver {
    private static final SiteXMLAction CATEGORY_FACTORY = new SiteXMLAction((URI)null, (String)null);
    private final MavenLogger logger;
    private final List<TargetEnvironment> environments;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private IncludeSourceMode includeSourceMode;
    private MavenTargetLocationFactory mavenDependenciesResolver;
    private TargetDefinitionVariableResolver varResolver;
    private ReferencedRepositoryMode referencedRepositoryMode;

    public TargetDefinitionResolver(List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints executionEnvironment, IncludeSourceMode includeSourceMode, ReferencedRepositoryMode referencedRepositoryMode, MavenContext mavenContext, MavenTargetLocationFactory mavenDependenciesResolver, TargetDefinitionVariableResolver varResolver) {
        this.environments = environments;
        this.executionEnvironment = executionEnvironment;
        this.includeSourceMode = includeSourceMode;
        this.referencedRepositoryMode = referencedRepositoryMode;
        this.mavenDependenciesResolver = mavenDependenciesResolver;
        this.logger = mavenContext.getLogger();
        this.varResolver = varResolver;
    }

    public TargetDefinitionContent resolveContent(TargetDefinition definition, IProvisioningAgent provisioningAgent) {
        try {
            return this.resolveContentWithExceptions(definition, provisioningAgent);
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new BuildFailureException("Invalid syntax in target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (TargetDefinitionResolutionException e) {
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (ResolverException e) {
            this.logResolverException(e);
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin(), (Throwable)e);
        }
    }

    private void logResolverException(ResolverException e) {
        this.logger.error("Cannot resolve target definition:");
        new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
        this.logger.error("");
    }

    public TargetDefinitionContent resolveContentWithExceptions(TargetDefinition definition, final IProvisioningAgent provisioningAgent) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException, ResolverException {
        final Collector unitResultSet = new Collector();
        InstallableUnitResolver installableUnitResolver = null;
        LinkedHashMap<String, FileTargetDefinitionContent> fileRepositories = new LinkedHashMap<String, FileTargetDefinitionContent>();
        LinkedHashMap<String, URITargetDefinitionContent> uriRepositories = new LinkedHashMap<String, URITargetDefinitionContent>();
        ArrayList<TargetDefinitionContent> mavenLocations = new ArrayList<TargetDefinitionContent>();
        ArrayList<TargetDefinitionContent> referencedTargetLocations = new ArrayList<TargetDefinitionContent>();
        ArrayList<TargetDefinitionContent> repositoryLocations = new ArrayList<TargetDefinitionContent>();
        for (TargetDefinition.Location locationDefinition : definition.getLocations()) {
            TargetDefinitionContent content;
            Object result;
            String resolvePath;
            if (locationDefinition instanceof TargetDefinition.InstallableUnitLocation) {
                TargetDefinition.InstallableUnitLocation installableUnitLocation = (TargetDefinition.InstallableUnitLocation)locationDefinition;
                if (installableUnitResolver == null) {
                    installableUnitResolver = new InstallableUnitResolver(this.environments, this.executionEnvironment, this.includeSourceMode, this.logger);
                }
                ArrayList<URITargetDefinitionContent> locations = new ArrayList<URITargetDefinitionContent>();
                TargetDefinition.FollowRepositoryReferences followRepositoryReferences = installableUnitLocation.followRepositoryReferences();
                ReferencedRepositoryMode followReferences = followRepositoryReferences == TargetDefinition.FollowRepositoryReferences.DEFAULT ? this.referencedRepositoryMode : (followRepositoryReferences == TargetDefinition.FollowRepositoryReferences.ENABLED ? ReferencedRepositoryMode.include : ReferencedRepositoryMode.ignore);
                for (TargetDefinition.Repository repository : installableUnitLocation.getRepositories()) {
                    URI location = this.resolveRepositoryLocation(repository.getLocation());
                    String key2 = location.normalize().toASCIIString();
                    locations.add(uriRepositories.computeIfAbsent(key2, s -> new URITargetDefinitionContent(provisioningAgent, location, repository.getId(), followReferences, this.logger)));
                }
                IQueryable locationUnits = QueryUtil.compoundQueryable(locations);
                Collection<IInstallableUnit> rootUnits = installableUnitResolver.addLocation((TargetDefinition.InstallableUnitLocation)locationDefinition, (IQueryable<IInstallableUnit>)locationUnits);
                unitResultSet.accept((Object)TargetDefinitionResolver.createCategory(installableUnitLocation.getRepositories().stream().map(r -> r.getLocation()).collect(Collectors.joining(", ")), (IQueryResult<IInstallableUnit>)new CollectionResult(rootUnits)));
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.PathLocation) {
                File fileLocation;
                TargetDefinition.PathLocation pathLocation = (TargetDefinition.PathLocation)locationDefinition;
                resolvePath = this.resolvePath(pathLocation.getPath(), definition);
                try {
                    fileLocation = new File(resolvePath).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new ResolverException("I/O Error while resolving path " + resolvePath, e);
                }
                if (fileLocation.exists()) {
                    FileTargetDefinitionContent fileRepositoryRolver = fileRepositories.computeIfAbsent(fileLocation.getAbsolutePath(), key -> new FileTargetDefinitionContent(provisioningAgent, fileLocation));
                    if (pathLocation instanceof TargetDefinition.DirectoryLocation || pathLocation instanceof TargetDefinition.ProfileLocation) {
                        result = fileRepositoryRolver.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, new LoggingProgressMonitor(this.logger));
                    } else {
                        if (!(pathLocation instanceof TargetDefinition.FeaturesLocation)) continue;
                        TargetDefinition.FeaturesLocation featuresLocation = (TargetDefinition.FeaturesLocation)pathLocation;
                        IArtifactKey key3 = FeaturesAction.createFeatureArtifactKey((String)featuresLocation.getId(), (String)featuresLocation.getVersion());
                        result = fileRepositoryRolver.query((IQuery<IInstallableUnit>)QueryUtil.createIUQuery((IVersionedId)key3), new LoggingProgressMonitor(this.logger));
                    }
                    unitResultSet.addAll(result);
                    unitResultSet.accept((Object)TargetDefinitionResolver.createCategory(resolvePath, (IQueryResult<IInstallableUnit>)result));
                    continue;
                }
                this.logger.warn("Target location path '" + fileLocation.getAbsolutePath() + "' does not exist, target resolution might be incomplete.");
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.MavenGAVLocation) {
                TargetDefinition.MavenGAVLocation mavenLocation = (TargetDefinition.MavenGAVLocation)locationDefinition;
                TargetDefinitionContent targetDefinitionContent = this.mavenDependenciesResolver.resolveTargetDefinitionContent(mavenLocation, this.includeSourceMode);
                mavenLocations.add(targetDefinitionContent);
                IQueryResult result2 = targetDefinitionContent.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger));
                unitResultSet.addAll(result2);
                Set locationUnits = result2.toUnmodifiableSet();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The following artifacts were resolved from location " + String.valueOf(mavenLocation));
                    for (IInstallableUnit iu : locationUnits) {
                        this.logger.debug("\t" + String.valueOf(iu));
                    }
                }
                unitResultSet.accept((Object)TargetDefinitionResolver.createCategory(mavenLocation.getLabel(), (IQueryResult<IInstallableUnit>)result2));
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.TargetReferenceLocation) {
                URI resolvedUri;
                TargetDefinition.TargetReferenceLocation referenceLocation = (TargetDefinition.TargetReferenceLocation)locationDefinition;
                this.logger.info("Resolving " + referenceLocation.getUri());
                resolvePath = this.resolvePath(referenceLocation.getUri(), definition);
                try {
                    resolvedUri = new URI(TargetDefinitionResolver.convertRawToUri(resolvePath));
                }
                catch (URISyntaxException e) {
                    throw new ResolverException("Invalid URI " + resolvePath + ": " + e.getMessage(), e);
                }
                this.logger.info("Reading target platform " + String.valueOf(resolvedUri));
                content = this.resolveContentWithExceptions((TargetDefinition)TargetDefinitionFile.read((URI)resolvedUri), provisioningAgent);
                result = content.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger));
                unitResultSet.addAll((IQueryResult)result);
                referencedTargetLocations.add(content);
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.RepositoryLocation) {
                URI resolvedUri;
                TargetDefinition.RepositoryLocation repositoryLocation = (TargetDefinition.RepositoryLocation)locationDefinition;
                String uri = repositoryLocation.getUri();
                try {
                    resolvedUri = new URI(TargetDefinitionResolver.convertRawToUri(this.resolvePath(uri, definition)));
                }
                catch (URISyntaxException e) {
                    throw new ResolverException("Invalid URI " + this.resolvePath(uri, definition) + ": " + e.getMessage(), e);
                }
                this.logger.info("Loading " + String.valueOf(resolvedUri) + "...");
                content = new RepositoryLocationContent(resolvedUri, repositoryLocation.getRequirements(), provisioningAgent, this.logger);
                repositoryLocations.add(content);
                result = content.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger));
                unitResultSet.addAll((IQueryResult)result);
                unitResultSet.accept((Object)TargetDefinitionResolver.createCategory(uri, (IQueryResult<IInstallableUnit>)result));
                continue;
            }
            this.logger.warn("Target location type '" + locationDefinition.getTypeDescription() + "' is not supported");
        }
        if (definition.hasIncludedBundles()) {
            this.logger.warn("De-selecting bundles in a target definition file is not supported. See https://wiki.eclipse.org/Tycho_Messages_Explained#Target_File_Include_Bundles for alternatives.");
        }
        final ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
        final ArrayList<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
        for (FileTargetDefinitionContent fileDefinitionContent : fileRepositories.values()) {
            metadataRepositories.add(fileDefinitionContent.getMetadataRepository());
            artifactRepositories.add(fileDefinitionContent.getArtifactRepository());
        }
        for (URITargetDefinitionContent uriDefinitionContent : uriRepositories.values()) {
            metadataRepositories.add(uriDefinitionContent.getMetadataRepository());
            artifactRepositories.add(uriDefinitionContent.getArtifactRepository());
        }
        for (TargetDefinitionContent mavenContent : mavenLocations) {
            metadataRepositories.add(mavenContent.getMetadataRepository());
            artifactRepositories.add(mavenContent.getArtifactRepository());
        }
        for (TargetDefinitionContent referenceContent : referencedTargetLocations) {
            metadataRepositories.add(referenceContent.getMetadataRepository());
            artifactRepositories.add(referenceContent.getArtifactRepository());
        }
        for (TargetDefinitionContent referenceContent : repositoryLocations) {
            metadataRepositories.add(referenceContent.getMetadataRepository());
            artifactRepositories.add(referenceContent.getArtifactRepository());
        }
        if (installableUnitResolver != null) {
            ListCompositeMetadataRepository metadataRepository = new ListCompositeMetadataRepository(metadataRepositories, provisioningAgent);
            unitResultSet.addAll(installableUnitResolver.resolve((IQueryable<IInstallableUnit>)metadataRepository));
        }
        return new TargetDefinitionContent(){
            private ListCompositeArtifactRepository artifactRepository;
            private IMetadataRepository metadataRepository;

            public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return unitResultSet.query(query, monitor);
            }

            public IMetadataRepository getMetadataRepository() {
                if (this.metadataRepository == null) {
                    this.metadataRepository = new ListCompositeMetadataRepository(metadataRepositories, provisioningAgent);
                }
                return this.metadataRepository;
            }

            public IArtifactRepository getArtifactRepository() {
                if (this.artifactRepository == null) {
                    this.artifactRepository = new ListCompositeArtifactRepository(artifactRepositories, provisioningAgent);
                }
                return this.artifactRepository;
            }
        };
    }

    private static IInstallableUnit createCategory(String label, IQueryResult<IInstallableUnit> result) {
        SiteCategory category = new SiteCategory();
        category.setLabel(label);
        category.setName("generated.target.category." + String.valueOf(UUID.randomUUID()));
        return CATEGORY_FACTORY.createCategoryIU(category, result.stream().filter(iu -> !iu.getId().endsWith(".feature.jar")).collect(Collectors.toSet()));
    }

    public static String convertRawToUri(String raw) {
        String lc = (raw = raw.replace('\\', '/')).toLowerCase();
        if (lc.startsWith("file:") && !lc.startsWith("file:/")) {
            raw = raw.replaceFirst("(?i)^file:", "file:/");
        }
        return raw;
    }

    protected String resolvePath(String path, TargetDefinition definition) {
        return this.varResolver.resolve(path);
    }

    protected URI resolveRepositoryLocation(String location) {
        try {
            return new URI(this.varResolver.resolve(location));
        }
        catch (URISyntaxException e) {
            throw new TargetDefinitionSyntaxException("Invalid URI: " + location);
        }
    }
}

