/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.core.resolver.target.ArtifactMatcher;
import org.eclipse.tycho.core.resolver.target.ArtifactTypeHelper;
import org.eclipse.tycho.p2.repository.LocalArtifactRepository;
import org.eclipse.tycho.targetplatform.P2TargetPlatform;

abstract class TargetPlatformBaseImpl
implements P2TargetPlatform {
    protected final LinkedHashSet<IInstallableUnit> installableUnits;
    private final Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup;
    final Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup;
    final ExecutionEnvironmentResolutionHints executionEnvironment;
    final IRawArtifactFileProvider artifacts;
    @Deprecated
    private LocalArtifactRepository localArtifactRepository;
    private Set<IInstallableUnit> shadowed;

    public TargetPlatformBaseImpl(LinkedHashSet<IInstallableUnit> installableUnits, ExecutionEnvironmentResolutionHints executionEnvironment, IRawArtifactFileProvider artifacts, LocalArtifactRepository localArtifactRepository, Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup, Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup, Set<IInstallableUnit> shadowed) {
        this.installableUnits = installableUnits;
        this.executionEnvironment = executionEnvironment;
        this.reactorProjectLookup = reactorProjectLookup;
        this.mavenArtifactLookup = mavenArtifactLookup;
        this.artifacts = artifacts;
        this.localArtifactRepository = localArtifactRepository;
        this.shadowed = shadowed;
    }

    public final Set<IInstallableUnit> getInstallableUnits() {
        return this.installableUnits;
    }

    public final ArtifactKey resolveArtifact(String type, String id, String version) throws IllegalArtifactReferenceException, DependencyResolutionException {
        IArtifactKey key;
        IInstallableUnit resolvedUnit;
        if (version != null && (version.startsWith("[") || version.startsWith("("))) {
            resolvedUnit = this.resolveUnit(type, id, VersionRange.create((String)version));
        } else if (version != null && version.contains("|")) {
            String[] split = version.split("\\|", 2);
            resolvedUnit = this.resolveUnit(type, id, ArtifactMatcher.getVersionRangeFromImport(split[0], split[1]));
        } else {
            resolvedUnit = this.resolveUnit(type, id, ArtifactMatcher.parseAsOSGiVersion(version));
        }
        if ("eclipse-feature".equals(type)) {
            return new DefaultArtifactKey(type, id, resolvedUnit.getVersion().toString());
        }
        Collection artifacts = resolvedUnit.getArtifacts();
        if (artifacts.size() == 1 && "osgi.bundle".equals((key = (IArtifactKey)artifacts.iterator().next()).getClassifier())) {
            return new DefaultArtifactKey("eclipse-plugin", resolvedUnit.getId(), resolvedUnit.getVersion().toString());
        }
        return new DefaultArtifactKey(type, resolvedUnit.getId(), resolvedUnit.getVersion().toString());
    }

    public final IInstallableUnit resolveUnit(String type, String id, Version version) throws IllegalArtifactReferenceException, DependencyResolutionException {
        VersionRange versionRange = ArtifactMatcher.getVersionRangeFromReference(version);
        return this.resolveUnit(type, id, versionRange);
    }

    public IInstallableUnit resolveUnit(String type, String id, VersionRange versionRange) throws IllegalArtifactReferenceException, DependencyResolutionException {
        IInstallableUnit matchingUnit = ArtifactMatcher.resolveReference(type, id, versionRange, this.installableUnits);
        if (matchingUnit == null) {
            String message = type + " artifact with ID \"" + id + "\" and version matching \"" + String.valueOf(versionRange) + "\" was not found in the target platform";
            String candidates = this.installableUnits.stream().sorted(Comparator.comparing(IVersionedId::getId).thenComparing(IVersionedId::getVersion)).filter(iu -> iu.getId().contains(id)).map(iu -> iu.getId() + ":" + String.valueOf(iu.getVersion())).collect(Collectors.joining(System.lineSeparator()));
            if (!candidates.isBlank()) {
                message = message + ", did you probably mean: " + candidates;
            }
            throw new DependencyResolutionException(message);
        }
        return matchingUnit;
    }

    public final ExecutionEnvironmentResolutionHints getEEResolutionHints() {
        return this.executionEnvironment;
    }

    public final Map<IInstallableUnit, ReactorProjectIdentities> getOriginalReactorProjectMap() {
        return this.reactorProjectLookup;
    }

    public final Map<IInstallableUnit, IArtifactFacade> getOriginalMavenArtifactMap() {
        return this.mavenArtifactLookup;
    }

    public final File getLocalArtifactFile(IArtifactKey key) {
        return this.artifacts.getArtifactFile(key);
    }

    public final void saveLocalMavenRepository() {
        this.localArtifactRepository.save();
    }

    public File getArtifactLocation(ArtifactKey artifact) {
        if ("p2-installable-unit".equals(artifact.getType())) {
            File bundleFile = this.artifacts.getArtifactFile(ArtifactTypeHelper.toP2BundleArtifactKey(artifact));
            if (bundleFile != null) {
                return bundleFile;
            }
            return this.artifacts.getArtifactFile(ArtifactTypeHelper.toP2FeatureArtifactKey(artifact));
        }
        IArtifactKey p2Artifact = ArtifactTypeHelper.toP2ArtifactKey(artifact);
        if (p2Artifact != null) {
            return this.artifacts.getArtifactFile(p2Artifact);
        }
        return null;
    }

    public boolean isFileAlreadyAvailable(ArtifactKey artifact) {
        IArtifactKey p2Artifact = ArtifactTypeHelper.toP2ArtifactKey(artifact);
        if (p2Artifact != null) {
            return this.artifacts.isFileAlreadyAvailable(p2Artifact);
        }
        return false;
    }

    public Set<IInstallableUnit> getShadowed() {
        return this.shadowed;
    }
}

