/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.repository.RepositoryBlackboardKey;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2tools.MetadataSerializable;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManager;

@Component(role=RepositoryReferenceTool.class)
public class RepositoryReferenceTool {
    public static final int REPOSITORIES_INCLUDE_CURRENT_MODULE = 1;
    @Requirement(hint="p2")
    private DependencyResolver dependencyResolver;
    @Requirement
    private MetadataSerializable serializer;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private ReactorRepositoryManager repositoryManager;

    public RepositoryReferences getVisibleRepositories(MavenProject module, MavenSession session, int flags) throws MojoExecutionException, MojoFailureException {
        RepositoryReferences repositories = new RepositoryReferences();
        if ((flags & 1) != 0) {
            this.repositoryManager.getPublishingRepository(DefaultReactorProject.adapt(module));
            File publisherResults = new File(module.getBuild().getDirectory());
            repositories.addMetadataRepository(publisherResults);
            repositories.addArtifactRepository(publisherResults);
        }
        repositories.addArtifactRepository(RepositoryBlackboardKey.forResolutionContextArtifacts(module.getBasedir()));
        this.addTargetPlatformRepository(repositories, session, module);
        repositories.addArtifactRepository(new File(session.getLocalRepository().getBasedir()));
        return repositories;
    }

    private void addTargetPlatformRepository(RepositoryReferences sources, MavenSession session, MavenProject project) throws MojoExecutionException, MojoFailureException {
        try {
            File repositoryLocation = new File(project.getBuild().getDirectory(), "targetPlatformRepository");
            repositoryLocation.mkdirs();
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(new File(repositoryLocation, "content.xml")));){
                TargetPlatform targetPlatform = this.projectManager.getTargetPlatform(project).orElseThrow(() -> new MojoFailureException("Tycho build extension not configured for " + String.valueOf(project)));
                TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
                DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
                DependencyArtifacts dependencyArtifacts = this.dependencyResolver.resolveDependencies(session, project, targetPlatform, resolverConfiguration, configuration.getEnvironments());
                dependencyArtifacts.getArtifacts().forEach(artifact -> artifact.getLocation(true));
                HashSet<IInstallableUnit> targetPlatformInstallableUnits = new HashSet<IInstallableUnit>(dependencyArtifacts.getInstallableUnits());
                for (ArtifactDescriptor artifact2 : dependencyArtifacts.getArtifacts()) {
                    File artifactXml;
                    ReactorProject otherProject = artifact2.getMavenProject();
                    if (otherProject == null || (artifactXml = otherProject.getArtifact("p2artifacts")) == null || !artifactXml.isFile()) continue;
                    sources.addArtifactRepository(artifactXml.getParentFile());
                }
                this.serializer.serialize(stream, targetPlatformInstallableUnits);
            }
            sources.addMetadataRepository(repositoryLocation);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O exception while writing the build target platform to disk", (Exception)e);
        }
        catch (DependencyResolutionException e) {
            ResolverException resolverException = ResolverException.findResolverException(e);
            if (resolverException == null) {
                throw new MojoFailureException("Cannot resolve dependencies of project " + project.getId(), (Throwable)e);
            }
            throw new MojoFailureException("Cannot resolve dependencies of project " + project.getId() + System.lineSeparator() + " with context " + resolverException.getSelectionContext() + System.lineSeparator() + resolverException.explanations().map(exp -> "  " + exp.toString()).collect(Collectors.joining("\n")), (Throwable)resolverException);
        }
    }
}

