/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2tools.copiedfromp2.MirrorApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.PermissiveSlicer;
import org.eclipse.tycho.p2tools.copiedfromp2.RepositoryDescriptor;
import org.eclipse.tycho.p2tools.copiedfromp2.Slicer;

public class TychoMirrorApplication
extends MirrorApplication {
    private static final String SOURCE_SUFFIX = ".source";
    private static final String FEATURE_GROUP = ".feature.group";
    private final DestinationRepositoryDescriptor destination;
    private boolean includeAllSource;
    private boolean includeRequiredBundles;
    private boolean includeRequiredFeatures;
    private boolean filterProvided;
    private boolean addOnlyProvidingRepoReferences;
    private TargetPlatform targetPlatform;
    private Logger logger;

    public TychoMirrorApplication(IProvisioningAgent agent, DestinationRepositoryDescriptor destination, Logger logger) {
        super(agent);
        this.destination = destination;
        this.logger = logger;
        this.removeAddedRepositories = false;
    }

    @Override
    protected IArtifactRepository initializeDestination(RepositoryDescriptor toInit, IArtifactRepositoryManager mgr) throws ProvisionException {
        IArtifactRepository result = super.initializeDestination(toInit, mgr);
        Map<String, String> extraArtifactRepositoryProperties = this.destination.getExtraArtifactRepositoryProperties();
        if (!extraArtifactRepositoryProperties.isEmpty()) {
            result.executeBatch(nil -> extraArtifactRepositoryProperties.forEach((arg_0, arg_1) -> ((IArtifactRepository)result).setProperty(arg_0, arg_1)), null);
        }
        return result;
    }

    @Override
    public IArtifactRepository getCompositeArtifactRepository() throws ProvisionException {
        IArtifactRepository repository = super.getCompositeArtifactRepository();
        if (this.targetPlatform != null) {
            return new ListCompositeArtifactRepository(List.of(repository, this.targetPlatform.getArtifactRepository()), this.agent);
        }
        return repository;
    }

    @Override
    protected Slicer createSlicer(SlicingOptions options) throws ProvisionException {
        List<Map<String, String>> filters = this.getContextFilters();
        final List<IInstallableUnit> selectionContexts = filters.stream().map(InstallableUnit::contextIU).toList();
        final boolean includeOptionalDependencies = options.includeOptionalDependencies();
        final boolean onlyFilteredRequirements = options.followOnlyFilteredRequirements();
        final boolean considerFilter = filters.stream().anyMatch(f -> f.size() > 1);
        final boolean evalFilterTo = options.forceFilterTo();
        IMetadataRepository repository = this.getCompositeMetadataRepository();
        final boolean considerOnlyStrictDependency = options.considerStrictDependencyOnly();
        return new PermissiveSlicer((IQueryable)repository, filters.get(0), includeOptionalDependencies, options.isEverythingGreedy(), evalFilterTo, considerOnlyStrictDependency, onlyFilteredRequirements){

            @Override
            protected boolean isApplicable(IInstallableUnit iu, IRequirement req) {
                boolean isFeature;
                IRequiredCapability capability;
                if ((TychoMirrorApplication.this.includeRequiredBundles || TychoMirrorApplication.this.includeRequiredFeatures) && QueryUtil.isGroup((IInstallableUnit)iu) && req instanceof IRequiredCapability && "org.eclipse.equinox.p2.iu".equals((capability = (IRequiredCapability)req).getNamespace()) && ((isFeature = capability.getName().endsWith(TychoMirrorApplication.FEATURE_GROUP)) && TychoMirrorApplication.this.includeRequiredFeatures || !isFeature && TychoMirrorApplication.this.includeRequiredBundles)) {
                    if (!includeOptionalDependencies && req.getMin() == 0) {
                        return false;
                    }
                    IMatchExpression filter = req.getFilter();
                    if (onlyFilteredRequirements && filter == null) {
                        return false;
                    }
                    return !considerFilter || filter == null || this.matchesSelectionContext((IMatchExpression<IInstallableUnit>)filter);
                }
                return this.isApplicable(req);
            }

            @Override
            protected boolean isApplicable(IRequirement req) {
                IRequiredCapability capability;
                if (!includeOptionalDependencies && req.getMin() == 0) {
                    return false;
                }
                if (considerOnlyStrictDependency && !RequiredCapability.isStrictVersionRequirement((IMatchExpression)req.getMatches())) {
                    return false;
                }
                if (!TychoMirrorApplication.this.includeAllSource && req.getMin() == 0 && !req.isGreedy() && req instanceof IRequiredCapability && "org.eclipse.equinox.p2.eclipse.type".equals((capability = (IRequiredCapability)req).getNamespace()) && "source".equals(capability.getName())) {
                    return false;
                }
                IMatchExpression filter = req.getFilter();
                if (considerFilter) {
                    if (onlyFilteredRequirements && filter == null) {
                        return false;
                    }
                    return filter == null || this.matchesSelectionContext((IMatchExpression<IInstallableUnit>)filter);
                }
                return filter == null ? !onlyFilteredRequirements : evalFilterTo;
            }

            @Override
            protected boolean isApplicable(IInstallableUnit iu) {
                if (considerFilter) {
                    IMatchExpression filter = iu.getFilter();
                    return filter == null || this.matchesSelectionContext((IMatchExpression<IInstallableUnit>)filter);
                }
                return iu.getFilter() == null || evalFilterTo;
            }

            private boolean matchesSelectionContext(IMatchExpression<IInstallableUnit> filter) {
                return selectionContexts.stream().anyMatch(arg_0 -> filter.isMatch(arg_0));
            }

            @Override
            public IQueryable<IInstallableUnit> slice(Collection<IInstallableUnit> ius, IProgressMonitor monitor) {
                IQueryable<IInstallableUnit> slice = super.slice(ius, monitor);
                if (TychoMirrorApplication.this.includeAllSource && TychoMirrorApplication.this.targetPlatform != null) {
                    Set collected = slice.query(QueryUtil.ALL_UNITS, null).toSet();
                    HashSet result = new HashSet(collected);
                    IQueryResult allUnits = TychoMirrorApplication.this.targetPlatform.getMetadataRepository().query(QueryUtil.ALL_UNITS, null);
                    Map<String, List<IInstallableUnit>> sourceIus = allUnits.stream().filter(iu -> iu.getId().endsWith(TychoMirrorApplication.SOURCE_SUFFIX)).collect(Collectors.groupingBy(IVersionedId::getId));
                    for (IInstallableUnit iu2 : collected) {
                        String id = iu2.getId();
                        String sourceId = id.endsWith(TychoMirrorApplication.FEATURE_GROUP) ? id.substring(id.length() - TychoMirrorApplication.FEATURE_GROUP.length()) + TychoMirrorApplication.SOURCE_SUFFIX : id + TychoMirrorApplication.SOURCE_SUFFIX;
                        List<IInstallableUnit> sourceUnits = sourceIus.get(sourceId);
                        if (sourceUnits == null) continue;
                        sourceUnits.stream().filter(su -> su.getVersion().equals(iu2.getVersion())).findFirst().ifPresent(result::add);
                    }
                    return new CollectionResult(result);
                }
                return slice;
            }

            @Override
            protected Stream<IInstallableUnit> selectIUsForRequirement(IQueryable<IInstallableUnit> queryable, IRequirement req) {
                Stream<IInstallableUnit> stream = super.selectIUsForRequirement(queryable, req);
                if (TychoMirrorApplication.this.targetPlatform == null) {
                    return stream;
                }
                List<IInstallableUnit> list = stream.toList();
                if (list.isEmpty() && req.getMin() > 0) {
                    return this.selectHighestIUsForRequirement((IQueryable<IInstallableUnit>)TychoMirrorApplication.this.targetPlatform.getMetadataRepository(), req);
                }
                return list.stream();
            }

            protected Stream<IInstallableUnit> selectHighestIUsForRequirement(IQueryable<IInstallableUnit> queryable, IRequirement req) {
                Map<String, List<IInstallableUnit>> groupById = queryable.query(QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]), null).stream().filter(this::isApplicable).collect(Collectors.groupingBy(IVersionedId::getId));
                return groupById.values().stream().flatMap(list -> list.stream().sorted(Comparator.comparing(IVersionedId::getVersion).reversed()).limit(req.getMax()));
            }
        };
    }

    @Override
    protected IMetadataRepository initializeDestination(RepositoryDescriptor toInit, IMetadataRepositoryManager mgr) throws ProvisionException {
        IMetadataRepository result = super.initializeDestination(toInit, mgr);
        List refs = Stream.of(this.destination.getRepositoryReferences(), this.destination.getFilterableRepositoryReferences()).flatMap(Collection::stream).flatMap(TychoMirrorApplication::toSpiRepositoryReferences).toList();
        result.addReferences(refs);
        return result;
    }

    private static Stream<RepositoryReference> toSpiRepositoryReferences(org.eclipse.tycho.p2.tools.RepositoryReference rr) {
        return Stream.of(0, 1).map(type -> {
            URI location = TychoMirrorApplication.getNormalizedLocation(rr);
            int options = rr.enable() ? 1 : 0;
            return new RepositoryReference(location, rr.name(), type.intValue(), options);
        });
    }

    private static URI getNormalizedLocation(org.eclipse.tycho.p2.tools.RepositoryReference r) {
        String location = r.location();
        return URI.create(location.endsWith("/") ? location.substring(0, location.length() - 1) : location);
    }

    @Override
    protected void finalizeRepositories() {
        Collection references;
        IMetadataRepository repository = this.getDestinationMetadataRepository();
        if (repository != null && !(references = repository.getReferences()).isEmpty()) {
            this.logger.info("Adding references to the following repositories:");
            references.stream().map(r -> r.getLocation()).distinct().forEach(loc -> this.logger.info("  " + String.valueOf(loc)));
        }
        super.finalizeRepositories();
    }

    @Override
    protected List<IArtifactKey> collectArtifactKeys(Collection<IInstallableUnit> ius, IProgressMonitor monitor) throws ProvisionException {
        List<IArtifactKey> keys = super.collectArtifactKeys(ius, monitor);
        if (this.isFilterProvidedItems()) {
            this.removeProvidedItems((Collection)keys, (IRepositoryManager)this.getArtifactRepositoryManager(), 1, monitor);
        }
        return keys;
    }

    @Override
    protected Set<IInstallableUnit> collectUnits(IQueryable<IInstallableUnit> slice, IProgressMonitor monitor) throws ProvisionException {
        Set<IInstallableUnit> units = super.collectUnits(slice, monitor);
        if (this.isFilterProvidedItems()) {
            Map<String, Set<Version>> fullRepositoryContent = units.stream().collect(Collectors.groupingBy(IVersionedId::getId, Collectors.mapping(IVersionedId::getVersion, Collectors.toSet())));
            IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
            Map<URI, IRepository<IInstallableUnit>> metadataRepositories = this.removeProvidedItems((Collection)units, (IRepositoryManager)manager, 0, monitor);
            if (this.addOnlyProvidingRepoReferences) {
                Set<URI> removableReferences = this.destination.getFilterableRepositoryReferences().stream().map(TychoMirrorApplication::getNormalizedLocation).collect(Collectors.toSet());
                this.destination.getRepositoryReferences().stream().map(TychoMirrorApplication::getNormalizedLocation).forEach(removableReferences::remove);
                if (!removableReferences.isEmpty()) {
                    this.removeNotProvidingReferences(fullRepositoryContent, metadataRepositories, removableReferences, manager);
                }
            }
        }
        return units;
    }

    private boolean isFilterProvidedItems() {
        return this.filterProvided && !this.destinationMetadataRepository.getReferences().isEmpty();
    }

    private <T> Map<URI, IRepository<T>> removeProvidedItems(Collection<T> allElements, IRepositoryManager<T> repoManager, int repositoryType, IProgressMonitor monitor) throws ProvisionException {
        HashMap referencedRepositories = new HashMap();
        for (IRepositoryReference reference : this.destinationMetadataRepository.getReferences()) {
            if (reference.getType() != repositoryType) continue;
            try {
                URI location = reference.getLocation();
                IRepository repository = repoManager.loadRepository(location, monitor);
                referencedRepositories.put(location, repository);
            }
            catch (IllegalArgumentException e2) {
                Throwable throwable = e2.getCause();
                if (throwable instanceof URISyntaxException) {
                    URISyntaxException uriException = (URISyntaxException)throwable;
                    throw new ProvisionException("Can't parse referenced URI!", (Throwable)uriException);
                }
                throw e2;
            }
        }
        allElements.removeIf(e -> referencedRepositories.values().stream().anyMatch(repo -> repo.contains(e)));
        return referencedRepositories;
    }

    private void removeNotProvidingReferences(Map<String, Set<Version>> fullRepositoryContent, Map<URI, IRepository<IInstallableUnit>> metadataRepositories, Set<URI> removableReferenceURIs, IMetadataRepositoryManager manager) {
        HashMap usedRepositoryItems = new HashMap();
        HashMap providedItems = new HashMap();
        for (Map.Entry<URI, IRepository<IInstallableUnit>> repo2 : metadataRepositories.entrySet()) {
            Set content = this.getRepositoryContent(repo2.getKey(), repo2.getValue(), new HashSet<URI>(), manager).collect(Collectors.toSet());
            Set usedRepoContent = content.stream().filter(a -> fullRepositoryContent.getOrDefault(a.getId(), Set.of()).contains(a.getVersion())).collect(Collectors.toSet());
            usedRepositoryItems.put(repo2.getKey(), usedRepoContent);
            providedItems.put(repo2.getKey(), content);
        }
        usedRepositoryItems.entrySet().removeIf(repo -> {
            if (removableReferenceURIs.contains(repo.getKey())) {
                Set usedContent = (Set)repo.getValue();
                if (usedContent.isEmpty()) {
                    this.logger.info("Remove reference " + String.valueOf(repo.getKey()) + " because no units are contained in the repository.");
                    return true;
                }
                for (Map.Entry entry : usedRepositoryItems.entrySet()) {
                    Set other;
                    if (entry == repo || (other = providedItems.getOrDefault(entry.getKey(), Set.of())).isEmpty() || !other.containsAll(usedContent)) continue;
                    this.logger.info("Remove reference " + String.valueOf(repo.getKey()) + " because all units are also contained in reference " + String.valueOf(entry.getKey()) + " already.");
                    return true;
                }
            }
            return false;
        });
        IMetadataRepository repository = this.getDestinationMetadataRepository();
        List<IRepositoryReference> discardedReferences = repository.getReferences().stream().filter(rr -> !usedRepositoryItems.keySet().contains(rr.getLocation())).toList();
        repository.removeReferences(discardedReferences);
    }

    private Stream<IInstallableUnit> getRepositoryContent(URI uri, IRepository<IInstallableUnit> repo, Set<URI> visited, IMetadataRepositoryManager manager) {
        if (visited.add(uri)) {
            Stream<IInstallableUnit> stream = repo.query(QueryUtil.ALL_UNITS, null).stream();
            if (repo instanceof IMetadataRepository) {
                IMetadataRepository meta = (IMetadataRepository)repo;
                Collection references = meta.getReferences();
                for (IRepositoryReference reference : references) {
                    if (reference.getType() != 0 || !this.isEnabled(reference)) continue;
                    try {
                        URI referenceLocation = reference.getLocation();
                        IMetadataRepository referenceRepository = manager.loadRepository(referenceLocation, null);
                        stream = Stream.concat(stream, this.getRepositoryContent(referenceLocation, (IRepository<IInstallableUnit>)referenceRepository, visited, manager));
                    }
                    catch (ProvisionException provisionException) {}
                }
            }
            return stream;
        }
        return Stream.empty();
    }

    private boolean isEnabled(IRepositoryReference reference) {
        return (reference.getOptions() & 1) != 0;
    }

    public void setIncludeSources(boolean includeAllSource, TargetPlatform targetPlatform) {
        this.includeAllSource = includeAllSource;
        this.targetPlatform = targetPlatform;
    }

    public void setIncludeRequiredBundles(boolean includeRequiredBundles) {
        this.includeRequiredBundles = includeRequiredBundles;
    }

    public void setIncludeRequiredFeatures(boolean includeRequiredFeatures) {
        this.includeRequiredFeatures = includeRequiredFeatures;
    }

    public void setFilterProvided(boolean filterProvided) {
        this.filterProvided = filterProvided;
    }

    public void setAddOnlyProvidingRepoReferences(boolean addOnlyProvidingRepoReferences) {
        this.addOnlyProvidingRepoReferences = addOnlyProvidingRepoReferences;
    }
}

