/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools.copiedfromp2;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.RootIUAction;
import org.eclipse.equinox.p2.publisher.actions.RootIUResultFilterAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.p2tools.copiedfromp2.AbstractPublisherApplication;

public class FeaturesAndBundlesPublisherApplication
extends AbstractPublisherApplication {
    protected File[] features = null;
    protected File[] bundles = null;
    protected String rootIU = null;
    protected String rootVersion = null;

    public FeaturesAndBundlesPublisherApplication(IProvisioningAgent agent) {
        super(agent);
    }

    @Override
    protected void processParameter(String arg, String parameter, PublisherInfo pinfo) throws URISyntaxException {
        super.processParameter(arg, parameter, pinfo);
        if (arg.equalsIgnoreCase("-features")) {
            this.features = this.createFiles(parameter);
        }
        if (arg.equalsIgnoreCase("-bundles")) {
            this.bundles = this.createFiles(parameter);
        }
        if (arg.equalsIgnoreCase("-iu")) {
            this.rootIU = parameter;
        }
        if (arg.equalsIgnoreCase("-version")) {
            this.rootVersion = parameter;
        }
    }

    private File[] createFiles(String parameter) {
        String[] filespecs = AbstractPublisherAction.getArrayFromString((String)parameter, (String)",");
        File[] result = new File[filespecs.length];
        for (int i = 0; i < filespecs.length; ++i) {
            result[i] = new File(filespecs[i]);
        }
        return result;
    }

    @Override
    protected IPublisherAction[] createActions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.features == null) {
            this.features = new File[]{new File(this.source, "features")};
        }
        result.add(new FeaturesAction(this.features));
        if (this.bundles == null) {
            this.bundles = new File[]{new File(this.source, "plugins")};
        }
        result.add(new BundlesAction(this.bundles));
        if (this.rootIU != null) {
            result.add(new RootIUAction(this.rootIU, Version.parseVersion((String)this.rootVersion), this.rootIU));
            this.info.addAdvice((IPublisherAdvice)new RootIUResultFilterAdvice(null));
        }
        return result.toArray(new IPublisherAction[result.size()]);
    }
}

