/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools.copiedfromp2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.ProfileWriter;
import org.eclipse.equinox.internal.p2.engine.ProfileXMLConstants;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorImpl;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.p2tools.copiedfromp2.AbstractApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.RepositoryDescriptor;

public class Repo2Runnable
extends AbstractApplication
implements IApplication {
    private static final String NATIVE_ARTIFACTS = "nativeArtifacts";
    private static final String NATIVE_TYPE = "org.eclipse.equinox.p2.native";
    private static final String PARM_OPERAND = "operand";
    private static final String PARM_PROFILE = "profile";
    private boolean createFragments;
    private boolean flagAsRunnable = false;
    private Collection<IInstallableUnit> processedIUs = new ArrayList<IInstallableUnit>();

    public Repo2Runnable(IProvisioningAgent agent) {
        super(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        this.initializeRepos((IProgressMonitor)progress);
        this.validate();
        this.collectIUs((IProgressMonitor)progress.newChild(1));
        IProfile profile = this.createProfile();
        try {
            IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
            if (engine == null) {
                throw new ProvisionException(Messages.exception_noEngineService);
            }
            ProvisioningContext context = new ProvisioningContext(this.agent);
            context.setMetadataRepositories(this.getRepositories(true));
            context.setArtifactRepositories(this.getRepositories(false));
            IProvisioningPlan plan = engine.createPlan(profile, context);
            for (IInstallableUnit iu : this.processedIUs) {
                plan.addInstallableUnit(iu);
            }
            IStatus result = engine.perform(plan, (IPhaseSet)this.getPhaseSet(), (IProgressMonitor)progress.newChild(1));
            PhaseSet nativeSet = this.getNativePhase();
            if (nativeSet != null) {
                engine.perform(plan, (IPhaseSet)nativeSet, (IProgressMonitor)progress.newChild(1));
            }
            this.publishMetadata((IProgressMonitor)progress.newChild(1));
            this.setRunnableProperty(this.destinationArtifactRepository);
            if (this.createFragments) {
                File parentDir = new File(this.destinationArtifactRepository.getLocation().toString().substring(5));
                File pluginsDir = new File(parentDir, "plugins");
                File fragmentInfo = new File(parentDir, "fragment.info");
                HashSet<BundleInfo> bundles = new HashSet<BundleInfo>();
                try {
                    block7: for (IInstallableUnit iu : this.processedIUs) {
                        if (iu.getId().equals("a.jre")) continue;
                        Collection providedCapabilities = iu.getProvidedCapabilities();
                        for (IProvidedCapability cap : providedCapabilities) {
                            if (!"org.eclipse.equinox.p2.eclipse.type".equals(cap.getNamespace()) || !"bundle".equals(cap.getName())) continue;
                            File candidate = new File(pluginsDir, iu.getId() + "_" + String.valueOf(iu.getVersion()));
                            if (candidate.exists()) {
                                bundles.add(new BundleInfo(iu.getId(), iu.getVersion().toString(), candidate.toURI(), 4, false));
                            }
                            if (!(candidate = new File(pluginsDir, iu.getId() + "_" + String.valueOf(iu.getVersion()) + ".jar")).exists()) continue block7;
                            bundles.add(new BundleInfo(iu.getId(), iu.getVersion().toString(), candidate.toURI(), 4, false));
                            continue block7;
                        }
                    }
                    SimpleConfiguratorManipulatorImpl simpleManipulator = new SimpleConfiguratorManipulatorImpl();
                    simpleManipulator.saveConfiguration(bundles.toArray(new BundleInfo[0]), fragmentInfo, parentDir.toURI());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            this.removeProfile(profile);
            this.finalizeRepositories();
        }
    }

    private void setRunnableProperty(IArtifactRepository destinationArtifactRepository) {
        if (this.flagAsRunnable) {
            destinationArtifactRepository.setProperty("p2.runnable", Boolean.TRUE.toString(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected URI[] getRepositories(boolean metadata) {
        ArrayList<URI> repos = new ArrayList<URI>();
        for (RepositoryDescriptor repo : this.sourceRepositories) {
            if (!(metadata ? repo.isMetadata() : repo.isArtifact())) continue;
            repos.add(repo.getRepoLocation());
        }
        return repos.toArray(new URI[repos.size()]);
    }

    protected PhaseSet getPhaseSet() {
        return new PhaseSet(new Phase[]{new Collect(100)}){};
    }

    protected PhaseSet getNativePhase() {
        return new PhaseSet(new Phase[]{new CollectNativesPhase(100)}){};
    }

    private void collectIUs(IProgressMonitor monitor) throws ProvisionException {
        if (this.sourceIUs != null && !this.sourceIUs.isEmpty()) {
            this.processedIUs = this.sourceIUs;
            return;
        }
        if (!this.hasMetadataSources()) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
        Iterator itor = this.getAllIUs(this.getCompositeMetadataRepository(), monitor).iterator();
        while (itor.hasNext()) {
            this.processedIUs.add((IInstallableUnit)itor.next());
        }
        if (this.processedIUs.isEmpty()) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
    }

    private void publishMetadata(IProgressMonitor monitor) {
        if (this.destinationMetadataRepository == null) {
            return;
        }
        this.destinationMetadataRepository.addInstallableUnits(this.processedIUs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueryResult<IInstallableUnit> getAllIUs(IMetadataRepository repository, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IQueryResult iQueryResult = repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)progress.newChild(1));
            return iQueryResult;
        }
        finally {
            progress.done();
        }
    }

    private void removeProfile(IProfile profile) throws ProvisionException {
        IProfileRegistry registry = (IProfileRegistry)this.agent.getService(IProfileRegistry.class);
        registry.removeProfile(profile.getProfileId());
    }

    private IProfile createProfile() throws ProvisionException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.cache", URIUtil.toFile((URI)this.destinationArtifactRepository.getLocation()).getAbsolutePath());
        properties.put("org.eclipse.equinox.p2.installFolder", URIUtil.toFile((URI)this.destinationArtifactRepository.getLocation()).getAbsolutePath());
        IProfileRegistry registry = (IProfileRegistry)this.agent.getService(IProfileRegistry.class);
        return registry.addProfile(System.currentTimeMillis() + "-" + Math.random(), properties);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.processCommandLineArgs(args);
        this.run(null);
        return IApplication.EXIT_OK;
    }

    private void processCommandLineArgs(String[] args) throws URISyntaxException {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            String arg = null;
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                arg = args[++i];
            }
            if (option.equalsIgnoreCase("-source")) {
                RepositoryDescriptor source = new RepositoryDescriptor();
                source.setLocation(URIUtil.fromString(arg));
                this.addSource(source);
            }
            if (option.equalsIgnoreCase("-destination")) {
                RepositoryDescriptor destination = new RepositoryDescriptor();
                destination.setLocation(URIUtil.fromString((String)arg));
                this.addDestination(destination);
            }
            if (option.equalsIgnoreCase("-flagAsRunnable")) {
                this.setFlagAsRunnable(true);
            }
            if (!option.equalsIgnoreCase("-createFragments")) continue;
            this.setCreateFragments(true);
        }
    }

    public void setFlagAsRunnable(boolean runnable) {
        this.flagAsRunnable = runnable;
    }

    private void validate() throws ProvisionException {
        if (!this.hasMetadataSources() && this.sourceIUs == null) {
            throw new ProvisionException(Messages.exception_needIUsOrNonEmptyRepo);
        }
        if (this.destinationArtifactRepository == null) {
            throw new ProvisionException(Messages.exception_needDestinationRepo);
        }
    }

    public void stop() {
    }

    public void setCreateFragments(boolean createFragments) {
        this.createFragments = createFragments;
    }

    protected class CollectNativesPhase
    extends InstallableUnitPhase {
        public CollectNativesPhase(int weight) {
            super(Repo2Runnable.NATIVE_ARTIFACTS, weight);
        }

        protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
            IInstallableUnit unit = operand.second();
            if (unit.getTouchpointType().getId().equals(Repo2Runnable.NATIVE_TYPE)) {
                return Collections.singletonList(new CollectNativesAction());
            }
            return null;
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            parameters.put(Repo2Runnable.NATIVE_ARTIFACTS, new ArrayList());
            return null;
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            List artifactRequests = (List)parameters.get(Repo2Runnable.NATIVE_ARTIFACTS);
            ProvisioningContext context = (ProvisioningContext)parameters.get("context");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            DownloadManager dm = new DownloadManager(context, agent);
            for (IArtifactRequest request : artifactRequests) {
                dm.add(request);
            }
            return dm.start(monitor);
        }
    }

    static class Writer
    extends ProfileWriter {
        public Writer(OutputStream output) {
            super(output, new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeTargetVersionInstruction((String)Repo2Runnable.PARM_PROFILE, (Version)ProfileXMLConstants.CURRENT_VERSION)});
        }
    }

    protected class CollectNativesAction
    extends ProvisioningAction {
        protected CollectNativesAction() {
        }

        public IStatus execute(Map<String, Object> parameters) {
            InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get(Repo2Runnable.PARM_OPERAND);
            IInstallableUnit installableUnit = operand.second();
            IArtifactRepositoryManager manager = Repo2Runnable.this.getArtifactRepositoryManager();
            Collection toDownload = installableUnit.getArtifacts();
            if (toDownload == null) {
                return Status.OK_STATUS;
            }
            List artifactRequests = (List)parameters.get(Repo2Runnable.NATIVE_ARTIFACTS);
            IProfile profile = (IProfile)parameters.get(Repo2Runnable.PARM_PROFILE);
            String statsParameter = null;
            if (profile != null) {
                statsParameter = profile.getProperty("org.eclipse.equinox.p2.stats.parameters");
            }
            for (IArtifactKey keyToDownload : toDownload) {
                IArtifactRequest request = manager.createMirrorRequest(keyToDownload, Repo2Runnable.this.destinationArtifactRepository, null, null, statsParameter);
                artifactRequests.add(request);
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return Status.OK_STATUS;
        }
    }
}

