/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools.copiedfromp2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;

public class Slicer {
    private static boolean DEBUG = false;
    private final IQueryable<IInstallableUnit> possibilites;
    private final boolean considerMetaRequirements;
    protected final IInstallableUnit selectionContext;
    private final Map<String, Map<Version, IInstallableUnit>> slice = new HashMap<String, Map<Version, IInstallableUnit>>();
    private final MultiStatus result = new MultiStatus(Slicer.class, 0, Messages.Planner_Problems_resolving_plan);
    private Queue<IInstallableUnit> toProcess;
    private Set<IInstallableUnit> considered;
    private final Set<IInstallableUnit> nonGreedyIUs = new HashSet<IInstallableUnit>();
    private Set<IRequirement> consideredRequirements = new HashSet<IRequirement>();

    public Slicer(IQueryable<IInstallableUnit> input, Map<String, String> context, boolean considerMetaRequirements) {
        this(input, InstallableUnit.contextIU(context), considerMetaRequirements);
    }

    public Slicer(IQueryable<IInstallableUnit> possibilites, IInstallableUnit selectionContext, boolean considerMetaRequirements) {
        this.possibilites = possibilites;
        this.selectionContext = selectionContext;
        this.considerMetaRequirements = considerMetaRequirements;
    }

    public IQueryable<IInstallableUnit> slice(Collection<IInstallableUnit> ius, IProgressMonitor monitor) {
        monitor = IProgressMonitor.nullSafe((IProgressMonitor)monitor);
        try {
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
                System.out.println("Start slicing: " + start);
            }
            this.validateInput(ius);
            this.considered = new HashSet<IInstallableUnit>(ius);
            this.toProcess = new LinkedList<IInstallableUnit>(this.considered);
            while (!this.toProcess.isEmpty()) {
                if (monitor.isCanceled()) {
                    this.result.merge(Status.CANCEL_STATUS);
                    throw new OperationCanceledException();
                }
                this.processIU(this.toProcess.remove());
            }
            this.computeNonGreedyIUs();
            if (DEBUG) {
                long stop = System.currentTimeMillis();
                System.out.println("Slicing complete: " + (stop - start));
            }
        }
        catch (IllegalStateException e) {
            this.result.add(Status.error((String)e.getMessage(), (Throwable)e));
        }
        if (Tracing.DEBUG && this.result.getSeverity() != 0) {
            LogHelper.log((IStatus)this.result);
        }
        if (this.result.getSeverity() == 4) {
            return null;
        }
        return new QueryableArray(this.considered, false);
    }

    private void computeNonGreedyIUs() {
        QueryableArray queryable = new QueryableArray(this.considered, false);
        for (IInstallableUnit iu : queryable.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor())) {
            iu = iu.unresolved();
            Collection<IRequirement> reqs = this.getRequirements(iu);
            for (IRequirement req : reqs) {
                if (!this.isApplicable(iu, req) || this.isGreedy(iu, req)) continue;
                this.nonGreedyIUs.addAll(queryable.query(QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]), null).toUnmodifiableSet());
            }
        }
    }

    public MultiStatus getStatus() {
        return this.result;
    }

    private void validateInput(Collection<IInstallableUnit> ius) {
        for (IInstallableUnit iu : ius) {
            if (this.isApplicable(iu)) continue;
            throw new IllegalStateException(NLS.bind((String)Messages.Explanation_missingRootFilter, (Object)iu));
        }
    }

    protected boolean isApplicable(IInstallableUnit unit, IRequirement req) {
        return this.isApplicable(req);
    }

    protected boolean isApplicable(IRequirement req) {
        IMatchExpression filter = req.getFilter();
        return filter == null || filter.isMatch((Object)this.selectionContext);
    }

    protected boolean isApplicable(IInstallableUnit iu) {
        IMatchExpression filter = iu.getFilter();
        return filter == null || filter.isMatch((Object)this.selectionContext);
    }

    protected void processIU(IInstallableUnit iu) {
        iu = iu.unresolved();
        Map iuSlice = this.slice.computeIfAbsent(iu.getId(), i -> new HashMap());
        iuSlice.put(iu.getVersion(), iu);
        if (!this.isApplicable(iu)) {
            return;
        }
        Collection<IRequirement> reqs = this.getRequirements(iu);
        for (IRequirement req : reqs) {
            if (!this.isApplicable(iu, req) || !this.isGreedy(iu, req)) continue;
            this.expandRequirement(iu, req);
        }
    }

    protected boolean isGreedy(IInstallableUnit unit, IRequirement req) {
        return this.isGreedy(req);
    }

    protected boolean isGreedy(IRequirement req) {
        return req.isGreedy();
    }

    private Collection<IRequirement> getRequirements(IInstallableUnit iu) {
        boolean isPatch = iu instanceof IInstallableUnitPatch;
        boolean isFragment = iu instanceof IInstallableUnitFragment;
        if (!isFragment && !isPatch && iu.getMetaRequirements().isEmpty()) {
            return iu.getRequirements();
        }
        ArrayList<IRequirement> aggregatedRequirements = new ArrayList<IRequirement>(iu.getRequirements().size() + iu.getMetaRequirements().size() + (isFragment ? ((IInstallableUnitFragment)iu).getHost().size() : 0) + (isPatch ? ((IInstallableUnitPatch)iu).getRequirementsChange().size() : 0));
        aggregatedRequirements.addAll(iu.getRequirements());
        if (iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment iuFragment = (IInstallableUnitFragment)iu;
            aggregatedRequirements.addAll(iuFragment.getHost());
        }
        if (iu instanceof InstallableUnitPatch) {
            InstallableUnitPatch patchIU = (InstallableUnitPatch)iu;
            List changes = patchIU.getRequirementsChange();
            for (IRequirementChange change : changes) {
                aggregatedRequirements.add((IRequirement)change.newValue());
            }
        }
        if (this.considerMetaRequirements) {
            aggregatedRequirements.addAll(iu.getMetaRequirements());
        }
        return aggregatedRequirements;
    }

    private void expandRequirement(IInstallableUnit iu, IRequirement req) {
        if (req.getMax() == 0) {
            return;
        }
        if (this.consideredRequirements.add(req)) {
            List<IInstallableUnit> selected = this.selectIUsForRequirement(this.possibilites, req).toList();
            for (IInstallableUnit match : selected) {
                Map<Version, IInstallableUnit> iuSlice = this.slice.get(match.getId());
                if (iuSlice != null && iuSlice.containsKey(match.getVersion()) || !this.considered.add(match)) continue;
                this.toProcess.add(match);
            }
            if (selected.isEmpty()) {
                if (req.getMin() == 0) {
                    if (DEBUG) {
                        System.out.println("No IU found to satisfy optional dependency of " + String.valueOf(iu) + " on req " + String.valueOf(req));
                    }
                } else {
                    this.result.add(Status.warning((String)NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
                }
            }
        }
    }

    protected Stream<IInstallableUnit> selectIUsForRequirement(IQueryable<IInstallableUnit> queryable, IRequirement req) {
        return queryable.query(QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]), null).stream().filter(this::isApplicable);
    }

    Set<IInstallableUnit> getNonGreedyIUs() {
        return this.nonGreedyIUs;
    }
}

