/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.bnd;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TargetPlatformService;

@Component(role=RepositoryPlugin.class, hint="tycho-target-platform")
public class TargetPlatformRepository
implements RepositoryPlugin {
    static final String HINT = "tycho-target-platform";
    @Requirement
    private TargetPlatformService targetPlatformService;

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        TargetPlatform targetPlatform = this.targetPlatformService.getTargetPlatform().orElse(null);
        if (targetPlatform == null) {
            return null;
        }
        ArtifactKey artifact = targetPlatform.resolveArtifact("eclipse-plugin", bsn, version.toString());
        if (artifact != null) {
            File location = targetPlatform.getArtifactLocation(artifact);
            if (location != null) {
                for (RepositoryPlugin.DownloadListener downloadListener : listeners) {
                    downloadListener.success(location, properties);
                }
            }
            return location;
        }
        return null;
    }

    public List<String> list(String pattern) throws Exception {
        TargetPlatform targetPlatform = this.targetPlatformService.getTargetPlatform().orElse(null);
        if (targetPlatform == null) {
            return List.of();
        }
        Instruction filter = null;
        if (pattern != null) {
            filter = new Instruction(pattern);
        }
        HashSet<String> result = new HashSet<String>();
        IQueryResult query = targetPlatform.getMetadataRepository().query(QueryUtil.ALL_UNITS, null);
        for (IInstallableUnit iu : query) {
            for (IArtifactKey artifactKey : iu.getArtifacts()) {
                if (!"osgi.bundle".equals(artifactKey.getClassifier())) continue;
                String id = artifactKey.getId();
                if (filter != null && !filter.matches(id)) continue;
                result.add(id);
            }
        }
        return List.copyOf(result);
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        TargetPlatform targetPlatform = this.targetPlatformService.getTargetPlatform().orElse(null);
        if (targetPlatform == null) {
            return Collections.emptySortedSet();
        }
        TreeSet<Version> set = new TreeSet<Version>();
        for (IInstallableUnit iu : targetPlatform.getMetadataRepository().query(QueryUtil.createIUQuery((String)bsn), null)) {
            for (IArtifactKey artifactKey : iu.getArtifacts()) {
                if (!"osgi.bundle".equals(artifactKey.getClassifier())) continue;
                set.add(new Version(artifactKey.getVersion().toString()));
            }
        }
        return set;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite() {
        return false;
    }

    public String getName() {
        return "Tycho Target Platform";
    }

    public String getLocation() {
        return HINT;
    }
}

