/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ExecutionEnvironment;
import org.eclipse.tycho.core.ee.EEVersion;
import org.eclipse.tycho.core.ee.ListSystemPackages;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class StandardExecutionEnvironment
implements Comparable<StandardExecutionEnvironment>,
ExecutionEnvironment {
    private static final Map<String, String> TARGET_ALIASES;
    private final String profileName;
    private final String compilerSourceLevel;
    private final String compilerTargetLevel;
    private List<ExecutionEnvironment.SystemPackageEntry> systemPackages;
    private final EEVersion eeVersion;
    private final Properties profileProperties;
    private final Toolchain toolchain;
    private Logger logger;

    StandardExecutionEnvironment(Properties profileProperties, Toolchain toolchain, Logger logger) {
        Objects.requireNonNull(profileProperties);
        this.toolchain = toolchain;
        this.profileName = profileProperties.getProperty("osgi.java.profile.name");
        this.compilerSourceLevel = profileProperties.getProperty("org.eclipse.jdt.core.compiler.source");
        this.compilerTargetLevel = profileProperties.getProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
        this.eeVersion = StandardExecutionEnvironment.parseEEVersion(profileProperties.getProperty("org.osgi.framework.system.capabilities"));
        this.profileProperties = new Properties();
        this.profileProperties.putAll((Map<?, ?>)profileProperties);
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JavaInfo readFromToolchains(Toolchain toolchain, Logger logger) {
        if (toolchain == null) {
            return new JavaInfo(-1, Collections.emptySet());
        }
        String java = toolchain.findTool("java");
        if (java == null) {
            return new JavaInfo(-1, Collections.emptySet());
        }
        HashSet<String> res = new HashSet<String>();
        int version = -1;
        try {
            ProcessBuilder builder = new ProcessBuilder(java, "-jar", StandardExecutionEnvironment.getSystemPackagesCompanionJar().getAbsolutePath());
            BufferedReader reader = new BufferedReader(new InputStreamReader(builder.start().getInputStream(), Charset.defaultCharset()));
            try {
                String line = reader.readLine();
                try {
                    if (line != null) {
                        version = Integer.parseInt(line);
                    }
                }
                catch (NumberFormatException e) {
                    StringBuilder sb = new StringBuilder(line);
                    while (true) {
                        if ((line = reader.readLine()) == null) {
                            logger.debug("[ReadPackagesFromToolchains] Cannot read Java version for " + java + ", full output was: " + sb);
                            JavaInfo javaInfo = new JavaInfo(-1, List.of());
                            reader.close();
                            return javaInfo;
                        }
                        sb.append(System.lineSeparator());
                        sb.append(line);
                    }
                }
                while ((line = reader.readLine()) != null) {
                    res.add(line);
                }
                return new JavaInfo(version, res);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            logger.error("[ReadPackagesFromToolchains] start JVM process for " + java + " failed: " + e);
        }
        return new JavaInfo(version, res);
    }

    static File getSystemPackagesCompanionJar() throws IOException {
        File companionFile = File.createTempFile("tycho-system-packages-companion", ".jar");
        companionFile.deleteOnExit();
        try (InputStream contents = ListSystemPackages.class.getClassLoader().getResourceAsStream("system-packages-companion.jar");){
            FileUtils.copyToFile((InputStream)contents, (File)companionFile);
        }
        return companionFile;
    }

    private static EEVersion parseEEVersion(String systemCaps) {
        ArrayList<EEVersion> eeVersions = new ArrayList<EEVersion>();
        try {
            ManifestElement[] systemCapValues;
            for (ManifestElement systemCapValue : systemCapValues = ManifestElement.parseHeader((String)"org.osgi.framework.system.capabilities", (String)systemCaps)) {
                Version version;
                String singleVersion = systemCapValue.getAttribute("version:Version");
                if (singleVersion != null) {
                    version = Version.parseVersion((String)singleVersion);
                } else {
                    String[] versions = systemCapValue.getAttribute("version:List<Version>").split(",");
                    ArrayList<Version> osgiVersions = new ArrayList<Version>(versions.length);
                    for (String currentVersion : versions) {
                        osgiVersions.add(Version.parseVersion((String)currentVersion));
                    }
                    version = (Version)Collections.max(osgiVersions);
                }
                String execEnv = systemCapValue.getAttribute("osgi.ee");
                EEVersion.EEType eeType = EEVersion.EEType.fromName(execEnv);
                if (eeType == null) continue;
                eeVersions.add(new EEVersion(version, eeType));
            }
            return (EEVersion)Collections.max(eeVersions);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getCompilerSourceLevelDefault() {
        return this.compilerSourceLevel;
    }

    public String getCompilerTargetLevelDefault() {
        return this.compilerTargetLevel;
    }

    public String toString() {
        return "OSGi profile '" + this.getProfileName() + "' { source level: " + this.compilerSourceLevel + ", target level: " + this.compilerTargetLevel + "}";
    }

    public synchronized Collection<ExecutionEnvironment.SystemPackageEntry> getSystemPackages() {
        if (this.systemPackages == null) {
            if (this.profileProperties.containsKey("org.osgi.framework.system.packages")) {
                this.logger.debug("Found system.packages in profile definition file for " + this.profileName + ",");
                String systemPackagesValue = this.profileProperties.getProperty("org.osgi.framework.system.packages");
                if (systemPackagesValue.isBlank()) {
                    this.systemPackages = Collections.emptyList();
                } else {
                    try {
                        this.systemPackages = Arrays.stream(ManifestElement.parseHeader((String)"org.osgi.framework.system.packages", (String)systemPackagesValue)).map(jrePackage -> {
                            String packageName = jrePackage.getValue();
                            String version = jrePackage.getAttribute("version");
                            return new ExecutionEnvironment.SystemPackageEntry(packageName, version);
                        }).toList();
                    }
                    catch (BundleException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        this.systemPackages = Collections.emptyList();
                    }
                }
            } else if (this.toolchain != null) {
                this.logger.debug("No system.packages in profile definition file for " + this.profileName + "; checking toolchain.");
                this.systemPackages = StandardExecutionEnvironment.readFromToolchains((Toolchain)this.toolchain, (Logger)this.logger).packages.stream().map(packageName -> new ExecutionEnvironment.SystemPackageEntry(packageName, null)).toList();
            } else if (Integer.parseInt(this.compilerSourceLevel) == Runtime.version().feature()) {
                this.logger.debug("Currently running JRE matches source level for " + this.getProfileName() + "; current JRE system packages are used.");
                this.systemPackages = ListSystemPackages.getCurrentJREPackages().stream().map(packageName -> new ExecutionEnvironment.SystemPackageEntry(packageName, null)).toList();
            }
            if (this.systemPackages == null || this.systemPackages.isEmpty()) {
                this.logger.warn("No system packages found in profile nor toolchain for " + this.profileName + ", using current JRE system packages.\nThis can cause faulty dependency resolution, consider adding a definition for a 'jdk' with id=" + this.profileName + " in your toolchains.xml");
                this.systemPackages = ListSystemPackages.getCurrentJREPackages().stream().map(packageName -> new ExecutionEnvironment.SystemPackageEntry(packageName, null)).toList();
            }
        }
        return this.systemPackages;
    }

    @Override
    public int compareTo(StandardExecutionEnvironment otherEnv) {
        return this.eeVersion.compareTo(otherEnv.eeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.compilerSourceLevel, this.compilerTargetLevel, this.eeVersion, this.profileName, this.profileProperties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof StandardExecutionEnvironment)) return false;
        StandardExecutionEnvironment other = (StandardExecutionEnvironment)obj;
        if (!Objects.equals(this.compilerSourceLevel, other.compilerSourceLevel)) return false;
        if (!Objects.equals(this.compilerTargetLevel, other.compilerTargetLevel)) return false;
        if (!Objects.equals(this.eeVersion, other.eeVersion)) return false;
        if (!Objects.equals(this.profileName, other.profileName)) return false;
        if (!Objects.equals(this.profileProperties, other.profileProperties)) return false;
        return true;
    }

    public Properties getProfileProperties() {
        return this.profileProperties;
    }

    public boolean isCompatibleCompilerTargetLevel(String target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerTargetLevel == null) {
            return true;
        }
        try {
            Version thisTargetVersion = StandardExecutionEnvironment.toTargetVersion(this.compilerTargetLevel);
            Version targetVersion = StandardExecutionEnvironment.toTargetVersion(target);
            return thisTargetVersion.compareTo(targetVersion) >= 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Version toTargetVersion(String target) {
        String targetAlias = TARGET_ALIASES.get(target.trim().toLowerCase());
        if (targetAlias != null) {
            target = targetAlias;
        }
        return Version.parseVersion((String)target);
    }

    Toolchain getToolchain() {
        return this.toolchain;
    }

    Logger getLogger() {
        return this.logger;
    }

    static {
        HashMap<String, String> targetAliases = new HashMap<String, String>();
        targetAliases.put("jsr14", "1.4");
        targetAliases.put("5", "1.5");
        targetAliases.put("5.0", "1.5");
        targetAliases.put("6", "1.6");
        targetAliases.put("6.0", "1.6");
        targetAliases.put("7", "1.7");
        targetAliases.put("7.0", "1.7");
        targetAliases.put("8", "1.8");
        targetAliases.put("8.0", "1.8");
        targetAliases.put("9", "1.9");
        targetAliases.put("9.0", "1.9");
        targetAliases.put("10", "1.10");
        targetAliases.put("10.0", "1.10");
        TARGET_ALIASES = Collections.unmodifiableMap(targetAliases);
    }

    static final class JavaInfo {
        final int version;
        final Collection<String> packages;

        private JavaInfo(int version, Collection<String> packages) {
            this.version = version;
            this.packages = Collections.unmodifiableCollection(packages);
        }
    }
}

