/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee.impl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.core.ee.impl.ExecutionEnvironmentResolutionHandler;
import org.eclipse.tycho.core.shared.MavenLogger;

class StandardEEResolutionHandler
extends ExecutionEnvironmentResolutionHandler {
    private ExecutionEnvironmentConfiguration environmentConfiguration;
    private MavenLogger logger;

    public StandardEEResolutionHandler(ExecutionEnvironmentResolutionHints resolutionHints, ExecutionEnvironmentConfiguration environmentConfiguration, MavenLogger logger) {
        super(resolutionHints);
        this.environmentConfiguration = environmentConfiguration;
        this.logger = logger;
    }

    @Override
    public void readFullSpecification(Collection<IInstallableUnit> targetPlatformContent) {
        if (this.environmentConfiguration.ignoreExecutionEnvironment()) {
            this.logger.info("The following Execution Environments are currently known but are ignored by configuration:");
            Map map = targetPlatformContent.stream().filter(ExecutionEnvironmentResolutionHints::isJreUnit).flatMap(StandardEEResolutionHandler::getEE).collect(Collectors.groupingBy(Map.Entry::getValue, TreeMap::new, Collectors.mapping(Map.Entry::getKey, Collectors.toCollection(TreeSet::new))));
            map.entrySet().forEach(entry -> this.logger.info("    " + (String)entry.getKey() + " -> " + ((Collection)entry.getValue()).stream().collect(Collectors.joining(", "))));
            return;
        }
    }

    private static Stream<Map.Entry<String, String>> getEE(IInstallableUnit specificationUnit) {
        return specificationUnit.getProvidedCapabilities().stream().filter(capability -> "osgi.ee".equals(capability.getNamespace())).map(capability -> new AbstractMap.SimpleEntry<String, String>(capability.getName(), capability.getVersion().toString()));
    }
}

