/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.osgi.adapters.MavenReactorProjectIdentities;
import org.eclipse.tycho.p2.tools.BuildContext;

public abstract class AbstractP2Mojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="buildQualifier")
    private String qualifier;
    @Component
    protected TychoProjectManager projectManager;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ReactorProject getReactorProject() {
        return DefaultReactorProject.adapt(this.project);
    }

    protected ReactorProjectIdentities getProjectIdentities() {
        return new MavenReactorProjectIdentities(this.project);
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected List<TargetEnvironment> getEnvironments() {
        return this.projectManager.getTargetPlatformConfiguration(this.project).getEnvironments();
    }

    protected BuildDirectory getBuildDirectory() {
        return this.getProjectIdentities().getBuildDirectory();
    }

    protected BuildContext getBuildContext() {
        return new BuildContext(this.getProjectIdentities(), this.getQualifier(), this.getEnvironments());
    }
}

