/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.toolchain.java.JavaToolchain;
import org.eclipse.tycho.TargetEnvironment;

final class JavaHomeToolchain
implements JavaToolchain {
    private Path javaHome;

    public JavaHomeToolchain(String javaHome) {
        this.javaHome = Path.of(javaHome, new String[0]).toAbsolutePath();
    }

    public String getType() {
        return "jdk";
    }

    public String findTool(String toolName) {
        Path bin = this.javaHome.resolve("bin");
        if (Files.isDirectory(bin, new LinkOption[0])) {
            String string;
            block10: {
                Path tool = bin.resolve(toolName + (TargetEnvironment.getRunningEnvironment().isWindows() ? ".exe" : ""));
                if (Files.isRegularFile(tool, new LinkOption[0])) {
                    return tool.toString();
                }
                Stream<Path> files = Files.list(bin).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                try {
                    string = files.map(Path::toString).filter(pathname -> FilenameUtils.getBaseName((String)pathname).equalsIgnoreCase(toolName)).findFirst().orElse(null);
                    if (files == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                files.close();
            }
            return string;
        }
        return null;
    }

    public String getJavaHome() {
        return this.javaHome.toString();
    }

    public String toString() {
        return "JDK[" + this.getJavaHome() + "]";
    }
}

