/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.maven.JavaHomeToolchain;
import org.eclipse.tycho.core.maven.OSGiJavaToolchain;

@Component(role=ToolchainProvider.class)
@SessionScoped
public class ToolchainProvider {
    private static final String RUNNING_PROFILE_NAME = "JavaSE-" + Runtime.version().feature();
    static final String TYPE_JDK = "jdk";
    @Requirement
    ToolchainManagerPrivate toolChainManager;
    @Requirement
    ToolchainManager toolchainManager;
    @Requirement
    LegacySupport legacySupport;
    @Requirement
    Logger logger;
    private Map<ToolchainKey, Optional<OSGiJavaToolchain>> toolchainMap = new ConcurrentHashMap<ToolchainKey, Optional<OSGiJavaToolchain>>();
    private MavenSession mavenSession;

    @Inject
    public ToolchainProvider(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public Optional<OSGiJavaToolchain> getToolchain(JDKUsage usage, String profileName) {
        if (usage == JDKUsage.SYSTEM) {
            return this.getSystemToolchain();
        }
        return this.toolchainMap.computeIfAbsent(new ToolchainKey(usage, profileName), key -> {
            JavaHomeToolchain javaHomeToolchain;
            String javaHomeProperty;
            Toolchain toolchain = ExecutionEnvironmentUtils.getToolchainFor(profileName, TargetEnvironment.getRunningEnvironment(), this.toolchainManager, this.getMavenSession(), this.logger);
            if (toolchain != null) {
                return Optional.of(new OSGiJavaToolchain(toolchain));
            }
            if (RUNNING_PROFILE_NAME.equals(profileName) && (javaHomeProperty = System.getProperty("java.home")) != null && (javaHomeToolchain = new JavaHomeToolchain(javaHomeProperty)).findTool("java") != null) {
                return Optional.of(new OSGiJavaToolchain((Toolchain)javaHomeToolchain));
            }
            return Optional.empty();
        });
    }

    private Optional<OSGiJavaToolchain> getSystemToolchain() {
        JavaHomeToolchain javaHomeToolchain;
        Toolchain contextToolchain = this.toolchainManager.getToolchainFromBuildContext(TYPE_JDK, this.getMavenSession());
        if (contextToolchain != null) {
            return Optional.of(new OSGiJavaToolchain(contextToolchain));
        }
        Optional<OSGiJavaToolchain> profileToolchain = this.getToolchain(JDKUsage.BREE, RUNNING_PROFILE_NAME);
        if (profileToolchain.isPresent()) {
            return profileToolchain;
        }
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null && !javaHome.isBlank() && (javaHomeToolchain = new JavaHomeToolchain(javaHome)).findTool("java") != null) {
            return Optional.of(new OSGiJavaToolchain((Toolchain)javaHomeToolchain));
        }
        return Optional.empty();
    }

    private MavenSession getMavenSession() {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            return session;
        }
        return this.mavenSession;
    }

    public DefaultJavaToolChain findMatchingJavaToolChain(MavenSession session, String toolchainId) throws MojoExecutionException {
        try {
            Map<String, String> requirements = Collections.singletonMap("id", toolchainId);
            for (ToolchainPrivate javaToolChain : this.toolChainManager.getToolchainsForType(TYPE_JDK, session)) {
                if (!javaToolChain.matchesRequirements(requirements) || !(javaToolChain instanceof DefaultJavaToolChain)) continue;
                DefaultJavaToolChain defaultJavaToolchain = (DefaultJavaToolChain)javaToolChain;
                return defaultJavaToolchain;
            }
            return null;
        }
        catch (MisconfiguredToolchainException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static enum JDKUsage {
        SYSTEM,
        BREE;

    }

    private record ToolchainKey(JDKUsage usage, String profileName) {
    }
}

