/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.MavenArtifactFacade;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.MultiEnvironmentDependencyArtifacts;
import org.eclipse.tycho.p2resolver.PomReactorProjectFacade;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.osgi.framework.Filter;

public abstract class AbstractTychoProject
extends AbstractLogEnabled
implements TychoProject {
    private static final String CTX_OSGI_BUNDLE_BASENAME = TychoConstants.CTX_BASENAME + "/tychoProject";
    private static final String CTX_MAVEN_SESSION = CTX_OSGI_BUNDLE_BASENAME + "/mavenSession";
    private static final String CTX_MAVEN_PROJECT = CTX_OSGI_BUNDLE_BASENAME + "/mavenProject";
    private static final String CTX_INITIAL_MAVEN_DEPENDENCIES = CTX_OSGI_BUNDLE_BASENAME + "/initialDependencies";
    @Requirement
    protected MavenDependenciesResolver projectDependenciesResolver;
    @Requirement
    protected LegacySupport legacySupport;
    @Requirement
    protected TychoProjectManager projectManager;
    @Requirement
    protected Logger logger;
    @Requirement(hint="p2")
    protected DependencyResolver dependencyResolver;

    @Override
    public DependencyArtifacts getDependencyArtifacts(MavenProject project) {
        return this.getDependencyArtifacts(DefaultReactorProject.adapt(project));
    }

    @Override
    public DependencyArtifacts getDependencyArtifacts(ReactorProject reactorProject) {
        return (DependencyArtifacts)reactorProject.computeContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS, () -> {
            if (this.logger != null) {
                this.logger.info("Resolving dependencies of " + reactorProject);
            }
            MavenSession mavenSession = this.getMavenSession(reactorProject);
            MavenProject mavenProject = AbstractTychoProject.getMavenProject(reactorProject);
            TargetPlatform preliminaryTargetPlatform = this.dependencyResolver.getPreliminaryTargetPlatform(mavenSession, mavenProject);
            TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(mavenProject);
            DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
            DependencyArtifacts dependencyArtifacts = this.dependencyResolver.resolveDependencies(mavenSession, mavenProject, preliminaryTargetPlatform, resolverConfiguration, configuration.getEnvironments());
            if (this.logger != null && this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(mavenSession, mavenProject)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Resolved target platform for ").append(reactorProject).append("\n");
                dependencyArtifacts.toDebugString(sb, "  ");
                this.logger.debug(sb.toString());
            }
            return dependencyArtifacts;
        });
    }

    @Override
    public DependencyArtifacts getTestDependencyArtifacts(ReactorProject project) {
        return (DependencyArtifacts)project.getContextValue(TychoConstants.CTX_TEST_DEPENDENCY_ARTIFACTS);
    }

    @Override
    public DependencyArtifacts getDependencyArtifacts(ReactorProject project, TargetEnvironment environment) {
        MultiEnvironmentDependencyArtifacts multiEnvArtifacts;
        DependencyArtifacts platform = this.getDependencyArtifacts(project);
        if (environment != null && platform instanceof MultiEnvironmentDependencyArtifacts && (platform = (multiEnvArtifacts = (MultiEnvironmentDependencyArtifacts)platform).getPlatform(environment)) == null) {
            throw new IllegalStateException("Unsupported runtime environment " + environment.toString() + " for project " + project.toString());
        }
        return platform;
    }

    public void setupProject(MavenSession session, MavenProject project) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        reactorProject.setContextValue(CTX_MAVEN_SESSION, (Object)session);
        reactorProject.setContextValue(CTX_MAVEN_PROJECT, (Object)project);
        reactorProject.setContextValue(CTX_INITIAL_MAVEN_DEPENDENCIES, List.copyOf(this.collectInitial(project, new HashMap<String, Dependency>()).values()));
    }

    private Map<String, Dependency> collectInitial(MavenProject project, Map<String, Dependency> map) {
        for (Dependency dependency : project.getDependencies()) {
            map.putIfAbsent(dependency.getManagementKey(), dependency);
        }
        MavenProject parent = project.getParent();
        if (parent != null) {
            return this.collectInitial(parent, map);
        }
        return map;
    }

    protected TargetEnvironment[] getEnvironments(ReactorProject project, TargetEnvironment environment) {
        if (environment != null) {
            return new TargetEnvironment[]{environment};
        }
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
        if (configuration.isImplicitTargetEnvironment()) {
            return null;
        }
        List<TargetEnvironment> environments = configuration.getEnvironments();
        return environments.toArray(new TargetEnvironment[environments.size()]);
    }

    @Override
    public TargetEnvironment getImplicitTargetEnvironment(MavenProject project) {
        return null;
    }

    @Override
    public Filter getTargetEnvironmentFilter(MavenProject project) {
        return null;
    }

    public void readExecutionEnvironmentConfiguration(ReactorProject project, MavenSession mavenSession, ExecutionEnvironmentConfiguration sink) {
        AbstractTychoProject.readExecutionEnvironmentConfiguration(this.projectManager.getTargetPlatformConfiguration(project), sink);
    }

    public static void readExecutionEnvironmentConfiguration(TargetPlatformConfiguration targetPlatformConfiguration, ExecutionEnvironmentConfiguration executionEnvironmentConfiguration) {
        String configuredForcedProfile = targetPlatformConfiguration.getExecutionEnvironment();
        if (configuredForcedProfile != null) {
            executionEnvironmentConfiguration.overrideProfileConfiguration(configuredForcedProfile, "target-platform-configuration <executionEnvironment>");
        } else {
            targetPlatformConfiguration.getTargets().stream().map(TargetDefinition::getTargetEE).filter(Objects::nonNull).findFirst().ifPresent(profile -> executionEnvironmentConfiguration.overrideProfileConfiguration(profile, "first targetJRE from referenced target-definition files"));
        }
        String configuredDefaultProfile = targetPlatformConfiguration.getExecutionEnvironmentDefault();
        if (configuredDefaultProfile != null) {
            executionEnvironmentConfiguration.setProfileConfiguration(configuredDefaultProfile, "target-platform-configuration <executionEnvironmentDefault>");
        }
    }

    @Override
    public Collection<Artifact> getInitialArtifacts(ReactorProject reactorProject, Collection<String> scopes) {
        Object contextValue = reactorProject.getContextValue(CTX_INITIAL_MAVEN_DEPENDENCIES);
        if (contextValue instanceof Collection) {
            Collection dependencies = (Collection)contextValue;
            if (dependencies.isEmpty()) {
                return Collections.emptyList();
            }
            Map<String, ReactorProject> reactorProjectMap = this.getReactorProjectMap(reactorProject);
            Stream<Artifact> projectArtifacts = this.streamProjectArtifacts(reactorProject, dependencies, scopes).map(artifact -> {
                MavenProject mavenProject;
                String key = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion());
                ReactorProject artifactReactorProject = (ReactorProject)reactorProjectMap.get(key);
                if (artifactReactorProject != null && (mavenProject = (MavenProject)artifactReactorProject.adapt(MavenProject.class)) != null) {
                    return mavenProject.getArtifact();
                }
                return artifact;
            });
            return projectArtifacts.toList();
        }
        return Collections.emptyList();
    }

    private Stream<Artifact> streamProjectArtifacts(ReactorProject project, Collection<Dependency> dependencies, Collection<String> scopes) {
        MavenProject mavenProject = AbstractTychoProject.getMavenProject(project);
        MavenSession mavenSession = this.getMavenSession(project);
        try {
            return this.projectDependenciesResolver.resolve(mavenProject, dependencies, scopes, mavenSession).stream();
        }
        catch (DependencyCollectionException e) {
            return Stream.empty();
        }
        catch (DependencyResolutionException e) {
            return Stream.empty();
        }
    }

    @Override
    public Map<Artifact, IArtifactFacade> getArtifactFacades(ReactorProject reactorProject, Collection<Artifact> artifacts) {
        Map<String, ReactorProject> reactorProjectMap = this.getReactorProjectMap(reactorProject);
        HashMap<Artifact, IArtifactFacade> resultMap = new HashMap<Artifact, IArtifactFacade>();
        for (Artifact artifact : artifacts) {
            String key = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion());
            if (reactorProjectMap.containsKey(key)) {
                PomReactorProjectFacade reactorFacade = new PomReactorProjectFacade(artifact, reactorProjectMap.get(key));
                resultMap.put(artifact, reactorFacade);
                continue;
            }
            MavenArtifactFacade externalFacade = new MavenArtifactFacade(artifact);
            resultMap.put(artifact, externalFacade);
        }
        return resultMap;
    }

    private Map<String, ReactorProject> getReactorProjectMap(ReactorProject reactorProject) {
        MavenSession session = this.getMavenSession(reactorProject);
        List<ReactorProject> reactorProjects = DefaultReactorProject.adapt(session);
        HashMap<String, ReactorProject> reactorProjectMap = new HashMap<String, ReactorProject>();
        for (ReactorProject p : reactorProjects) {
            reactorProjectMap.put(ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion()), p);
        }
        return reactorProjectMap;
    }

    protected static String getKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getType() + ":" + Objects.requireNonNullElse(dependency.getClassifier(), "");
    }

    protected static String getKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getType() + ":" + Objects.requireNonNullElse(artifact.getClassifier(), "");
    }

    protected MavenSession getMavenSession(ReactorProject reactorProject) {
        MavenSession mavenSession = (MavenSession)reactorProject.getContextValue(CTX_MAVEN_SESSION);
        if (mavenSession == null) {
            return Objects.requireNonNull(this.legacySupport.getSession(), "Project not setup correctly, neither context nor adaption works here!");
        }
        return mavenSession;
    }

    protected static MavenProject getMavenProject(ReactorProject reactorProject) {
        MavenProject contextValue = (MavenProject)reactorProject.getContextValue(CTX_MAVEN_PROJECT);
        if (contextValue == null) {
            MavenProject adapt = (MavenProject)reactorProject.adapt(MavenProject.class);
            return Objects.requireNonNull(adapt, "Project not setup correctly, neither context nor adaption works here!");
        }
        return contextValue;
    }
}

