/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.MavenArtifactKey;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.model.classpath.ClasspathParser;
import org.eclipse.tycho.model.classpath.JUnitBundle;
import org.eclipse.tycho.model.classpath.ProjectClasspathEntry;
import org.eclipse.tycho.model.project.EclipseProject;

@Component(role=ClasspathReader.class)
public class ClasspathReader
implements Disposable {
    private Map<String, Collection<ProjectClasspathEntry>> cache = new ConcurrentHashMap<String, Collection<ProjectClasspathEntry>>();
    @Requirement
    Logger logger;
    @Requirement
    TychoProjectManager projectManager;

    public void dispose() {
        this.cache.clear();
    }

    public Collection<ProjectClasspathEntry> parse(File basedir) throws IOException {
        Optional<EclipseProject> eclipseProject = this.projectManager.getEclipseProject(basedir);
        Path resolvedClasspath = eclipseProject.map(project -> project.getFile(".classpath")).orElse(basedir.toPath().resolve(".classpath"));
        return this.cache.computeIfAbsent(resolvedClasspath.normalize().toString(), f -> {
            File resolvedClasspathFile = resolvedClasspath.toFile();
            try {
                if (eclipseProject.isPresent()) {
                    return ClasspathParser.parse((File)resolvedClasspathFile, (EclipseProject)((EclipseProject)eclipseProject.get()));
                }
                return ClasspathParser.parse((File)resolvedClasspathFile);
            }
            catch (IOException e) {
                this.logger.warn("Can't read classpath from " + basedir);
                return Collections.emptyList();
            }
        });
    }

    public static Collection<MavenArtifactKey> asMaven(Collection<JUnitBundle> artifacts) {
        return artifacts.stream().map(junit -> ClasspathReader.toMaven(junit)).toList();
    }

    public static MavenArtifactKey toMaven(JUnitBundle junit) {
        return MavenArtifactKey.of((String)"p2-installable-unit", (String)junit.getBundleName(), (String)junit.getVersionRange(), (String)junit.getMavenGroupId(), (String)junit.getMavenArtifactId());
    }
}

