/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;

public class DefaultArtifactDescriptor
implements ArtifactDescriptor {
    private final ArtifactKey key;
    private Function<ArtifactDescriptor, File> locationSupplier;
    private File location;
    private ReactorProject project;
    private final String classifier;
    private final Collection<IInstallableUnit> installableUnits;

    public DefaultArtifactDescriptor(ArtifactKey key, File location, ReactorProject project, String classifier, Collection<IInstallableUnit> installableUnits) {
        this.key = key;
        this.location = ArtifactCollection.normalizeLocation(location);
        this.project = project;
        this.classifier = classifier;
        this.installableUnits = installableUnits;
    }

    public DefaultArtifactDescriptor(ArtifactKey key, Function<ArtifactDescriptor, File> location, ReactorProject project, String classifier, Collection<IInstallableUnit> installableUnits) {
        this.key = key;
        this.locationSupplier = location;
        this.project = project;
        this.classifier = classifier;
        this.installableUnits = installableUnits;
    }

    public ArtifactKey getKey() {
        return this.key;
    }

    public File getLocation(boolean fetch) {
        File file;
        File projectLocation = this.getProjectLocation();
        if (projectLocation != null) {
            return projectLocation;
        }
        if (fetch && this.locationSupplier != null && (this.location == null || !this.location.exists()) && (file = this.locationSupplier.apply(this)) != null) {
            this.location = ArtifactCollection.normalizeLocation(file);
        }
        return this.location;
    }

    private File getProjectLocation() {
        if (this.project != null) {
            File packedArtifact = this.project.getArtifact();
            if (packedArtifact != null && packedArtifact.isFile()) {
                return packedArtifact;
            }
            File basedir = this.project.getBasedir();
            if (basedir != null) {
                return basedir;
            }
        }
        return null;
    }

    public CompletableFuture<File> fetchArtifact() {
        File file;
        File projectLocation = this.getProjectLocation();
        if (projectLocation != null) {
            return CompletableFuture.completedFuture(projectLocation);
        }
        if (this.location != null && this.location.exists()) {
            return CompletableFuture.completedFuture(this.location);
        }
        if (this.locationSupplier != null && (file = this.locationSupplier.apply(this)) != null) {
            File normalized;
            this.location = normalized = ArtifactCollection.normalizeLocation(file);
            if (normalized.exists()) {
                return CompletableFuture.completedFuture(normalized);
            }
        }
        return CompletableFuture.failedFuture(new FileNotFoundException("Can't fetch file for artifact " + this.getKey()));
    }

    public Optional<File> getLocation() {
        File projectLocation = this.getProjectLocation();
        if (projectLocation != null) {
            return Optional.of(projectLocation);
        }
        if (this.location != null) {
            return Optional.of(this.location);
        }
        return Optional.empty();
    }

    public ReactorProject getMavenProject() {
        return this.project;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Collection<IInstallableUnit> getInstallableUnits() {
        return this.installableUnits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.toString()).append(": ");
        if (this.project != null) {
            sb.append(this.project.toString());
        } else {
            sb.append(this.location);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.key, this.locationSupplier, this.locationSupplier == null ? this.location : null, this.classifier, this.project, this.installableUnits);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != DefaultArtifactDescriptor.class) {
            return false;
        }
        DefaultArtifactDescriptor other = (DefaultArtifactDescriptor)obj;
        return Objects.equals(this.key, other.key) && (Objects.equals(this.location, other.location) || Objects.equals(this.locationSupplier, other.locationSupplier)) && Objects.equals(this.project, other.project) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.installableUnits, other.installableUnits);
    }

    public void resolve(File newLocation) {
        this.location = newLocation;
    }

    public void setMavenProject(ReactorProject mavenProject) {
        this.project = mavenProject;
    }
}

