/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.InvalidOSGiManifestException;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;

@Component(role=BundleReader.class)
public class DefaultBundleReader
extends AbstractLogEnabled
implements BundleReader {
    private static final long LOCK_TIMEOUT = Long.getLong("tycho.bundlereader.lock.timeout", 300000L);
    public static final String CACHE_PATH = ".cache/tycho";
    private final Map<String, OsgiManifest> manifestCache = new HashMap<String, OsgiManifest>();
    private File cacheDir;
    private ConcurrentMap<String, Optional<File>> extractedFiles = new ConcurrentHashMap<String, Optional<File>>();
    @Requirement
    private FileLockService fileLockService;

    @Override
    public OsgiManifest loadManifest(File bundleLocation) {
        String locationPath = bundleLocation.getAbsolutePath();
        OsgiManifest manifest = this.manifestCache.get(locationPath);
        if (manifest == null) {
            manifest = this.doLoadManifest(bundleLocation);
            this.manifestCache.put(locationPath, manifest);
        }
        return manifest;
    }

    @Override
    public OsgiManifest loadManifest(MavenProject mavenProject) throws OsgiManifestParserException, InvalidOSGiManifestException {
        String locationPath = mavenProject.getBasedir().getAbsolutePath();
        try {
            OsgiManifest manifest = this.manifestCache.get(locationPath);
            if (manifest == null) {
                File manifestFile = this.getManifestLocation(mavenProject);
                if (!manifestFile.isFile()) {
                    throw new OsgiManifestParserException(manifestFile.getAbsolutePath(), "Manifest file not found");
                }
                manifest = this.loadManifestFile(manifestFile);
                this.manifestCache.put(locationPath, manifest);
            }
            return manifest;
        }
        catch (IOException e) {
            throw new OsgiManifestParserException(locationPath, e);
        }
    }

    private OsgiManifest doLoadManifest(File bundleLocation) {
        try {
            if (bundleLocation.isDirectory()) {
                return this.loadManifestFromDirectory(bundleLocation);
            }
            if (bundleLocation.isFile()) {
                return this.loadManifestFromFile(bundleLocation);
            }
            throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), "Manifest file not found");
        }
        catch (IOException e) {
            throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), e);
        }
    }

    private OsgiManifest loadManifestFromFile(File bundleLocation) throws IOException {
        if (!bundleLocation.getName().toLowerCase().endsWith(".jar")) {
            return this.loadManifestFile(bundleLocation);
        }
        try (ZipFile jar = new ZipFile(bundleLocation, 1);){
            ZipEntry manifestEntry = jar.getEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null) {
                InputStream stream = jar.getInputStream(manifestEntry);
                OsgiManifest osgiManifest = OsgiManifest.parse(stream, bundleLocation.getAbsolutePath() + "!/META-INF/MANIFEST.MF");
                return osgiManifest;
            }
        }
        throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), "Manifest file not found in JAR archive");
    }

    private OsgiManifest loadManifestFromDirectory(File directory) throws IOException {
        File manifestFile = new File(directory, "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile()) {
            throw new OsgiManifestParserException(manifestFile.getAbsolutePath(), "Manifest file not found");
        }
        return this.loadManifestFile(manifestFile);
    }

    @Override
    public File getManifestLocation(MavenProject mavenProject) throws IOException {
        File defaultLocation;
        File basedir = mavenProject.getBasedir();
        File pdePreferences = new File(basedir, ".settings/org.eclipse.pde.core.prefs");
        if (pdePreferences.isFile()) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(pdePreferences));
            String property = properties.getProperty("BUNDLE_ROOT_PATH");
            if (property != null) {
                return new File(new File(basedir, property), "META-INF/MANIFEST.MF");
            }
        }
        if ((defaultLocation = new File(basedir, "META-INF/MANIFEST.MF")).isFile()) {
            return defaultLocation;
        }
        for (Resource resource : mavenProject.getBuild().getResources()) {
            String directory = resource.getDirectory();
            File file = new File(new File(directory), "META-INF/MANIFEST.MF");
            if (!file.isFile()) continue;
            return file;
        }
        File file = new File(new File(mavenProject.getBuild().getOutputDirectory()), "META-INF/MANIFEST.MF");
        if (file.isFile()) {
            return file;
        }
        File bndFile = new File(basedir, "pde.bnd");
        if (bndFile.isFile()) {
            return bndFile;
        }
        return defaultLocation;
    }

    private OsgiManifest loadManifestFile(File manifestFile) throws IOException, OsgiManifestParserException {
        return OsgiManifest.parse(new FileInputStream(manifestFile), manifestFile.getAbsolutePath());
    }

    public void setLocationRepository(File basedir) {
        this.cacheDir = new File(basedir, CACHE_PATH);
    }

    @Override
    public File getEntry(File bundleLocation, String path) {
        Optional<Object> result;
        if (path.startsWith("external:")) {
            this.getLogger().warn("Ignoring Bundle-ClassPath entry '" + path + "' of bundle " + bundleLocation);
            return null;
        }
        if (bundleLocation.isDirectory()) {
            File file = new File(bundleLocation, path);
            result = file.exists() ? Optional.of(file) : Optional.empty();
        } else {
            String cacheKey;
            File outputDirectory = new File(this.cacheDir, bundleLocation.getName());
            File cacheFile = new File(outputDirectory, path);
            try {
                cacheKey = cacheFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException("can't get canonical path for " + cacheFile, e);
            }
            result = this.extractedFiles.computeIfAbsent(cacheKey, nil -> {
                try (Closeable locked = this.fileLockService.lock(outputDirectory, LOCK_TIMEOUT);){
                    this.extractZipEntries(bundleLocation, path, outputDirectory);
                    if (cacheFile.exists()) {
                        Optional<File> optional2 = Optional.of(cacheFile);
                        return optional2;
                    }
                    Optional optional = Optional.empty();
                    return optional;
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't extract '" + path + "' from " + bundleLocation + " to " + outputDirectory, e);
                }
            });
        }
        if (result.isPresent()) {
            return (File)result.get();
        }
        this.getLogger().warn("Bundle-ClassPath entry " + path + " does not exist in " + bundleLocation);
        return null;
    }

    private void extractZipEntries(File bundleLocation, String path, File outputDirectory) throws IOException {
        try (ZipFile zip = new ZipFile(bundleLocation);){
            InputStream singleEntryStream;
            ZipEntry singleEntry = zip.getEntry(path);
            if (singleEntry != null && !singleEntry.isDirectory() && (singleEntryStream = zip.getInputStream(singleEntry)) != null) {
                File outputFile = new File(outputDirectory, singleEntry.getName());
                DefaultBundleReader.copyStreamToFile(singleEntryStream, outputFile, singleEntry.getTime());
            } else {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(path)) continue;
                    File outputFile = new File(outputDirectory, zipEntry.getName());
                    DefaultBundleReader.copyStreamToFile(zip.getInputStream(zipEntry), outputFile, zipEntry.getTime());
                }
            }
        }
    }

    private static void copyStreamToFile(InputStream in, File outputFile, long timestamp) throws IOException {
        if (in == null) {
            return;
        }
        outputFile.getParentFile().mkdirs();
        try (InputStream inputStream = in;){
            Files.copy(in, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (timestamp > 0L) {
            outputFile.setLastModified(timestamp);
        }
    }
}

