/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.osgi.adapters.MavenReactorProjectIdentities;

public class DefaultReactorProject
implements ReactorProject {
    private static final String CTX_REACTOR_PROJECT = "tycho.reactor-project." + System.identityHashCode(ReactorProject.class);
    private static final String CTX_MAVEN_SESSION = "tycho.reactor-project." + System.identityHashCode(MavenSession.class);
    private static final String CTX_DEPENDENCY_METADATA_PREFIX = "tycho.dependency-metadata-";
    final MavenProject project;
    private final Map<String, Object> context = new ConcurrentHashMap<String, Object>();
    private File basedir;

    public DefaultReactorProject(MavenProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
        ReactorProject reactorProject = DefaultReactorProject.getCachedValue(project);
        this.basedir = reactorProject != null ? reactorProject.getBasedir() : project.getBasedir();
    }

    public static ReactorProject adapt(MavenProject project, MavenSession mavenSession) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        if (mavenSession != null) {
            reactorProject.setContextValue(CTX_MAVEN_SESSION, (Object)mavenSession);
        }
        return reactorProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReactorProject adapt(MavenProject project) {
        if (project == null) {
            return null;
        }
        MavenProject mavenProject = project;
        synchronized (mavenProject) {
            ReactorProject reactorProject = DefaultReactorProject.getCachedValue(project);
            if (reactorProject == null) {
                reactorProject = new DefaultReactorProject(project);
                project.setContextValue(CTX_REACTOR_PROJECT, (Object)reactorProject);
            }
            return reactorProject;
        }
    }

    protected static ReactorProject getCachedValue(MavenProject project) {
        ReactorProject reactorProject;
        Object object = project.getContextValue(CTX_REACTOR_PROJECT);
        return object instanceof ReactorProject ? (reactorProject = (ReactorProject)object) : null;
    }

    public static List<ReactorProject> adapt(MavenSession session) {
        if (session == null) {
            return List.of();
        }
        ArrayList<ReactorProject> result = new ArrayList<ReactorProject>();
        for (MavenProject project : session.getProjects()) {
            ReactorProject reactorProject = DefaultReactorProject.adapt(project, session);
            reactorProject.computeContextValue(CTX_MAVEN_SESSION, () -> session);
            result.add(reactorProject);
        }
        return result;
    }

    public boolean sameProject(Object otherProject) {
        return this.project.equals(otherProject);
    }

    public File getBasedir() {
        if (this.basedir != null) {
            return this.basedir;
        }
        return this.project.getBasedir();
    }

    public String getPackaging() {
        return this.project.getPackaging();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getVersion() {
        return this.project.getVersion();
    }

    public ReactorProjectIdentities getIdentities() {
        return new MavenReactorProjectIdentities(this.project);
    }

    public BuildOutputDirectory getBuildDirectory() {
        return new BuildOutputDirectory(new File(this.project.getBuild().getDirectory()), new File(this.project.getBuild().getOutputDirectory()), new File(this.project.getBuild().getTestOutputDirectory()));
    }

    public File getArtifact() {
        Artifact artifact = this.project.getArtifact();
        return artifact != null ? artifact.getFile() : null;
    }

    public File getArtifact(String artifactClassifier) {
        Artifact artifact = null;
        if (artifactClassifier == null) {
            artifact = this.project.getArtifact();
        } else {
            for (Artifact attached : this.project.getAttachedArtifacts()) {
                if (!artifactClassifier.equals(attached.getClassifier())) continue;
                artifact = attached;
                break;
            }
        }
        return artifact != null ? artifact.getFile() : null;
    }

    public Object getContextValue(String key) {
        Object value = this.context.get(key);
        if (value instanceof LazyValue) {
            LazyValue lazy = (LazyValue)value;
            return lazy.get();
        }
        return value != null ? value : this.project.getContextValue(key);
    }

    public <T> T computeContextValue(String key, Supplier<T> initalValueSupplier) {
        Object value = this.context.computeIfAbsent(key, nil -> new LazyValue(initalValueSupplier));
        if (value instanceof LazyValue) {
            LazyValue lazy = (LazyValue)value;
            return lazy.get();
        }
        return (T)value;
    }

    public void setContextValue(String key, Object value) {
        Objects.requireNonNull(key, "key can't be null");
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
    }

    public void setDependencyMetadata(IDependencyMetadata.DependencyMetadataType type, Collection<IInstallableUnit> units) {
        this.setContextValue(DefaultReactorProject.getDependencyMetadataKey(type), units);
    }

    public Set<IInstallableUnit> getDependencyMetadata() {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>(this.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED));
        result.addAll(this.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE));
        return result;
    }

    public Set<IInstallableUnit> getDependencyMetadata(IDependencyMetadata.DependencyMetadataType type) {
        Set contextValue = (Set)this.getContextValue(DefaultReactorProject.getDependencyMetadataKey(type));
        return Objects.requireNonNullElse(contextValue, Collections.emptySet());
    }

    private static String getDependencyMetadataKey(IDependencyMetadata.DependencyMetadataType type) {
        return CTX_DEPENDENCY_METADATA_PREFIX + type.name().toLowerCase();
    }

    public String getBuildQualifier() {
        String version = (String)this.project.getProperties().get("buildQualifier");
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have a build qualifier");
    }

    public String getExpandedVersion() {
        String version = (String)this.project.getProperties().get("qualifiedVersion");
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have an expanded version");
    }

    public String getId() {
        return this.project.getId();
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DefaultReactorProject)) return false;
        DefaultReactorProject other = (DefaultReactorProject)obj;
        if (!this.project.equals((Object)other.project)) return false;
        return true;
    }

    public String toString() {
        return this.project.toString();
    }

    public String getName() {
        return this.project.getName();
    }

    public <T> T adapt(Class<T> target) {
        if (target == MavenSession.class) {
            return target.cast(this.getContextValue(CTX_MAVEN_SESSION));
        }
        if (target == MavenProject.class) {
            return target.cast(this.project);
        }
        return null;
    }

    private static final class LazyValue<T>
    implements Supplier<T> {
        private Supplier<T> initalValueSupplier;
        private T value;

        LazyValue(Supplier<T> initalValueSupplier) {
            this.initalValueSupplier = initalValueSupplier;
        }

        @Override
        public synchronized T get() {
            if (this.value == null) {
                this.value = this.initalValueSupplier.get();
            }
            return this.value;
        }
    }
}

