/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultArtifactDescriptor;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;

public class DefaultDependencyArtifacts
extends ArtifactCollection
implements DependencyArtifacts {
    private static final Map<ArtifactKey, ArtifactKey> KEY_CACHE = new ConcurrentHashMap<ArtifactKey, ArtifactKey>();
    private static final Map<ArtifactDescriptor, ArtifactDescriptor> ARTIFACT_CACHE = new ConcurrentHashMap<ArtifactDescriptor, ArtifactDescriptor>();
    protected final List<ArtifactDescriptor> fragments = new ArrayList<ArtifactDescriptor>();
    protected final ReactorProject project;
    protected final Set<IInstallableUnit> nonReactorUnits = new LinkedHashSet<IInstallableUnit>();

    public DefaultDependencyArtifacts() {
        this(null);
    }

    public DefaultDependencyArtifacts(ReactorProject project) {
        this.project = project;
    }

    @Override
    protected ArtifactDescriptor normalize(ArtifactDescriptor artifact) {
        ArtifactDescriptor cachedArtifact = ARTIFACT_CACHE.putIfAbsent(artifact, artifact);
        return cachedArtifact != null ? cachedArtifact : artifact;
    }

    @Override
    protected ArtifactKey normalize(ArtifactKey key) {
        ArtifactKey cachedKey = KEY_CACHE.putIfAbsent(key, key);
        return cachedKey != null ? cachedKey : key;
    }

    public Set<IInstallableUnit> getNonReactorUnits() {
        return this.nonReactorUnits;
    }

    public Set<IInstallableUnit> getInstallableUnits() {
        LinkedHashSet<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
        for (ArtifactDescriptor artifact : this.artifacts.values()) {
            if (this.project != null && this.project.equals(artifact.getMavenProject())) continue;
            units.addAll(artifact.getInstallableUnits());
        }
        units.addAll(this.nonReactorUnits);
        return Collections.unmodifiableSet(units);
    }

    public void addNonReactorUnits(Set<IInstallableUnit> installableUnits) {
        this.nonReactorUnits.addAll(installableUnits);
    }

    public void addFragment(ArtifactKey key, Supplier<File> location, Set<IInstallableUnit> installableUnits) {
        this.fragments.add(new DefaultArtifactDescriptor(key, whatever -> (File)location.get(), null, null, installableUnits));
    }

    public Collection<ArtifactDescriptor> getFragments() {
        return Collections.unmodifiableCollection(this.fragments);
    }
}

