/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;

public class DefaultP2ResolutionResultEntry
implements P2ResolutionResult.Entry {
    private String type;
    private String id;
    private String version;
    private Set<IInstallableUnit> installableUnits;
    private String classifier;
    private final Supplier<File> location;
    private File resolvedFile;

    public DefaultP2ResolutionResultEntry(String type, String id, String version, String classifier, Supplier<File> delayedLocation) {
        this.type = type;
        this.id = id;
        this.version = version;
        this.location = delayedLocation;
        this.classifier = classifier;
    }

    public DefaultP2ResolutionResultEntry(String type, String id, String version, String classifier, File resolvedLocation) {
        this.type = type;
        this.id = id;
        this.version = version;
        this.location = null;
        this.resolvedFile = resolvedLocation;
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public File getLocation(boolean fetch) {
        if (this.resolvedFile == null && fetch) {
            this.resolvedFile = this.location.get();
        }
        return this.resolvedFile;
    }

    @Override
    public Set<IInstallableUnit> getInstallableUnits() {
        return this.installableUnits;
    }

    void addInstallableUnit(IInstallableUnit installableUnit) {
        if (this.installableUnits == null) {
            this.installableUnits = new LinkedHashSet<IInstallableUnit>();
        }
        this.installableUnits.add(installableUnit);
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "DefaultP2ResolutionResultEntry [type=" + this.type + ", id=" + this.id + ", version=" + this.version + ", installableUnits=" + this.installableUnits + ", classifier=" + this.classifier + ", location=" + this.location + ", resolvedFile=" + this.resolvedFile + "]";
    }
}

