/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TargetPlatformService;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.core.resolver.target.SupplierMetadataRepository;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.PublishingRepository;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManager;
import org.eclipse.tycho.targetplatform.P2TargetPlatform;

@Component(role=TargetPlatformService.class)
public class DefaultTargetPlatformService
implements TargetPlatformService {
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement(hint="p2")
    private DependencyResolver dependencyResolver;
    @Requirement
    private ReactorRepositoryManager repositoryManager;
    @Requirement
    private P2ResolverFactory p2ResolverFactory;
    @Requirement
    private TargetPlatformFactory tpFactory;
    @Requirement
    private IProvisioningAgent agent;

    public Optional<TargetPlatform> getTargetPlatform() throws DependencyResolutionException {
        MavenSession session = this.legacySupport.getSession();
        if (session == null) {
            return Optional.empty();
        }
        MavenProject mavenProject = session.getCurrentProject();
        if (mavenProject == null) {
            return Optional.empty();
        }
        return this.getTargetPlatform(DefaultReactorProject.adapt(mavenProject));
    }

    public Optional<TargetPlatform> getTargetPlatform(ReactorProject project) throws DependencyResolutionException {
        Object contextValue = project.getContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform");
        if (contextValue instanceof TargetPlatform) {
            return Optional.of((TargetPlatform)contextValue);
        }
        if (this.repositoryManager == null || project.adapt(MavenSession.class) == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.computeFinalTargetPlatform(project));
    }

    private TargetPlatform computeFinalTargetPlatform(ReactorProject project) {
        return (TargetPlatform)project.computeContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform", () -> {
            MavenProject mavenProject = (MavenProject)project.adapt(MavenProject.class);
            MavenSession mavenSession = (MavenSession)project.adapt(MavenSession.class);
            final TargetPlatform preliminaryTargetPlatform = this.dependencyResolver.getPreliminaryTargetPlatform(mavenSession, mavenProject);
            if ("eclipse-target-definition".equals(mavenProject.getPackaging())) {
                SupplierMetadataRepository metadataRepository;
                if (preliminaryTargetPlatform instanceof P2TargetPlatform) {
                    P2TargetPlatform p2 = (P2TargetPlatform)preliminaryTargetPlatform;
                    metadataRepository = new SupplierMetadataRepository(this.agent, () -> p2.getInstallableUnits().iterator());
                } else {
                    metadataRepository = new SupplierMetadataRepository(this.agent, () -> Collections.emptyIterator());
                }
                return new TargetPlatform(){
                    final /* synthetic */ IMetadataRepository val$metadataRepository;
                    {
                        this.val$metadataRepository = iMetadataRepository;
                    }

                    public ArtifactKey resolveArtifact(String type, String id, String versionRef) throws IllegalArtifactReferenceException, DependencyResolutionException {
                        return preliminaryTargetPlatform.resolveArtifact(type, id, versionRef);
                    }

                    public boolean isFileAlreadyAvailable(ArtifactKey artifactKey) {
                        return preliminaryTargetPlatform.isFileAlreadyAvailable(artifactKey);
                    }

                    public IMetadataRepository getMetadataRepository() {
                        return this.val$metadataRepository;
                    }

                    public IArtifactRepository getArtifactRepository() {
                        return preliminaryTargetPlatform.getArtifactRepository();
                    }

                    public File getArtifactLocation(ArtifactKey artifact) {
                        return preliminaryTargetPlatform.getArtifactLocation(artifact);
                    }
                };
            }
            List<ReactorProjectIdentities> upstreamProjects = this.getReferencedTychoProjects(project);
            PomDependencyCollector pomDependenciesCollector = this.dependencyResolver.resolvePomDependencies(mavenSession, (MavenProject)project.adapt(MavenProject.class));
            List<PublishingRepository> upstreamProjectResults = this.getBuildResults(upstreamProjects);
            return this.tpFactory.createTargetPlatformWithUpdatedReactorContent(preliminaryTargetPlatform, upstreamProjectResults, pomDependenciesCollector);
        });
    }

    private List<PublishingRepository> getBuildResults(List<? extends ReactorProjectIdentities> projects) {
        ArrayList<PublishingRepository> results = new ArrayList<PublishingRepository>(projects.size());
        for (ReactorProjectIdentities reactorProjectIdentities : projects) {
            results.add(this.repositoryManager.getPublishingRepository(reactorProjectIdentities));
        }
        return results;
    }

    private List<ReactorProjectIdentities> getReferencedTychoProjects(ReactorProject reactorProject) throws DependencyResolutionException {
        ArrayList<ReactorProjectIdentities> result = new ArrayList<ReactorProjectIdentities>();
        MavenProject mavenProject = (MavenProject)reactorProject.adapt(MavenProject.class);
        if (mavenProject != null) {
            HashSet<GAV> considered = new HashSet<GAV>();
            Collection<MavenProject> values = mavenProject.getProjectReferences().values();
            this.getTransitivelyReferencedTychoProjects(values, considered, result);
        }
        return result;
    }

    private void getTransitivelyReferencedTychoProjects(Collection<MavenProject> candidateProjects, HashSet<GAV> consideredProjects, List<ReactorProjectIdentities> result) throws DependencyResolutionException {
        for (MavenProject reactorProject : candidateProjects) {
            File metadataXml;
            if (!this.enterProject(reactorProject, consideredProjects) || (metadataXml = DefaultTargetPlatformService.getAttachedArtifact(reactorProject, "p2metadata")) == null) continue;
            File artifactXml = DefaultTargetPlatformService.getAttachedArtifact(reactorProject, "p2artifacts");
            this.logger.debug("Adding reactor project: " + reactorProject);
            ReactorProject tychoReactorProject = DefaultReactorProject.adapt(reactorProject);
            DefaultTargetPlatformService.verifyIndexFileLocations(tychoReactorProject, metadataXml, artifactXml);
            result.add(tychoReactorProject.getIdentities());
            Collection<MavenProject> values = reactorProject.getProjectReferences().values();
            this.getTransitivelyReferencedTychoProjects(values, consideredProjects, result);
        }
    }

    private boolean enterProject(MavenProject project, HashSet<GAV> consideredProjects) {
        GAV projectGav = new GAV(project.getGroupId(), project.getArtifactId(), project.getVersion());
        if (consideredProjects.contains(projectGav)) {
            return false;
        }
        consideredProjects.add(projectGav);
        return true;
    }

    private static File getAttachedArtifact(MavenProject project, String classifier) {
        for (Artifact artifact : project.getAttachedArtifacts()) {
            if (!classifier.equals(artifact.getClassifier())) continue;
            return artifact.getFile();
        }
        return null;
    }

    private static void verifyIndexFileLocations(ReactorProject project, File metadataXml, File artifactXml) throws DependencyResolutionException {
        DefaultTargetPlatformService.verifyArtifactLocationInTargetFolder(project, "p2metadata", "p2content.xml", metadataXml);
        DefaultTargetPlatformService.verifyArtifactLocationInTargetFolder(project, "p2artifacts", "p2artifacts.xml", artifactXml);
        DefaultTargetPlatformService.verifyFilePresenceInTargetFolder(project, "local-artifacts.properties");
    }

    private static void verifyArtifactLocationInTargetFolder(ReactorProject project, String artifactClassifier, String expectedPathInTarget, File actualLocation) throws DependencyResolutionException {
        File expectedLocation = project.getBuildDirectory().getChild(expectedPathInTarget);
        if (actualLocation == null) {
            throw new DependencyResolutionException("Unexpected build result of " + project + ": Artifact with classifier '" + artifactClassifier + "' expected at location \"" + expectedLocation + "\", but is missing");
        }
        if (!expectedLocation.equals(actualLocation.getAbsoluteFile())) {
            throw new DependencyResolutionException("Unexpected build result of " + project + ": Artifact with classifier '" + artifactClassifier + "' expected at location \"" + expectedLocation + "\", but is at \"" + actualLocation.getAbsolutePath() + "\"");
        }
    }

    private static void verifyFilePresenceInTargetFolder(ReactorProject project, String expectedPathInTarget) throws DependencyResolutionException {
        File expectedLocation = project.getBuildDirectory().getChild(expectedPathInTarget);
        if (!expectedLocation.isFile()) {
            throw new DependencyResolutionException("Unexpected build result of " + project + ": File \"" + expectedLocation + "\" is missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTargetPlatform(ReactorProject project) {
        ReactorProject reactorProject = project;
        synchronized (reactorProject) {
            project.setContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform", null);
        }
    }
}

