/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.m2e.pde.target.shared.MavenBundleWrapper;
import org.eclipse.m2e.pde.target.shared.ProcessingMessage;
import org.eclipse.m2e.pde.target.shared.WrappedBundle;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.core.DependencyResolutionException;
import org.eclipse.tycho.core.MavenDependenciesResolver;
import org.eclipse.tycho.core.MavenModelFacade;
import org.eclipse.tycho.core.publisher.TychoMavenPropertiesAdvice;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.core.resolver.target.SupplierMetadataRepository;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.osgi.configuration.MavenDependenciesResolverConfigurer;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.resolver.BundlePublisher;
import org.eclipse.tycho.p2.resolver.FeatureGenerator;
import org.eclipse.tycho.p2.resolver.FeaturePublisher;
import org.eclipse.tycho.p2.resolver.WrappedArtifact;
import org.eclipse.tycho.p2maven.advices.MavenChecksumAdvice;
import org.eclipse.tycho.p2maven.advices.MavenPropertiesAdvice;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;
import org.osgi.framework.BundleException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenTargetDefinitionContent
implements TargetDefinitionContent {
    private static final String POM_PACKAGING_TYPE = "pom";
    public static final String ECLIPSE_SOURCE_BUNDLE_HEADER = "Eclipse-SourceBundle";
    private final Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private SupplierMetadataRepository metadataRepository;
    private FileArtifactRepository artifactRepository;
    private MavenContext mavenContext;

    public MavenTargetDefinitionContent(TargetDefinition.MavenGAVLocation location, MavenDependenciesResolver mavenDependenciesResolver, IncludeSourceMode sourceMode, IProvisioningAgent agent, MavenContext mavenContext, SyncContextFactory syncContextFactory, RepositorySystem repositorySystem, MavenSession mavenSession, org.eclipse.aether.RepositorySystem repositorySystem2) {
        this.mavenContext = mavenContext;
        MavenLogger logger = mavenContext.getLogger();
        File repositoryRoot = mavenDependenciesResolver.getRepositoryRoot();
        boolean includeSource = sourceMode == IncludeSourceMode.force || sourceMode == IncludeSourceMode.honor && location.includeSource();
        this.metadataRepository = new SupplierMetadataRepository(agent, () -> this.repositoryContent.values().iterator());
        this.metadataRepository.setLocation(repositoryRoot.toURI());
        this.metadataRepository.setName(repositoryRoot.getName());
        this.artifactRepository = new FileArtifactRepository(agent, () -> this.repositoryContent.keySet().stream().filter(Predicate.not(FeaturePublisher::isMetadataOnly)).iterator());
        this.artifactRepository.setName(repositoryRoot.getName());
        this.artifactRepository.setLocation(repositoryRoot.toURI());
        Collection instructions = location.getInstructions();
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (mavenDependenciesResolver != null) {
            logger.info("Resolving " + location);
            HashMap<String, Properties> instructionsMap = new HashMap<String, Properties>();
            for (TargetDefinition.BNDInstructions instruction : instructions) {
                String reference = instruction.getReference();
                Properties properties = instruction.getInstructions();
                instructionsMap.put(reference, properties);
                logger.info((String)(reference.isEmpty() ? "default instructions" : reference) + " = " + properties);
            }
            ArrayList<IInstallableUnit> locationBundles = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> locationSourceBundles = new ArrayList<IInstallableUnit>();
            for (TargetDefinition.MavenDependency mavenDependency : location.getRoots()) {
                Collection<?> resolve;
                TargetDefinition.MavenGAVLocation.DependencyDepth dependencyDepth = location.getIncludeDependencyDepth();
                if (dependencyDepth == TargetDefinition.MavenGAVLocation.DependencyDepth.NONE && POM_PACKAGING_TYPE.equalsIgnoreCase(mavenDependency.getArtifactType())) {
                    dependencyDepth = TargetDefinition.MavenGAVLocation.DependencyDepth.DIRECT;
                }
                int depth = switch (dependencyDepth) {
                    case TargetDefinition.MavenGAVLocation.DependencyDepth.INFINITE -> Integer.MAX_VALUE;
                    case TargetDefinition.MavenGAVLocation.DependencyDepth.DIRECT -> 2;
                    default -> 0;
                };
                try {
                    resolve = mavenDependenciesResolver.resolve(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getVersion(), mavenDependency.getArtifactType(), mavenDependency.getClassifier(), location.getIncludeDependencyScopes(), depth, location.getRepositoryReferences());
                }
                catch (DependencyResolutionException e1) {
                    throw new TargetDefinitionResolutionException("MavenDependency " + mavenDependency + " of location " + location + " could not be resolved", (Throwable)e1);
                }
                Iterator resolvedArtifacts = resolve.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).iterator();
                Properties defaultProperties = WrappedArtifact.createPropertiesForPrefix("wrapped");
                ArrayList<IInstallableUnit> bundles = new ArrayList<IInstallableUnit>();
                ArrayList<IInstallableUnit> sourceBundles = new ArrayList<IInstallableUnit>();
                while (resolvedArtifacts.hasNext()) {
                    String bundleVersion;
                    String symbolicName;
                    IArtifactFacade mavenArtifact = (IArtifactFacade)resolvedArtifacts.next();
                    if (mavenDependency.isIgnored(mavenArtifact)) {
                        logger.debug("Skip ignored " + mavenArtifact);
                        continue;
                    }
                    if (POM_PACKAGING_TYPE.equalsIgnoreCase(mavenArtifact.getPackagingType())) {
                        logger.debug("Skip pom artifact " + mavenArtifact);
                        continue;
                    }
                    String fileName = mavenArtifact.getLocation().getName();
                    if (!"jar".equalsIgnoreCase(FilenameUtils.getExtension((String)fileName))) {
                        logger.info("Skip non-jar artifact (" + fileName + ")");
                        continue;
                    }
                    logger.debug("Resolved " + mavenArtifact);
                    Feature feature = new FeatureParser().parse(mavenArtifact.getLocation());
                    if (feature != null) {
                        feature.setLocation(mavenArtifact.getLocation().getAbsolutePath());
                        features.add(feature);
                        continue;
                    }
                    try {
                        IInstallableUnit unit;
                        File bundleLocation = mavenArtifact.getLocation();
                        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
                        symbolicName = bundleDescription != null ? bundleDescription.getSymbolicName() : null;
                        String string = bundleVersion = bundleDescription != null ? bundleDescription.getVersion().toString() : null;
                        if (symbolicName == null) {
                            if (location.getMissingManifestStrategy() == TargetDefinition.MavenGAVLocation.MissingManifestStrategy.IGNORE) {
                                logger.info("Ignoring " + this.asDebugString(mavenArtifact) + " as it is not a bundle and MissingManifestStrategy is set to ignore for this location");
                                continue;
                            }
                            if (location.getMissingManifestStrategy() == TargetDefinition.MavenGAVLocation.MissingManifestStrategy.ERROR) {
                                throw new TargetDefinitionResolutionException("Artifact " + this.asDebugString(mavenArtifact) + " is not a bundle and MissingManifestStrategy is set to error for this location");
                            }
                            try {
                                List repositories = RepositoryUtils.toRepos(MavenDependenciesResolverConfigurer.getEffectiveRepositories(mavenSession.getCurrentProject(), location.getRepositoryReferences(), repositorySystem));
                                Function<DependencyNode, Properties> instructionsLookup = node -> instructionsMap.getOrDefault(MavenTargetDefinitionContent.getKey(node.getArtifact()), instructionsMap.getOrDefault("", defaultProperties));
                                WrappedBundle wrappedBundle = MavenBundleWrapper.getWrappedArtifact((Artifact)new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getClassifier(), mavenArtifact.getPackagingType(), mavenArtifact.getVersion()), instructionsLookup, repositories, repositorySystem2, mavenSession.getRepositorySession(), syncContextFactory);
                                List<ProcessingMessage> directErrors = wrappedBundle.messages(false).filter(msg -> msg.type() == ProcessingMessage.Type.ERROR).toList();
                                if (!directErrors.isEmpty()) {
                                    throw new RuntimeException(directErrors.stream().map(ProcessingMessage::message).collect(Collectors.joining(System.lineSeparator())));
                                }
                                wrappedBundle.messages(true).map(ProcessingMessage::message).forEach(msg -> logger.warn(this.asDebugString(mavenArtifact) + ": " + msg));
                                File file = wrappedBundle.getFile().get().toFile();
                                BundleDescription description = BundlesAction.createBundleDescription((File)file);
                                WrappedArtifact wrappedArtifact = new WrappedArtifact(file, mavenArtifact, mavenArtifact.getClassifier(), description.getSymbolicName(), description.getVersion().toString(), null);
                                logger.info(this.asDebugString(mavenArtifact) + " is wrapped as a bundle with bundle symbolic name " + wrappedArtifact.getWrappedBsn());
                                logger.info(wrappedArtifact.getReferenceHint());
                                if (logger.isDebugEnabled()) {
                                    logger.debug("The following manifest was generated for this artifact:\r\n" + wrappedArtifact.getGeneratedManifest());
                                }
                                HashMap<String, String> mavenProperties = new HashMap<String, String>();
                                mavenProperties.put("maven-wrapped-groupId", mavenArtifact.getGroupId());
                                mavenProperties.put("maven-wrapped-artifactId", mavenArtifact.getArtifactId());
                                mavenProperties.put("maven-wrapped-version", mavenArtifact.getVersion());
                                mavenProperties.put("maven-wrapped-classifier", mavenArtifact.getClassifier());
                                unit = this.publish(description, file, (IPropertyAdvice)new MavenPropertiesAdvice(mavenProperties));
                                symbolicName = wrappedArtifact.getWrappedBsn();
                                bundleVersion = wrappedArtifact.getWrappedVersion();
                            }
                            catch (Exception e) {
                                throw new TargetDefinitionResolutionException("Artifact " + this.asDebugString(mavenArtifact) + " of location " + location + " could not be wrapped as a bundle", (Throwable)e);
                            }
                        } else {
                            unit = this.publish(bundleDescription, bundleLocation, mavenArtifact);
                        }
                        bundles.add(unit);
                        if (logger.isDebugEnabled()) {
                            logger.debug("MavenResolver: artifact " + this.asDebugString(mavenArtifact) + " at location " + bundleLocation + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
                        }
                    }
                    catch (IOException | BundleException e) {
                        throw new TargetDefinitionResolutionException("Artifact " + this.asDebugString(mavenArtifact) + " of location " + location + " could not be read", e);
                    }
                    if (!includeSource) continue;
                    try {
                        Collection<?> sourceArtifacts = mavenDependenciesResolver.resolve(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), mavenArtifact.getPackagingType(), "sources", null, 0, location.getRepositoryReferences());
                        Iterator sources = sourceArtifacts.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).iterator();
                        while (sources.hasNext()) {
                            IArtifactFacade sourceArtifact = (IArtifactFacade)sources.next();
                            File sourceFile = sourceArtifact.getLocation();
                            try {
                                Manifest manifest;
                                try (JarFile jar = new JarFile(sourceFile);){
                                    manifest = Objects.requireNonNullElseGet(jar.getManifest(), Manifest::new);
                                }
                                IInstallableUnit unit = MavenTargetDefinitionContent.isValidSourceManifest(manifest) ? this.publish(BundlesAction.createBundleDescription((File)sourceFile), sourceFile, sourceArtifact) : this.generateSourceBundle(symbolicName, bundleVersion, manifest, sourceFile, sourceArtifact);
                                sourceBundles.add(unit);
                                if (unit == null || !logger.isDebugEnabled()) continue;
                                logger.debug("MavenResolver: source-artifact " + this.asDebugString(sourceArtifact) + ":sources at location " + sourceFile + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
                            }
                            catch (IOException | BundleException e) {
                                logger.warn("MavenResolver: source-artifact " + this.asDebugString(sourceArtifact) + ":sources at location " + sourceFile + " cannot be converted to a source bundle: " + (Exception)e);
                            }
                        }
                    }
                    catch (DependencyResolutionException e) {
                        logger.warn("MavenResolver: source-artifact " + this.asDebugString(mavenArtifact) + ":sources cannot be resolved: " + e);
                    }
                }
                if (POM_PACKAGING_TYPE.equalsIgnoreCase(mavenDependency.getArtifactType())) {
                    Optional<File> pomFacade = resolve.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).filter(facade -> facade.getDependencyTrail().size() == 1).filter(facade -> facade.getArtifactId().equals(mavenDependency.getArtifactId()) && facade.getGroupId().equals(mavenDependency.getGroupId()) && facade.getVersion().equals(mavenDependency.getVersion()) && facade.getPackagingType().equals(POM_PACKAGING_TYPE)).map(IArtifactFacade::getLocation).filter(Objects::nonNull).findFirst();
                    if (pomFacade.isPresent()) {
                        try {
                            MavenModelFacade model = mavenDependenciesResolver.loadModel(pomFacade.get());
                            features.add(FeatureGenerator.generatePomFeature(model, bundles, false, logger));
                            if (includeSource) {
                                features.add(FeatureGenerator.generatePomFeature(model, sourceBundles, true, logger));
                            }
                        }
                        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                            throw new TargetDefinitionResolutionException("non readable pom file");
                        }
                    }
                }
                locationBundles.addAll(bundles);
                locationSourceBundles.addAll(sourceBundles);
            }
            Element featureTemplate = location.getFeatureTemplate();
            if (featureTemplate != null) {
                try {
                    features.add(FeatureGenerator.createFeatureFromTemplate(featureTemplate, locationBundles, false, logger));
                    if (includeSource) {
                        features.add(FeatureGenerator.createFeatureFromTemplate(featureTemplate, locationSourceBundles, true, logger));
                    }
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    throw new TargetDefinitionResolutionException("feature generation failed!", (Throwable)e);
                }
            }
            FeaturePublisher.publishFeatures(features, this.repositoryContent::put, logger);
        }
    }

    private IInstallableUnit generateSourceBundle(String symbolicName, String bundleVersion, Manifest manifest, File sourceFile, IArtifactFacade sourceArtifact) throws IOException, BundleException {
        File tempFile = File.createTempFile("tycho_wrapped_source", ".jar");
        tempFile.deleteOnExit();
        Attributes attr = manifest.getMainAttributes();
        if (attr.isEmpty()) {
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        attr.putValue(ECLIPSE_SOURCE_BUNDLE_HEADER, symbolicName + ";version=\"" + bundleVersion + "\";roots:=\".\"");
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-Name", "Source Bundle for " + symbolicName + ":" + bundleVersion);
        attr.putValue("Bundle-SymbolicName", symbolicName + ".source");
        attr.putValue("Bundle-Version", bundleVersion);
        try (JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(tempFile), manifest);
             JarFile jar = new JarFile(sourceFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                InputStream is = jar.getInputStream(jarEntry);
                try {
                    stream.putNextEntry(new ZipEntry(jarEntry.getName()));
                    is.transferTo(stream);
                    stream.closeEntry();
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return this.publish(BundlesAction.createBundleDescription((File)tempFile), tempFile, sourceArtifact);
    }

    private IInstallableUnit publish(BundleDescription bundleDescription, File bundleLocation, IArtifactFacade mavenArtifact) {
        return this.publish(bundleDescription, bundleLocation, (IPropertyAdvice)new TychoMavenPropertiesAdvice(mavenArtifact, this.mavenContext));
    }

    private IInstallableUnit publish(BundleDescription bundleDescription, File bundleLocation, IPropertyAdvice advice) {
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = FileArtifactRepository.forFile(bundleLocation, key);
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.addAdvice((IPublisherAdvice)advice);
        publisherInfo.addAdvice((IPublisherAdvice)new MavenChecksumAdvice(bundleLocation));
        publisherInfo.setArtifactOptions(1);
        IInstallableUnit iu = BundlePublisher.publishBundle(bundleDescription, descriptor, publisherInfo);
        this.repositoryContent.put(descriptor, iu);
        return iu;
    }

    private String asDebugString(IArtifactFacade mavenArtifact) {
        return new GAV(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion()).toString();
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    private static String getKey(Artifact artifact) {
        if (artifact == null) {
            return "";
        }
        String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            key = key + ":" + classifier;
        }
        key = key + ":" + artifact.getVersion();
        return key;
    }

    private static boolean isValidSourceManifest(Manifest manifest) {
        if (manifest != null) {
            return manifest.getMainAttributes().getValue(ECLIPSE_SOURCE_BUNDLE_HEADER) != null;
        }
        return false;
    }
}

